/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.tile.tank;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.InvUtils;
import latmod.core.tile.Tank;
import latmod.latblocks.LatBlocksItems;
import latmod.latblocks.tile.tank.TileTankBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileWaterTank
extends TileTankBase {
    public static final FluidStack WATER_1000 = new FluidStack(FluidRegistry.WATER, 1000);

    public TileWaterTank() {
        this.tank = new Tank("Tank", 1.0){

            public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
                return 0;
            }

            public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
                return resource.copy();
            }

            public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
                return new FluidStack(FluidRegistry.WATER, maxDrain);
            }

            public boolean canFill(ForgeDirection from, Fluid fluid) {
                return false;
            }

            public boolean canDrain(ForgeDirection from, Fluid fluid) {
                return true;
            }
        };
        this.tank.fluidTank.setFluid(new FluidStack(FluidRegistry.WATER, this.tank.getCapacity()));
    }

    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K && this.tick % 10L == 0L && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1) {
            for (int i = 0; i < 6; ++i) {
                IFluidHandler h;
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                if (te == null || te.func_145837_r() || !(te instanceof IFluidHandler) || !(h = (IFluidHandler)te).canFill(dir.getOpposite(), FluidRegistry.WATER)) continue;
                h.fill(dir.getOpposite(), new FluidStack(FluidRegistry.WATER, 1000), true);
            }
        }
    }

    public boolean onRightClick(EntityPlayer ep, ItemStack is, int side, float x, float y, float z) {
        FluidStack available;
        ItemStack filled;
        if (is == null && ep.func_70093_af()) {
            if (!this.field_145850_b.field_72995_K) {
                this.getMeta();
                this.setMeta(1 - this.field_145847_g);
                this.func_70296_d();
            }
            return true;
        }
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)is);
        if (liquid == null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)(available = new FluidStack(FluidRegistry.WATER, 1000)), (ItemStack)is)))) != null) {
            if (!ep.field_71075_bZ.field_75098_d) {
                if (is.field_77994_a > 1) {
                    if (!ep.field_71071_by.func_70441_a(filled)) {
                        return false;
                    }
                    ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, InvUtils.reduceItem((ItemStack)is));
                    ep.field_71071_by.func_70296_d();
                    this.func_70296_d();
                } else {
                    ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, InvUtils.reduceItem((ItemStack)is));
                    ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, filled);
                    ep.field_71071_by.func_70296_d();
                    this.func_70296_d();
                }
            }
            this.drain(ForgeDirection.UNKNOWN, liquid.amount, true);
            return true;
        }
        return is != null && !(is.func_77973_b() instanceof ItemBlock);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTankBorderIcon() {
        return this.field_145847_g == 1 ? LatBlocksItems.b_tank_water.icon_on : LatBlocksItems.b_tank_water.getBlockIcon();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Fluid getTankRenderFluid() {
        return FluidRegistry.WATER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double getTankFluidHeight() {
        return 1.0;
    }
}

