/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.tile;

import latmod.core.tile.IPaintable;
import latmod.latblocks.block.paintable.BlockPaintableLamp;
import latmod.latblocks.tile.TileSidedPaintable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePaintableRS
extends TileSidedPaintable {
    public final IPaintable.Paint[] paint_on = new IPaintable.Paint[6];
    public int power = 0;

    @Override
    public boolean rerenderBlock() {
        return true;
    }

    @Override
    public void readTileData(NBTTagCompound tag) {
        super.readTileData(tag);
        IPaintable.Paint.readFromNBT((NBTTagCompound)tag, (String)"TexturesOn", (IPaintable.Paint[])this.paint_on);
        this.power = tag.func_74771_c("Power");
    }

    @Override
    public void writeTileData(NBTTagCompound tag) {
        super.writeTileData(tag);
        IPaintable.Paint.writeToNBT((NBTTagCompound)tag, (String)"TexturesOn", (IPaintable.Paint[])this.paint_on);
        tag.func_74774_a("Power", (byte)this.power);
    }

    public void onUpdate() {
    }

    public void onNeighborBlockChange(Block block) {
        if (this.isServer()) {
            int pP = this.power;
            this.power = 0;
            if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.power = 32;
            } else {
                int b = 0;
                for (int i = 0; i < 6; ++i) {
                    ForgeDirection f = ForgeDirection.VALID_DIRECTIONS[i];
                    TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + f.offsetX, this.field_145848_d + f.offsetY, this.field_145849_e + f.offsetZ);
                    if (te == null || te.func_145837_r() || !(te instanceof TilePaintableRS) && !(te instanceof BlockPaintableLamp.TilePaintableLamp)) continue;
                    b = Math.max(b, ((TilePaintableRS)te).power);
                }
                if (b > 0) {
                    this.power = b - 1;
                }
                if (this.power > 32) {
                    this.power = 32;
                }
            }
            if (this.power != pP) {
                this.func_70296_d();
                this.notifyNeighbors();
            }
        }
    }

    @Override
    public IPaintable.Paint getPaint(int side) {
        return this.power > 0 ? this.paint_on[side] : this.paint[side];
    }

    @Override
    public void setPaint(int side, IPaintable.Paint p) {
        if (this.power > 0) {
            this.paint_on[side] = p;
        } else {
            this.paint[side] = p;
        }
    }

    public int iconMeta() {
        return this.power > 0 ? 1 : 0;
    }
}

