/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.client.render.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.client.BlockRendererLM;
import latmod.core.mod.LCConfig;
import latmod.core.util.MathHelperLM;
import latmod.latblocks.block.tank.BlockTankBase;
import latmod.latblocks.tile.tank.TileTankBase;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderTank
extends BlockRendererLM
implements IItemRenderer {
    public static final RenderTank instance = new RenderTank();
    private static final AxisAlignedBB[] boxes = new AxisAlignedBB[12];
    public static IIcon icon_inside = null;

    public void renderInventoryBlock(Block b, int meta, int modelID, RenderBlocks rb) {
    }

    public boolean renderWorldBlock(IBlockAccess iba, int x, int y, int z, Block b, int modelID, RenderBlocks rb) {
        this.renderBlocks.field_147837_f = true;
        this.renderBlocks.field_147845_a = iba;
        this.renderBlocks.setCustomColor(null);
        TileTankBase t = (TileTankBase)iba.func_147438_o(x, y, z);
        if (t == null || t.func_145837_r()) {
            return false;
        }
        this.renderBlocks.func_147757_a(t.getTankBorderIcon());
        for (int i = 0; i < boxes.length; ++i) {
            this.renderBlocks.setRenderBounds(boxes[i]);
            this.renderBlocks.func_147784_q(Blocks.field_150348_b, x, y, z);
        }
        double p = 0.0625;
        this.renderBlocks.func_147782_a(p, p, p, 1.0 - p, 1.0 - p, 1.0 - p);
        this.renderBlocks.func_147757_a(icon_inside);
        this.renderBlocks.func_147784_q(Blocks.field_150348_b, x, y, z);
        Fluid f = t.getTankRenderFluid();
        if (f != null) {
            double fluid_height = t.getTankFluidHeight();
            IIcon icon_fluid = null;
            if (fluid_height > 0.0 && (icon_fluid = f.getStillIcon()) != null) {
                double op = p + 0.001;
                double h1 = MathHelperLM.map((double)fluid_height, (double)0.0, (double)1.0, (double)op, (double)(1.0 - op));
                this.renderBlocks.func_147782_a(op, op, op, 1.0 - op, h1, 1.0 - op);
                this.renderBlocks.func_147757_a(icon_fluid);
                this.renderBlocks.func_147784_q(Blocks.field_150348_b, x, y, z);
            }
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int renderID) {
        return true;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper != IItemRenderer.ItemRendererHelper.ENTITY_ROTATION || !LCConfig.Client.rotateBlocks;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.renderBlocks.field_147837_f = true;
        this.renderBlocks.setCustomColor(null);
        BlockTankBase tb = (BlockTankBase)Block.func_149634_a((Item)item.func_77973_b());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        double p = 0.0625;
        GL11.glPushMatrix();
        RenderTank.rotateBlocks();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3008);
        this.renderBlocks.func_147757_a(tb.getTankItemBorderIcon(item));
        for (int i = 0; i < boxes.length; ++i) {
            GL11.glPushMatrix();
            this.renderBlocks.setRenderBounds(boxes[i]);
            this.renderBlocks.func_147800_a(Blocks.field_150348_b, 0, 1.0f);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        this.renderBlocks.func_147782_a(p, p, p, 1.0 - p, 1.0 - p, 1.0 - p);
        this.renderBlocks.func_147757_a(icon_inside);
        this.renderBlocks.func_147800_a(Blocks.field_150348_b, 0, 1.0f);
        GL11.glPopMatrix();
        FluidStack fluid = tb.getTankItemFluid(item);
        if (fluid != null && fluid.getFluid() != null && fluid.amount > 0) {
            double op = p + 0.001;
            double h1 = MathHelperLM.map((double)Math.min((double)fluid.amount / 1000.0, 1.0), (double)0.0, (double)1.0, (double)op, (double)(1.0 - op));
            GL11.glPushMatrix();
            this.renderBlocks.func_147782_a(op, op, op, 1.0 - op, h1, 1.0 - op);
            this.renderBlocks.func_147757_a(fluid.getFluid().getStillIcon());
            this.renderBlocks.func_147800_a(Blocks.field_150348_b, 0, 1.0f);
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    static {
        double p = 0.0615;
        RenderTank.boxes[0] = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)p, (double)1.0, (double)p);
        RenderTank.boxes[1] = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)(1.0 - p), (double)p, (double)1.0, (double)1.0);
        RenderTank.boxes[2] = AxisAlignedBB.func_72330_a((double)(1.0 - p), (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)p);
        RenderTank.boxes[3] = AxisAlignedBB.func_72330_a((double)(1.0 - p), (double)0.0, (double)(1.0 - p), (double)1.0, (double)1.0, (double)1.0);
        RenderTank.boxes[4] = AxisAlignedBB.func_72330_a((double)p, (double)0.0, (double)0.0, (double)(1.0 - p), (double)p, (double)p);
        RenderTank.boxes[5] = AxisAlignedBB.func_72330_a((double)p, (double)0.0, (double)(1.0 - p), (double)(1.0 - p), (double)p, (double)1.0);
        RenderTank.boxes[6] = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)p, (double)p, (double)p, (double)(1.0 - p));
        RenderTank.boxes[7] = AxisAlignedBB.func_72330_a((double)(1.0 - p), (double)0.0, (double)p, (double)1.0, (double)p, (double)(1.0 - p));
        RenderTank.boxes[8] = AxisAlignedBB.func_72330_a((double)p, (double)(1.0 - p), (double)0.0, (double)(1.0 - p), (double)1.0, (double)p);
        RenderTank.boxes[9] = AxisAlignedBB.func_72330_a((double)p, (double)(1.0 - p), (double)(1.0 - p), (double)(1.0 - p), (double)1.0, (double)1.0);
        RenderTank.boxes[10] = AxisAlignedBB.func_72330_a((double)0.0, (double)(1.0 - p), (double)p, (double)p, (double)1.0, (double)(1.0 - p));
        RenderTank.boxes[11] = AxisAlignedBB.func_72330_a((double)(1.0 - p), (double)(1.0 - p), (double)p, (double)1.0, (double)1.0, (double)(1.0 - p));
    }
}

