/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.block.tank;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.tile.TileLM;
import latmod.core.util.FastList;
import latmod.core.util.MathHelperLM;
import latmod.latblocks.LatBlocks;
import latmod.latblocks.LatBlocksConfig;
import latmod.latblocks.block.tank.BlockTankBase;
import latmod.latblocks.block.tank.TankCraftingHandler;
import latmod.latblocks.item.ItemMaterialsLB;
import latmod.latblocks.tile.tank.TileTank;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.RecipeSorter;

public class BlockTank
extends BlockTankBase {
    public static ItemStack TANK_BASIC = new ItemStack(Blocks.field_150359_w, 1, 0);
    @SideOnly(value=Side.CLIENT)
    public IIcon[] icons;

    public BlockTank(String s) {
        super(s);
        LatBlocks.mod.addTile(TileTank.class, s, new String[0]);
    }

    public void onPostLoaded() {
        this.addAllDamages(6);
        TANK_BASIC = new ItemStack((Block)this, 1, 0);
    }

    @Override
    public void loadRecipes() {
        if (LatBlocksConfig.General.tankCraftingHandler) {
            RecipeSorter.register((String)"latblocks:tanks", TankCraftingHandler.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:minecraft:shaped");
            TankCraftingHandler.register(new ItemStack((Block)this, 1, 1), new ItemStack((Block)this, 1, 0), new ItemStack(Items.field_151042_j));
            TankCraftingHandler.register(new ItemStack((Block)this, 1, 2), new ItemStack((Block)this, 1, 1), new ItemStack(Items.field_151043_k));
            TankCraftingHandler.register(new ItemStack((Block)this, 1, 3), new ItemStack((Block)this, 1, 2), new ItemStack(Items.field_151128_bU));
            TankCraftingHandler.register(new ItemStack((Block)this, 1, 4), new ItemStack((Block)this, 1, 3), new ItemStack(Items.field_151045_i));
            if (LatBlocksConfig.Crafting.endlessTank) {
                TankCraftingHandler.register(new ItemStack((Block)this, 1, 5), new ItemStack((Block)this, 1, 4), ItemMaterialsLB.STAR_DUST);
            }
        }
        this.mod.recipes.addRecipe(new ItemStack((Block)this, 1, 0), new Object[]{"SGS", "G G", "SGS", Character.valueOf('G'), "blockGlassColorless", Character.valueOf('S'), "stickWood"});
        this.mod.recipes.addRecipe(new ItemStack((Block)this, 1, 1), new Object[]{"TTT", "TIT", "TTT", Character.valueOf('T'), new ItemStack((Block)this, 1, 0), Character.valueOf('I'), "ingotIron"});
        this.mod.recipes.addRecipe(new ItemStack((Block)this, 1, 2), new Object[]{"TTT", "TIT", "TTT", Character.valueOf('T'), new ItemStack((Block)this, 1, 1), Character.valueOf('I'), "ingotGold"});
        this.mod.recipes.addRecipe(new ItemStack((Block)this, 1, 3), new Object[]{"TTT", "TIT", "TTT", Character.valueOf('T'), new ItemStack((Block)this, 1, 2), Character.valueOf('I'), "gemQuartz"});
        this.mod.recipes.addRecipe(new ItemStack((Block)this, 1, 4), new Object[]{"TTT", "TIT", "TTT", Character.valueOf('T'), new ItemStack((Block)this, 1, 3), Character.valueOf('I'), "gemDiamond"});
        if (LatBlocksConfig.Crafting.endlessTank) {
            this.mod.recipes.addRecipe(new ItemStack((Block)this, 1, 5), new Object[]{"TTT", "TIT", "TTT", Character.valueOf('T'), new ItemStack((Block)this, 1, 4), Character.valueOf('I'), ItemMaterialsLB.STAR_DUST});
        }
    }

    public int func_149692_a(int i) {
        return i;
    }

    public TileLM createNewTileEntity(World w, int m) {
        return new TileTank(m);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        this.icons = new IIcon[6];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = ir.func_94245_a(this.mod.assets + "tank/outside_" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInfo(ItemStack is, EntityPlayer ep, FastList<String> l) {
        int meta;
        if (is.func_77942_o() && is.field_77990_d.func_74764_b("Fluid")) {
            FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)is.field_77990_d.func_74775_l("Fluid"));
            l.add((Object)("Stored: " + fs.amount + "mB of " + fs.getLocalizedName()));
        }
        if ((meta = is.func_77960_j()) == 5) {
            l.add((Object)"Capacity: Endless");
            return;
        }
        int c = 1;
        if (meta == 1) {
            c = 8;
        } else if (meta == 2) {
            c = 64;
        } else if (meta == 3) {
            c = 512;
        } else if (meta == 4) {
            c = 4096;
        }
        l.add((Object)("Capacity: " + c + MathHelperLM.getPluralWord((int)c, (String)" bucket", (String)" buckets")));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTankItemBorderIcon(ItemStack item) {
        return this.icons[item.func_77960_j()];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public FluidStack getTankItemFluid(ItemStack item) {
        if (item.func_77942_o() && item.field_77990_d.func_74764_b("Fluid")) {
            FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)item.field_77990_d.func_74775_l("Fluid"));
            int meta = item.func_77960_j();
            double c = 1000.0;
            if (meta == 1) {
                c = 8000.0;
            } else if (meta == 2) {
                c = 64000.0;
            } else if (meta == 3) {
                c = 512000.0;
            } else if (meta == 4) {
                c = 4096000.0;
            } else if (meta == 5) {
                c = fs.amount;
            }
            fs.amount = (int)MathHelperLM.map((double)fs.amount, (double)0.0, (double)c, (double)0.0, (double)1000.0);
            return fs;
        }
        return null;
    }
}

