/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.block.paintable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.util.FastList;
import latmod.core.util.MathHelperLM;
import latmod.latblocks.block.BlockPaintableSingle;
import latmod.latblocks.item.ItemMaterialsLB;
import latmod.latblocks.tile.TilePaintableLB;
import latmod.latblocks.tile.TileSinglePaintable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPLadder
extends BlockPaintableSingle {
    public static final AxisAlignedBB[] ladder_boxes = new AxisAlignedBB[6];

    public BlockPLadder(String s) {
        super(s, 0.125f);
    }

    @Override
    public TilePaintableLB createNewTileEntity(World w, int m) {
        return new TilePLadder();
    }

    public void loadRecipes() {
        this.mod.recipes.addRecipe(new ItemStack((Block)this, 2), new Object[]{"S S", "SSS", "S S", Character.valueOf('S'), ItemMaterialsLB.ROD});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addItemRenderBoxes(FastList<AxisAlignedBB> boxes) {
        boxes.addAll((Object[])ladder_boxes);
    }

    @Override
    public int onBlockPlaced(World w, EntityPlayer ep, MovingObjectPosition mop, int m) {
        int i = super.onBlockPlaced(w, ep, mop, m);
        if (i == 0 || i == 1) {
            return -1;
        }
        return i;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(FastList<AxisAlignedBB> boxes, DrawBlockHighlightEvent event) {
        if (this.onBlockPlaced(event.player.field_70170_p, event.player, event.target, -1) == -1) {
            return;
        }
        super.drawHighlight(boxes, event);
    }

    @Override
    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        int m = iba.func_72805_g(x, y, z);
        if (m == 0) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, this.height, 1.0f);
        } else if (m == 1) {
            this.func_149676_a(0.0f, 1.0f - this.height, 0.0f, 1.0f, 1.0f, 1.0f);
        } else if (m == 2) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, this.height);
        } else if (m == 3) {
            this.func_149676_a(0.0f, 0.0f, 1.0f - this.height, 1.0f, 1.0f, 1.0f);
        } else if (m == 4) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, this.height, 1.0f, 1.0f);
        } else if (m == 5) {
            this.func_149676_a(1.0f - this.height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void addBoxes(FastList<AxisAlignedBB> boxes, IBlockAccess iba, int x, int y, int z, int m) {
        super.addBoxes(boxes, iba, x, y, z, m);
    }

    public boolean isLadder(IBlockAccess iba, int x, int y, int z, EntityLivingBase e) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addRenderBoxes(FastList<AxisAlignedBB> boxes0, IBlockAccess iba, int x, int y, int z, int m) {
        if (m == -1) {
            m = iba.func_72805_g(x, y, z);
        }
        Object[] boxes = (AxisAlignedBB[])ladder_boxes.clone();
        ForgeDirection f = ForgeDirection.VALID_DIRECTIONS[m];
        double shift = 0.4375;
        for (int i = 0; i < boxes.length; ++i) {
            boxes[i] = MathHelperLM.rotate90BoxV((AxisAlignedBB)boxes[i], (ForgeDirection)f);
            boxes[i] = boxes[i].func_72325_c((double)f.offsetX * shift, 0.0, (double)f.offsetZ * shift);
        }
        boxes0.addAll(boxes);
    }

    static {
        double c0 = 0.4375;
        double c1 = 0.5625;
        double d = 0.0625;
        double dz = 0.015625;
        BlockPLadder.ladder_boxes[0] = AxisAlignedBB.func_72330_a((double)d, (double)0.0, (double)c0, (double)(d * 3.0), (double)1.0, (double)c1);
        BlockPLadder.ladder_boxes[1] = AxisAlignedBB.func_72330_a((double)(d * 13.0), (double)0.0, (double)c0, (double)(d * 15.0), (double)1.0, (double)c1);
        BlockPLadder.ladder_boxes[2] = AxisAlignedBB.func_72330_a((double)0.0, (double)(d * 1.0), (double)(c0 + dz), (double)1.0, (double)(d * 3.0), (double)(c1 - dz));
        BlockPLadder.ladder_boxes[3] = AxisAlignedBB.func_72330_a((double)0.0, (double)(d * 5.0), (double)(c0 + dz), (double)1.0, (double)(d * 7.0), (double)(c1 - dz));
        BlockPLadder.ladder_boxes[4] = AxisAlignedBB.func_72330_a((double)0.0, (double)(d * 9.0), (double)(c0 + dz), (double)1.0, (double)(d * 11.0), (double)(c1 - dz));
        BlockPLadder.ladder_boxes[5] = AxisAlignedBB.func_72330_a((double)0.0, (double)(d * 13.0), (double)(c0 + dz), (double)1.0, (double)(d * 15.0), (double)(c1 - dz));
    }

    public static class TilePLadder
    extends TileSinglePaintable {
    }
}

