/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import latmod.core.ParticleHelper;
import latmod.core.tile.IPaintable;
import latmod.core.util.FastList;
import latmod.core.util.MathHelperLM;
import latmod.latblocks.LatBlocksItems;
import latmod.latblocks.block.BlockLB;
import latmod.latblocks.client.render.world.RenderPaintable;
import latmod.latblocks.item.ItemGlasses;
import latmod.latblocks.tile.TilePaintableLB;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockPaintableLB
extends BlockLB {
    public BlockPaintableLB(String s) {
        super(s, Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149658_d("paintable");
        this.field_149758_A = true;
        this.registerTiles();
    }

    public abstract TilePaintableLB createNewTileEntity(World var1, int var2);

    @Override
    public void addCollisionBoxes(World w, int x, int y, int z, int m, FastList<AxisAlignedBB> boxes, Entity e) {
        this.addBoxes(boxes, (IBlockAccess)w, x, y, z, m);
    }

    public int func_149692_a(int i) {
        return 0;
    }

    public void registerTiles() {
        this.mod.addTile(((Object)((Object)this.createNewTileEntity(null, 0))).getClass(), this.blockName, new String[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return RenderPaintable.instance.getRenderId();
    }

    public int onBlockPlaced(World w, EntityPlayer ep, MovingObjectPosition mop, int m) {
        return m;
    }

    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        FastList boxes = new FastList();
        this.addBoxes((FastList<AxisAlignedBB>)boxes, iba, x, y, z, -1);
        this.field_149754_D = 1.0;
        this.field_149760_C = 1.0;
        this.field_149759_B = 1.0;
        this.field_149757_G = 0.0;
        this.field_149756_F = 0.0;
        this.field_149755_E = 0.0;
        for (int i = 0; i < boxes.size(); ++i) {
            AxisAlignedBB bb = (AxisAlignedBB)boxes.get(i);
            if (bb.field_72340_a < this.field_149759_B) {
                this.field_149759_B = Math.max(bb.field_72340_a, 0.0);
            }
            if (bb.field_72338_b < this.field_149760_C) {
                this.field_149760_C = Math.max(bb.field_72338_b, 0.0);
            }
            if (bb.field_72339_c < this.field_149754_D) {
                this.field_149754_D = Math.max(bb.field_72339_c, 0.0);
            }
            if (bb.field_72336_d > this.field_149755_E) {
                this.field_149755_E = Math.min(bb.field_72336_d, 1.0);
            }
            if (bb.field_72337_e > this.field_149756_F) {
                this.field_149756_F = Math.min(bb.field_72337_e, 1.0);
            }
            if (!(bb.field_72334_f > this.field_149757_G)) continue;
            this.field_149757_G = Math.min(bb.field_72334_f, 1.0);
        }
    }

    public AxisAlignedBB func_149668_a(World w, int x, int y, int z) {
        return super.func_149668_a(w, x, y, z);
    }

    public boolean canHarvestBlock(EntityPlayer ep, int meta) {
        return true;
    }

    public final int getPlacedMeta(EntityPlayer ep, MovingObjectPosition mop) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void addRenderBoxes(FastList<AxisAlignedBB> boxes, IBlockAccess iba, int x, int y, int z, int m) {
        this.addBoxes(boxes, iba, x, y, z, m);
    }

    public void addBoxes(FastList<AxisAlignedBB> boxes, IBlockAccess iba, int x, int y, int z, int m) {
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void addItemRenderBoxes(FastList<AxisAlignedBB> boxes) {
        this.func_149683_g();
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)this.field_149759_B, (double)this.field_149760_C, (double)this.field_149754_D, (double)this.field_149755_E, (double)this.field_149756_F, (double)this.field_149757_G));
    }

    @SideOnly(value=Side.CLIENT)
    public void getPlacementBoxes(FastList<AxisAlignedBB> boxes, DrawBlockHighlightEvent event) {
        int m = this.onBlockPlaced(event.player.field_70170_p, event.player, event.target, -1);
        if (m == -1) {
            return;
        }
        ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[event.target.field_72310_e];
        this.addRenderBoxes(boxes, (IBlockAccess)event.player.field_70170_p, event.target.field_72311_b + fd.offsetX, event.target.field_72312_c + fd.offsetY, event.target.field_72309_d + fd.offsetZ, m);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(FastList<AxisAlignedBB> boxes, DrawBlockHighlightEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World w, int x, int y, int z) {
        FastList boxes = new FastList();
        this.addBoxes((FastList<AxisAlignedBB>)boxes, (IBlockAccess)w, x, y, z, -1);
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        if (mop.subHit >= 0 && mop.subHit < boxes.size()) {
            return ((AxisAlignedBB)boxes.get(mop.subHit)).func_72325_c((double)x, (double)y, (double)z);
        }
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public MovingObjectPosition func_149731_a(World w, int x, int y, int z, Vec3 start, Vec3 end) {
        FastList boxes = new FastList();
        this.addBoxes((FastList<AxisAlignedBB>)boxes, (IBlockAccess)w, x, y, z, -1);
        return MathHelperLM.collisionRayTrace((World)w, (int)x, (int)y, (int)z, (Vec3)start, (Vec3)end, (FastList)boxes);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getDefaultWorldIcon(IBlockAccess iba, int x, int y, int z, int s) {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getDefaultItemIcon() {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149734_b(World w, int x, int y, int z, Random r) {
        TilePaintableLB t;
        if (ItemGlasses.hasClientPlayer() && (t = (TilePaintableLB)w.func_147438_o(x, y, z)) != null) {
            for (int i = 0; i < 6; ++i) {
                IPaintable.Paint p = t.getPaint(i);
                if (p == null || p.block != LatBlocksItems.b_glass || p.meta != 0) continue;
                ItemGlasses.spawnInvParticles(w, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3);
                return;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World w, MovingObjectPosition mop, EffectRenderer er) {
        int x = mop.field_72311_b;
        int y = mop.field_72312_c;
        int z = mop.field_72309_d;
        TilePaintableLB cb = (TilePaintableLB)w.func_147438_o(x, y, z);
        IPaintable.Paint p = cb.getPaint(mop.field_72310_e);
        if (p == null || p.block == null) {
            return false;
        }
        IPaintable.BlockAccess iba = new IPaintable.BlockAccess((IBlockAccess)w, x, y, z, p);
        IIcon tex = p.block.func_149673_e((IBlockAccess)iba, x, y, z, mop.field_72310_e);
        if (tex == null) {
            tex = this.field_149761_L;
        }
        this.addBlockHitEffects(w, er, x, y, z, mop.field_72310_e, tex);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World w, int x, int y, int z, int meta, EffectRenderer er) {
        IPaintable.Paint p;
        TilePaintableLB cb = (TilePaintableLB)w.func_147438_o(x, y, z);
        int side = 1;
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        if (mop != null && mop.field_72311_b == x && mop.field_72312_c == y && mop.field_72309_d == z) {
            side = mop.field_72310_e;
        }
        if ((p = cb.getPaint(side)) == null || p.block == null) {
            return false;
        }
        IPaintable.BlockAccess iba = new IPaintable.BlockAccess((IBlockAccess)w, x, y, z, p);
        IIcon tex = p.block.func_149673_e((IBlockAccess)iba, x, y, z, side);
        if (tex == null) {
            tex = this.field_149761_L;
        }
        int b0 = 4;
        for (int x1 = 0; x1 < b0; ++x1) {
            for (int y1 = 0; y1 < b0; ++y1) {
                for (int z1 = 0; z1 < b0; ++z1) {
                    double d0 = (double)x + ((double)x1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)y1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)z1 + 0.5) / (double)b0;
                    int i2 = ParticleHelper.rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(w, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, (Block)this, i2, 0).func_70596_a(x, y, z);
                    fx.func_110125_a(tex);
                    er.func_78873_a((EntityFX)fx);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(World w, EffectRenderer er, int x, int y, int z, int side, IIcon tex) {
        float f = 0.1f;
        double d0 = (double)x + ParticleHelper.rand.nextDouble() * (this.func_149753_y() - this.func_149704_x() - (double)(f * 2.0f)) + (double)f + this.func_149704_x();
        double d1 = (double)y + ParticleHelper.rand.nextDouble() * (this.func_149669_A() - this.func_149665_z() - (double)(f * 2.0f)) + (double)f + this.func_149665_z();
        double d2 = (double)z + ParticleHelper.rand.nextDouble() * (this.func_149693_C() - this.func_149706_B() - (double)(f * 2.0f)) + (double)f + this.func_149706_B();
        if (side == 0) {
            d1 = (double)y + this.func_149665_z() - (double)f;
        } else if (side == 1) {
            d1 = (double)y + this.func_149669_A() + (double)f;
        } else if (side == 2) {
            d2 = (double)z + this.func_149706_B() - (double)f;
        } else if (side == 3) {
            d2 = (double)z + this.func_149693_C() + (double)f;
        } else if (side == 4) {
            d0 = (double)x + this.func_149704_x() - (double)f;
        } else if (side == 5) {
            d0 = (double)x + this.func_149753_y() + (double)f;
        }
        EntityDiggingFX digFX = new EntityDiggingFX(w, d0, d1, d2, 0.0, 0.0, 0.0, (Block)this, side, 0);
        digFX.func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f);
        digFX.func_110125_a(tex);
        er.func_78873_a((EntityFX)digFX);
    }
}

