/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.api.tileentity.ISortingInventory;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingInventoryHandler;
import com.dynious.refinedrelocation.block.ModBlocks;
import com.dynious.refinedrelocation.helper.ItemStackHelper;
import com.pahimar.ee3.tileentity.TileEntityAlchemicalChest;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileSortingAlchemicalChest
extends TileEntityAlchemicalChest
implements ISortingInventory,
IFilterTileGUI {
    public boolean isFirstRun = true;
    private IFilterGUI filter = APIUtils.createStandardFilter(this);
    private ISortingInventoryHandler sortingInventoryHandler = APIUtils.createSortingInventoryHandler((TileEntity)this);
    private ISortingInventory.Priority priority = ISortingInventory.Priority.NORMAL;

    public TileSortingAlchemicalChest() {
        super(0);
    }

    public TileSortingAlchemicalChest(int metaData) {
        super(metaData);
    }

    public void func_145845_h() {
        if (this.isFirstRun) {
            this.sortingInventoryHandler.onTileAdded();
            this.isFirstRun = false;
        }
        super.func_145845_h();
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.sortingInventoryHandler.setInventorySlotContents(i, itemstack);
    }

    @Override
    public final boolean putStackInSlot(ItemStack itemStack, int slotIndex) {
        super.func_70299_a(slotIndex, itemStack);
        return true;
    }

    @Override
    public ItemStack putInInventory(ItemStack itemStack, boolean simulate) {
        int emptySlot = -1;
        for (int slot = 0; slot < this.func_70302_i_() && itemStack != null && itemStack.field_77994_a > 0; ++slot) {
            int max;
            if (!this.func_94041_b(slot, itemStack)) continue;
            ItemStack itemstack1 = this.func_70301_a(slot);
            if (itemstack1 == null) {
                if (simulate) {
                    return null;
                }
                if (emptySlot != -1) continue;
                emptySlot = slot;
                continue;
            }
            if (!ItemStackHelper.areItemStacksEqual(itemstack1, itemStack) || (max = Math.min(itemStack.func_77976_d(), this.func_70297_j_())) <= itemstack1.field_77994_a) continue;
            int l = Math.min(itemStack.field_77994_a, max - itemstack1.field_77994_a);
            itemStack.field_77994_a -= l;
            if (simulate) continue;
            itemstack1.field_77994_a += l;
            this.func_70296_d();
        }
        if (itemStack != null && itemStack.field_77994_a != 0 && emptySlot != -1) {
            super.func_70299_a(emptySlot, itemStack);
            itemStack = null;
            this.func_70296_d();
        }
        return itemStack;
    }

    @Override
    public IFilterGUI getFilter() {
        return this.filter;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public void onFilterChanged() {
        this.func_70296_d();
    }

    @Override
    public ISortingInventory.Priority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(ISortingInventory.Priority priority) {
        this.priority = priority;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.getHandler().onInventoryChange();
    }

    @Override
    public ISortingInventoryHandler getHandler() {
        return this.sortingInventoryHandler;
    }

    public boolean upgradeChest(int upgradeMetadata) {
        if (upgradeMetadata > this.func_145832_p()) {
            if (this.numUsingPlayers > 0) {
                return false;
            }
            TileSortingAlchemicalChest newChest = (TileSortingAlchemicalChest)ModBlocks.sortingAlchemicalChest.createTileEntity(this.field_145850_b, upgradeMetadata);
            newChest.setOrientation(this.getOrientation());
            for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
                newChest.putStackInSlot(this.func_70301_a(slot), slot);
                this.func_70299_a(slot, null);
            }
            NBTTagCompound tag = new NBTTagCompound();
            this.getFilter().writeToNBT(tag);
            newChest.getFilter().readFromNBT(tag);
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, upgradeMetadata, 3);
            this.field_145850_b.func_147455_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)newChest);
            return true;
        }
        return false;
    }

    private void fixState(byte state) {
        ItemStack[] inventory = new ItemStack[48];
        if (state == 1) {
            inventory = new ItemStack[84];
        } else if (state == 2) {
            inventory = new ItemStack[117];
        }
        ReflectionHelper.setPrivateValue(TileEntityAlchemicalChest.class, (Object)this, (Object)inventory, (String[])new String[]{"inventory"});
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.fixState(compound.func_74771_c("state"));
        super.func_145839_a(compound);
        this.filter.readFromNBT(compound);
        if (compound.func_74764_b("priority")) {
            this.setPriority(ISortingInventory.Priority.values()[compound.func_74771_c("priority")]);
        } else {
            this.setPriority(this.filter.isBlacklisting() ? ISortingInventory.Priority.LOW : ISortingInventory.Priority.NORMAL);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        compound.func_74774_a("state", this.state);
        super.func_145841_b(compound);
        this.filter.writeToNBT(compound);
        compound.func_74774_a("priority", (byte)this.priority.ordinal());
    }

    public void func_145843_s() {
        this.sortingInventoryHandler.onTileRemoved();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.sortingInventoryHandler.onTileRemoved();
        super.onChunkUnload();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }
}

