/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.relocator.IItemRelocator;
import com.dynious.refinedrelocation.api.relocator.IRelocatorModule;
import com.dynious.refinedrelocation.api.relocator.RelocatorModuleBase;
import com.dynious.refinedrelocation.client.gui.GuiModuleCrafting;
import com.dynious.refinedrelocation.container.ContainerModuleCrafting;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.helper.ItemStackHelper;
import com.dynious.refinedrelocation.item.ModItems;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.lib.Settings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class RelocatorModuleCrafting
extends RelocatorModuleBase {
    private static IIcon icon;
    public final LocalInventoryCrafting CRAFT_MATRIX = new LocalInventoryCrafting();
    public final IInventory CRAFT_RESULT = new InventoryCraftResult();
    public int craftTick = 0;
    public int normalTick = 0;
    public ItemStack outputStack = null;
    public boolean isStuffed = false;
    private int maxCraftStack = 64;
    private boolean input = false;

    @Override
    public boolean isItemDestination() {
        return true;
    }

    @Override
    public ItemStack receiveItemStack(IItemRelocator relocator, int side, ItemStack stack, boolean input, boolean simulate) {
        if (stack == null) {
            return null;
        }
        if (!simulate) {
            this.input = input;
            int currentAmount = 0;
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < this.CRAFT_MATRIX.func_70302_i_(); ++i) {
                ItemStack craftStack = this.CRAFT_MATRIX.func_70301_a(i);
                if (!ItemStackHelper.areItemStacksEqual(stack, craftStack)) continue;
                currentAmount += craftStack.field_77994_a;
                slots.add(i);
            }
            if (slots.isEmpty()) {
                return stack;
            }
            int needed = slots.size() * this.maxCraftStack - currentAmount;
            if (needed < 0) {
                return stack;
            }
            int toMove = Math.min(needed, stack.field_77994_a);
            int amountPerStack = (toMove + currentAmount) / slots.size();
            int extra = (toMove + currentAmount) % slots.size();
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                ItemStack craftStack = this.CRAFT_MATRIX.func_70301_a(slot);
                if (extra > 0) {
                    craftStack.field_77994_a = amountPerStack + 1;
                    --extra;
                    continue;
                }
                craftStack.field_77994_a = amountPerStack;
            }
            stack.field_77994_a -= toMove;
            if (stack.field_77994_a == 0) {
                return null;
            }
        } else {
            for (int i = 0; i < this.CRAFT_MATRIX.func_70302_i_(); ++i) {
                int toMove;
                ItemStack craftStack = this.CRAFT_MATRIX.func_70301_a(i);
                if (!ItemStackHelper.areItemStacksEqual(stack, craftStack) || (toMove = Math.min(this.maxCraftStack - craftStack.field_77994_a, stack.field_77994_a)) < 0) continue;
                stack.field_77994_a -= toMove;
                if (stack.field_77994_a != 0) continue;
                return null;
            }
        }
        return stack;
    }

    @Override
    public void onUpdate(IItemRelocator relocator, int side) {
        super.onUpdate(relocator, side);
        if (relocator.getTileEntity().func_145831_w().field_72995_K) {
            return;
        }
        if (this.canCraft()) {
            ++this.craftTick;
            if (this.craftTick > Settings.CRAFTING_MODULE_TICKS_BETWEEN_CRAFTING) {
                this.craftTick = 0;
                this.craft(relocator, side);
            }
        } else {
            this.craftTick = 0;
            ++this.normalTick;
            if (this.normalTick > Settings.RELOCATOR_MIN_TICKS_BETWEEN_EXTRACTION && this.outputStack != null) {
                if (this.CRAFT_RESULT.func_70301_a(0) == null || !this.CRAFT_RESULT.func_70301_a(0).func_77969_a(this.outputStack)) {
                    IOHelper.spawnItemInWorld(relocator.getTileEntity().func_145831_w(), this.outputStack, relocator.getTileEntity().field_145851_c, relocator.getTileEntity().field_145848_d, relocator.getTileEntity().field_145849_e);
                    this.outputStack = null;
                } else {
                    this.outputStack(relocator, side);
                }
            }
        }
    }

    public void craft(IItemRelocator relocator, int side) {
        for (int slot = 0; slot < this.CRAFT_MATRIX.func_70302_i_(); ++slot) {
            ItemStack stack = this.CRAFT_MATRIX.func_70301_a(slot);
            if (stack == null) continue;
            --stack.field_77994_a;
        }
        this.outputStack = this.CRAFT_RESULT.func_70301_a(0).func_77946_l();
        this.outputStack(relocator, side);
    }

    public boolean canCraft() {
        if (this.outputStack != null || this.CRAFT_RESULT.func_70301_a(0) == null) {
            return false;
        }
        for (int slot = 0; slot < this.CRAFT_MATRIX.func_70302_i_(); ++slot) {
            ItemStack stack = this.CRAFT_MATRIX.func_70301_a(slot);
            if (stack == null || stack.field_77994_a >= 1) continue;
            return false;
        }
        return true;
    }

    public void outputStack(IItemRelocator relocator, int side) {
        if (this.input) {
            this.outputStack = relocator.insert(this.outputStack, side, false);
        } else {
            IItemRelocator relocator1 = relocator.getConnectedRelocators()[side];
            if (relocator1 != null) {
                IRelocatorModule module = relocator1.getRelocatorModule(ForgeDirection.OPPOSITES[side]);
                this.outputStack = module != null && module.isItemDestination() ? module.receiveItemStack(relocator1, ForgeDirection.OPPOSITES[side], this.outputStack, true, false) : relocator1.insert(this.outputStack, ForgeDirection.OPPOSITES[side], false);
            } else {
                TileEntity tile = relocator.getConnectedInventories()[side];
                if (tile != null) {
                    this.outputStack = IOHelper.insert(tile, this.outputStack, ForgeDirection.getOrientation((int)side).getOpposite(), false);
                }
            }
        }
    }

    public int getMaxCraftStack() {
        return this.maxCraftStack;
    }

    public void setMaxCraftStack(int maxCraftStack) {
        this.maxCraftStack = maxCraftStack;
    }

    @Override
    public List<ItemStack> getDrops(IItemRelocator relocator, int side) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Item)ModItems.relocatorModule, 1, 12));
        return list;
    }

    @Override
    public boolean onActivated(IItemRelocator relocator, EntityPlayer player, int side, ItemStack stack) {
        APIUtils.openRelocatorModuleGUI(relocator, player, side);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGUI(IItemRelocator relocator, int side, EntityPlayer player) {
        return new GuiModuleCrafting(player, this);
    }

    @Override
    public Container getContainer(IItemRelocator relocator, int side, EntityPlayer player) {
        return new ContainerModuleCrafting(player, this);
    }

    @Override
    public String getDisplayName() {
        return StatCollector.func_74838_a((String)"item.relocatorModule12.name");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IItemRelocator relocator, int side) {
        return icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        icon = register.func_94245_a(Resources.MOD_ID + ":" + "relocatorModuleCrafting");
    }

    @Override
    public void readFromNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        super.readFromNBT(relocator, side, compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.CRAFT_MATRIX.func_70302_i_()) continue;
            this.CRAFT_MATRIX.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
        this.outputStack = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("outputStack"));
        this.input = compound.func_74767_n("input");
        this.maxCraftStack = compound.func_74762_e("maxCraftStack");
    }

    @Override
    public void writeToNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        super.writeToNBT(relocator, side, compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.CRAFT_MATRIX.func_70302_i_(); ++i) {
            if (this.CRAFT_MATRIX.func_70301_a(i) == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.CRAFT_MATRIX.func_70301_a(i).func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.outputStack != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            this.outputStack.func_77955_b(nbttagcompound1);
            compound.func_74782_a("outputStack", (NBTBase)nbttagcompound1);
        }
        compound.func_74757_a("input", this.input);
        compound.func_74768_a("maxCraftStack", this.maxCraftStack);
    }

    private class LocalInventoryCrafting
    extends InventoryCrafting {
        public LocalInventoryCrafting() {
            super(new Container(){

                public boolean func_75145_c(EntityPlayer p_75145_1_) {
                    return false;
                }
            }, 3, 3);
        }

        public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
            super.func_70299_a(p_70299_1_, p_70299_2_);
            RelocatorModuleCrafting.this.CRAFT_RESULT.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)RelocatorModuleCrafting.this.CRAFT_MATRIX, null));
        }
    }
}

