/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.gui.GuiPowerLimiter;
import com.dynious.refinedrelocation.client.gui.widget.GuiTextInput;
import com.dynious.refinedrelocation.helper.EnergyType;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.network.NetworkHandler;
import com.dynious.refinedrelocation.network.packet.MessageSetMaxPower;
import com.dynious.refinedrelocation.tileentity.TilePowerLimiter;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;

public class GuiTextInputPowerLimiter
extends GuiTextInput {
    protected GuiPowerLimiter parent;
    private TilePowerLimiter tile;
    private double maxAcceptedEnergy;
    private EnergyType currentEnergyType;

    public GuiTextInputPowerLimiter(GuiPowerLimiter parent, int x, int y, int w, int h, TilePowerLimiter tile) {
        super(parent, x, y, w, h);
        this.tile = tile;
        this.parent = parent;
        this.update();
    }

    @Override
    protected void onTextChangedByUser(String newFilter) {
        if (this.tile == null) {
            return;
        }
        this.maxAcceptedEnergy = this.stringToMaxEnergy(newFilter);
        this.tile.setMaxAcceptedEnergy(this.maxAcceptedEnergy);
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageSetMaxPower(this.maxAcceptedEnergy));
    }

    @Override
    public void update() {
        if (this.tile != null) {
            if (this.currentEnergyType != this.parent.getCurrentEnergyType()) {
                this.currentEnergyType = this.parent.getCurrentEnergyType();
                this.maxAcceptedEnergy = -1.0;
            }
            if (this.tile.getMaxAcceptedEnergy() != this.maxAcceptedEnergy) {
                this.maxAcceptedEnergy = this.tile.getMaxAcceptedEnergy();
                this.setText(this.maxEnergyToString(this.tile.getMaxAcceptedEnergy()));
            }
        }
        super.update();
    }

    @Override
    public boolean keyTyped(char c, int i) {
        String lastText = this.textField.func_146179_b();
        if (Character.isDigit(c) || Character.getType(c) == 15 || Character.getType(c) == 24 && !StringUtils.contains((CharSequence)lastText, (int)24)) {
            this.textField.func_146201_a(c, i);
            if (!lastText.equals(this.textField.func_146179_b())) {
                this.onTextChangedByUser(this.textField.func_146179_b());
                return true;
            }
        }
        return false;
    }

    public String maxEnergyToString(double maxAcceptedEnergy) {
        if (this.parent.getCurrentEnergyType() == null) {
            return "--";
        }
        return Double.toString(this.parent.getCurrentEnergyType().fromInternal(maxAcceptedEnergy));
    }

    public double stringToMaxEnergy(String string) {
        double power;
        if (string.isEmpty() || this.parent.getCurrentEnergyType() == null) {
            return 0.0;
        }
        try {
            power = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            power = 0.0;
        }
        return this.parent.getCurrentEnergyType().convertToInternal(power);
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            list.add(StatCollector.func_74838_a((String)Strings.MAX_ENERGY));
        }
        return list;
    }
}

