/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiButtonToggle;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.network.NetworkHandler;
import com.dynious.refinedrelocation.network.packet.MessageRedstoneEnabled;
import com.dynious.refinedrelocation.tileentity.TileBlockExtender;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiRedstoneSignalStatus
extends GuiButtonToggle {
    protected static final int textureXBase = 128;
    protected TileBlockExtender tile;
    protected boolean lastEnabled = false;
    protected boolean lastPowered = true;
    protected String tooltipText;

    public GuiRedstoneSignalStatus(IGuiParent parent, int x, int y, TileBlockExtender tile) {
        super(parent, x, y, 16, 16, 128, 80, null, null);
        this.tile = tile;
        this.update();
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        List<String> tooltip = super.getTooltip(mouseX, mouseY);
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            String colorCode = "\u00a7";
            String grayColor = colorCode + "7";
            String redColor = colorCode + "4";
            tooltip.add(StatCollector.func_74838_a((String)Strings.REDSTONE_TRANSMISSION));
            if (this.tile.isRedstoneTransmissionEnabled()) {
                tooltip.add(grayColor + StatCollector.func_74838_a((String)Strings.ENABLED));
                if (this.tile.isRedstoneTransmissionActive()) {
                    tooltip.add(redColor + StatCollector.func_74838_a((String)Strings.ACTIVE));
                } else {
                    tooltip.add(redColor + StatCollector.func_74838_a((String)Strings.INACTIVE));
                }
            } else {
                tooltip.add(grayColor + StatCollector.func_74838_a((String)Strings.DISABLED));
            }
        }
        return tooltip;
    }

    @Override
    protected void onStateChangedByUser(boolean newState) {
        if (this.tile == null) {
            return;
        }
        this.tile.setRedstoneTransmissionEnabled(newState);
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageRedstoneEnabled(newState));
    }

    @Override
    public void update() {
        super.update();
        if (this.tile != null) {
            this.setState(this.tile.isRedstoneTransmissionEnabled());
            this.textureX = this.tile.isRedstoneTransmissionActive() ? 128 + this.w : 128;
        }
    }
}

