/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiCheckboxFilter;
import com.dynious.refinedrelocation.client.gui.widget.GuiWidgetBase;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiFilterList
extends GuiWidgetBase {
    public int numFiltersPerScreen;
    public int filterRowHeight = 10;
    public int rowSpacing = 1;
    public int scrollBarAreaWidth = 10;
    public int scrollBarWidth = 7;
    public int scrollBarScaledHeight;
    public int scrollBarYPos;
    public int scrollBarXPos;
    public int scrollBarColor = -5592406;
    public int mouseClickY = -1;
    public int indexWhenClicked;
    public int lastNumberOfMoves;
    protected IFilterTileGUI tile;
    protected int currentIndex = 0;
    protected GuiCheckboxFilter[] filters;

    public GuiFilterList(IGuiParent parent, int x, int y, int w, int h, IFilterTileGUI tile) {
        super(parent, x, y, w, h);
        this.tile = tile;
        this.numFiltersPerScreen = (int)Math.floor((h + 2 * this.rowSpacing) / (this.filterRowHeight + this.rowSpacing));
        this.filters = new GuiCheckboxFilter[this.numFiltersPerScreen];
        for (int i = 0; i < this.numFiltersPerScreen; ++i) {
            this.filters[i] = new GuiCheckboxFilter(this, x, y + i * (this.filterRowHeight + this.rowSpacing), w - this.scrollBarAreaWidth, this.filterRowHeight, i, tile);
        }
        this.recalculateScrollBar();
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int index) {
        this.currentIndex = index = Math.min(this.tile.getFilter().getSize() - this.numFiltersPerScreen, Math.max(0, index));
        for (int i = 0; i < this.numFiltersPerScreen; ++i) {
            this.filters[i].setIndex(i + this.currentIndex);
        }
        this.recalculateScrollBar();
    }

    public void recalculateScrollBar() {
        int scrollBarTotalHeight = this.h - 2;
        this.scrollBarScaledHeight = scrollBarTotalHeight * this.numFiltersPerScreen / this.tile.getFilter().getSize() + 1;
        this.scrollBarYPos = this.y + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentIndex / (this.tile.getFilter().getSize() - this.numFiltersPerScreen);
        this.scrollBarXPos = this.x + this.w - this.scrollBarAreaWidth / 2 + this.scrollBarWidth / 2 + 1;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.mouseClickY != -1 && (pixelsPerFilter = ((float)this.h - 2.0f - (float)this.scrollBarScaledHeight) / (float)(this.tile.getFilter().getSize() - this.numFiltersPerScreen)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentIndex(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiContainer.func_73734_a((int)(this.scrollBarXPos - this.scrollBarWidth), (int)this.scrollBarYPos, (int)this.scrollBarXPos, (int)(this.scrollBarYPos + this.scrollBarScaledHeight), (int)this.scrollBarColor);
        super.drawBackground(mouseX, mouseY);
    }

    @Override
    public void handleMouseInput() {
        super.handleMouseInput();
        int i = Mouse.getEventDWheel();
        if (i == 0) {
            return;
        }
        this.setCurrentIndex(i > 0 ? this.getCurrentIndex() - 1 : this.getCurrentIndex() + 1);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
        if (mouseX >= this.scrollBarXPos - this.scrollBarWidth && mouseX <= this.scrollBarXPos && mouseY >= this.scrollBarYPos && mouseY <= this.scrollBarYPos + this.scrollBarScaledHeight) {
            this.mouseClickY = mouseY;
            this.indexWhenClicked = this.getCurrentIndex();
        }
    }

    @Override
    public void mouseMovedOrUp(int mouseX, int mouseY, int type) {
        super.mouseMovedOrUp(mouseX, mouseY, type);
        if (type != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
    }
}

