/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiButton;
import com.dynious.refinedrelocation.grid.relocator.RelocatorModuleSneaky;
import com.dynious.refinedrelocation.helper.BlockHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.TileRelocator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiButtonSide
extends GuiButton {
    private RelocatorModuleSneaky module;

    public GuiButtonSide(IGuiParent parent, int x, int y, RelocatorModuleSneaky module) {
        super(parent, x, y, 34, 20, 120, 0, ForgeDirection.getOrientation((int)module.getOutputSide()).toString());
        this.module = module;
        this.setTooltipString(StatCollector.func_74838_a((String)Strings.SNEAKY));
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            if (type == 0) {
                this.onValueChangedByUser((this.module.getOutputSide() + 1) % ForgeDirection.VALID_DIRECTIONS.length);
            } else if (type == -1) {
                int i = this.module.getOutputSide() - 1;
                if (i < 0) {
                    i = ForgeDirection.VALID_DIRECTIONS.length - 1;
                }
                this.onValueChangedByUser(i);
            }
        }
    }

    protected void onValueChangedByUser(int side) {
        this.module.setOutputSide(side);
        this.getContainer().sendMessage(0, side);
    }

    @Override
    public void update() {
        if (this.module != null) {
            ForgeDirection outputDirection = ForgeDirection.getOrientation((int)this.module.getOutputSide());
            this.label.setText(outputDirection.toString());
            int[] blockInfo = this.getSneakySideBlockInfo();
            String blockName = BlockHelper.getBlockDisplayName((World)Minecraft.func_71410_x().field_71441_e, blockInfo[0], blockInfo[1], blockInfo[2], ForgeDirection.getOrientation((int)blockInfo[3]));
            this.setTooltipString(blockName + "\n" + StatCollector.func_74838_a((String)Strings.SNEAKY));
        }
        super.update();
    }

    private int[] getSneakySideBlockInfo() {
        TileRelocator relocator = this.module.getRelocator();
        ForgeDirection direction = this.module.getSide();
        ForgeDirection outputDirection = ForgeDirection.getOrientation((int)this.module.getOutputSide());
        return new int[]{relocator.field_145851_c + direction.offsetX + outputDirection.offsetX, relocator.field_145848_d + direction.offsetY + outputDirection.offsetY, relocator.field_145849_e + direction.offsetZ + outputDirection.offsetZ, direction.ordinal()};
    }
}

