/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiButtonCounter;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.network.NetworkHandler;
import com.dynious.refinedrelocation.network.packet.MessageMaxStackSize;
import com.dynious.refinedrelocation.tileentity.IAdvancedTile;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonMaxStackSize
extends GuiButtonCounter {
    protected IAdvancedTile tile;

    public GuiButtonMaxStackSize(IGuiParent parent, int x, int y, IAdvancedTile tile) {
        super(parent, x, y, 24, 20, 0, 0, 0, 64, 1, 16);
        this.tile = tile;
        this.update();
    }

    @Override
    protected void onValueChangedByUser(double newValue) {
        if (this.tile == null) {
            return;
        }
        this.tile.setMaxStackSize((byte)newValue);
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageMaxStackSize((byte)newValue));
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        List<String> subTooltip = super.getTooltip(mouseX, mouseY);
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(StatCollector.func_74838_a((String)Strings.MAX_STACK_SIZE));
            tooltip.addAll(subTooltip);
            return tooltip;
        }
        return subTooltip;
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.setValue(this.tile.getMaxStackSize());
        }
        super.update();
    }
}

