/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiButtonToggle;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.network.NetworkHandler;
import com.dynious.refinedrelocation.network.packet.MessageRestrictExtraction;
import com.dynious.refinedrelocation.tileentity.IAdvancedFilteredTile;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonFilterExtraction
extends GuiButtonToggle {
    protected IAdvancedFilteredTile tile;

    public GuiButtonFilterExtraction(IGuiParent parent, int x, int y, IAdvancedFilteredTile tile) {
        super(parent, x, y, 24, 20, 72, 0, null, null);
        this.tile = tile;
        this.update();
    }

    @Override
    protected void onStateChangedByUser(boolean newState) {
        if (this.tile == null) {
            return;
        }
        this.tile.setRestrictionExtraction(newState);
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageRestrictExtraction(newState));
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        List<String> tooltip = super.getTooltip(mouseX, mouseY);
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            tooltip.add(StatCollector.func_74838_a((String)(this.getState() ? Strings.FILTERED_EXTRACT : Strings.UNFILTERED_EXTRACT)));
        }
        return tooltip;
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.setState(this.tile.getRestrictExtraction());
        }
        super.update();
    }
}

