/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.block;

import com.dynious.refinedrelocation.RefinedRelocation;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.lib.Mods;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.tileentity.TileMESortingInterface;
import com.dynious.refinedrelocation.tileentity.TileSortingConnector;
import com.dynious.refinedrelocation.tileentity.TileSortingImporter;
import com.dynious.refinedrelocation.tileentity.TileSortingInterface;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSortingConnector
extends BlockContainer {
    private IIcon[] icons = new IIcon[4];
    private IIcon[] interfaceTextures = new IIcon[2];

    public BlockSortingConnector() {
        super(Material.field_151576_e);
        this.func_149663_c("sortingConnector");
        this.func_149711_c(3.0f);
        this.func_149647_a(RefinedRelocation.tabRefinedRelocation);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileSortingConnector();
            }
            case 1: {
                return new TileSortingInterface();
            }
            case 2: {
                return new TileSortingImporter();
            }
            case 3: {
                if (!Mods.IS_AE2_LOADED) break;
                return this.getNewTileMESortingInterface();
            }
        }
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public TileEntity getNewTileMESortingInterface() {
        return new TileMESortingInterface();
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSortingConnector) {
            return ((TileSortingConnector)tile).onActivated(player, par6);
        }
        return false;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int metadata = 0; metadata < (Mods.IS_AE2_LOADED ? 4 : 3); ++metadata) {
            par3List.add(new ItemStack(par1, 1, metadata));
        }
    }

    public void func_149749_a(World world, int par2, int par3, int par4, Block par5, int par6) {
        IOHelper.dropInventory(world, par2, par3, par4);
        super.func_149749_a(world, par2, par3, par4, par5, par6);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof TileSortingConnector) {
            TileSortingConnector tile = (TileSortingConnector)tileEntity;
            Block blockDisguisedAs = tile.getDisguise();
            int disguisedMeta = tile.blockDisguisedMetadata;
            if (blockDisguisedAs != null) {
                return blockDisguisedAs.func_149691_a(side, disguisedMeta);
            }
            if (tile instanceof TileSortingInterface) {
                TileSortingInterface sortingInterface = (TileSortingInterface)tile;
                if (sortingInterface.getConnectedSide().ordinal() == side) {
                    return this.interfaceTextures[0];
                }
                if (sortingInterface.isStuffed()) {
                    return this.interfaceTextures[1];
                }
            }
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileSortingConnector tile;
        Block blockDisguisedAs;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof TileSortingConnector && (blockDisguisedAs = (tile = (TileSortingConnector)tileEntity).getDisguise()) != null) {
            return blockDisguisedAs.func_149720_d(world, x, y, z);
        }
        return super.func_149720_d(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a(Resources.MOD_ID + ":" + "sortingConnector" + i);
        }
        this.interfaceTextures[0] = iconRegister.func_94245_a(Resources.MOD_ID + ":" + "sortingConnector" + 1 + "ConSide");
        this.interfaceTextures[1] = iconRegister.func_94245_a(Resources.MOD_ID + ":" + "sortingConnector" + 1 + "Stuffed");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metaData) {
        if (metaData >= 0 && metaData < this.icons.length) {
            return this.icons[metaData];
        }
        return null;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileSortingInterface) {
            return ((TileSortingInterface)tile).rotateBlock();
        }
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_147438_o(x, y, z)) != null && tile instanceof TileMESortingInterface && entity instanceof EntityPlayer) {
            ((TileMESortingInterface)tile).setOwner((EntityPlayer)entity);
        }
    }
}

