/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.InventoryStorageItem;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemDrill
extends ItemUpgradeableTool
implements IFluidContainerItem {
    public static Material[] validMaterials = new Material[]{Material.field_151574_g, Material.field_151571_B, Material.field_151592_s, Material.field_151588_w, Material.field_151573_f, Material.field_151598_x, Material.field_76233_E, Material.field_151576_e};
    public static HashMap<String, Integer> animationTimer = new HashMap();

    public ItemDrill() {
        super("drill", 1, IUpgrade.UpgradeType.DRILL, "diesel");
    }

    @Override
    public int getInternalSlots(ItemStack stack) {
        return 4;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, InventoryStorageItem invItem) {
        return new Slot[]{new IESlot.DrillHead(container, invItem, 0, 98, 22), new IESlot.Upgrades(container, invItem, 1, 78, 42, IUpgrade.UpgradeType.DRILL, stack, true), new IESlot.Upgrades(container, invItem, 2, 98, 52, IUpgrade.UpgradeType.DRILL, stack, true), new IESlot.Upgrades(container, invItem, 3, 118, 42, IUpgrade.UpgradeType.DRILL, stack, true)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void recalculateUpgrades(ItemStack stack) {
        super.recalculateUpgrades(stack);
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.amount > this.getCapacity(stack)) {
            fs.amount = this.getCapacity(stack);
            ItemNBTHelper.setFluidStack(stack, "fuel", fs);
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null) {
            list.add(StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.flavour.drill.fuel") + " " + fs.amount + "/" + this.getCapacity(stack) + "mB");
        } else {
            list.add(StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.flavour.drill.empty"));
        }
        if (this.getHead(stack) == null) {
            list.add(StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.flavour.drill.noHead"));
        } else {
            int maxDmg = this.getMaxHeadDamage(stack);
            int dmg = maxDmg - this.getHeadDamage(stack);
            float quote = (float)dmg / (float)maxDmg;
            String status = "" + ((double)quote < 0.1 ? EnumChatFormatting.RED : ((double)quote < 0.3 ? EnumChatFormatting.GOLD : ((double)quote < 0.6 ? EnumChatFormatting.YELLOW : EnumChatFormatting.GREEN)));
            list.add(StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.flavour.drill.headDamage") + " " + status + dmg + "/" + maxDmg);
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (this.canDrillBeUsed(stack, entityLiving)) {
            if (!animationTimer.containsKey(entityLiving.func_70005_c_())) {
                animationTimer.put(entityLiving.func_70005_c_(), 40);
            } else if (animationTimer.get(entityLiving.func_70005_c_()) < 20) {
                animationTimer.put(entityLiving.func_70005_c_(), 20);
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getHeadDamage(stack) / (double)this.getMaxHeadDamage(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getHeadDamage(stack) > 0;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.bow;
    }

    public ItemStack getHead(ItemStack drill) {
        ItemStack head = this.getContainedItems(drill)[0];
        return head != null && head.func_77973_b() instanceof IDrillHead ? head : null;
    }

    public void setHead(ItemStack drill, ItemStack head) {
        ItemStack[] inv = this.getContainedItems(drill);
        inv[0] = head;
        this.setContainedItems(drill, inv);
    }

    public boolean canDrillBeUsed(ItemStack drill, EntityLivingBase player) {
        if (drill.func_77960_j() == 0 && player.func_70055_a(Material.field_151586_h) && !this.getUpgrades(drill).func_74767_n("waterproof")) {
            return false;
        }
        return drill.func_77960_j() != 0 || this.getFluid(drill) != null;
    }

    public int getMaxHeadDamage(ItemStack stack) {
        ItemStack head = this.getHead(stack);
        return head != null ? ((IDrillHead)head.func_77973_b()).getMaximumHeadDamage(head) : 0;
    }

    public int getHeadDamage(ItemStack stack) {
        ItemStack head = this.getHead(stack);
        return head != null ? ((IDrillHead)head.func_77973_b()).getHeadDamage(head) : 0;
    }

    public boolean isDrillBroken(ItemStack stack) {
        return this.getHeadDamage(stack) >= this.getMaxHeadDamage(stack) || this.getFluid(stack) == null || this.getFluid((ItemStack)stack).amount < 1;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            player.openGui((Object)ImmersiveEngineering.instance, 9, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return stack;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase player) {
        return true;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase living) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0) {
            int dmg = ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)world.func_72805_g(x, y, z)) ? 1 : 3;
            ItemStack head = this.getHead(stack);
            if (head != null) {
                if (living instanceof EntityPlayer) {
                    if (((EntityPlayer)living).field_71075_bZ.field_75098_d) {
                        return true;
                    }
                    ((IDrillHead)head.func_77973_b()).afterBlockbreak(stack, head, (EntityPlayer)living);
                }
                ((IDrillHead)head.func_77973_b()).damageHead(head, dmg);
                this.setHead(stack, head);
                this.drain(stack, 1, true);
            }
        }
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        ItemStack head = this.getHead(stack);
        Multimap multimap = super.getAttributeModifiers(stack);
        if (head != null) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)(((IDrillHead)head.func_77973_b()).getAttackDamage(head) + (float)this.getUpgrades(stack).func_74762_e("damage")), 0));
        }
        return multimap;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        ItemStack head = this.getHead(stack);
        if (head != null) {
            return ((IDrillHead)head.func_77973_b()).getMiningLevel(head) + ItemNBTHelper.getInt(stack, "harvestLevel");
        }
        return 0;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        if (this.getHead(stack) != null && !this.isDrillBroken(stack)) {
            return ImmutableSet.of((Object)"pickaxe");
        }
        return super.getToolClasses(stack);
    }

    public boolean isEffective(Material mat) {
        for (Material m : validMaterials) {
            if (m != mat) continue;
            return true;
        }
        return false;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.isEffective(block.func_149688_o()) && !this.isDrillBroken(stack);
    }

    public float func_150893_a(ItemStack stack, Block block) {
        ItemStack head = this.getHead(stack);
        return this.isEffective(block.func_149688_o()) && head != null && !this.isDrillBroken(stack) ? ((IDrillHead)head.func_77973_b()).getMiningSpeed(head) + (float)ItemNBTHelper.getInt(stack, "speed") : 1.0f;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        ItemStack head = this.getHead(stack);
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta) && head != null && !this.isDrillBroken(stack)) {
            return ((IDrillHead)head.func_77973_b()).getMiningSpeed(head) + (float)ItemNBTHelper.getInt(stack, "speed");
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public boolean canBreakExtraBlock(World world, Block block, int x, int y, int z, int meta, EntityPlayer player, ItemStack drill, ItemStack head, boolean inWorld) {
        if (block.canHarvestBlock(player, meta) && this.isEffective(block.func_149688_o()) && !this.isDrillBroken(drill)) {
            if (inWorld) {
                return !((IDrillHead)head.func_77973_b()).beforeBlockbreak(drill, head, player);
            }
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, int ix, int iy, int iz, EntityPlayer player) {
        World world = player.field_70170_p;
        if (player.func_70093_af() || world.field_72995_K || !(player instanceof EntityPlayerMP)) {
            return false;
        }
        MovingObjectPosition mop = this.func_77621_a(world, player, true);
        ItemStack head = this.getHead(stack);
        if (mop == null || head == null) {
            return false;
        }
        int side = mop.field_72310_e;
        int diameter = ((IDrillHead)head.func_77973_b()).getMiningSize(head) + this.getUpgrades(stack).func_74762_e("size");
        int depth = ((IDrillHead)head.func_77973_b()).getMiningDepth(head) + this.getUpgrades(stack).func_74762_e("depth");
        int startX = ix;
        int startY = iy;
        int startZ = iz;
        if (diameter % 2 == 0) {
            float hx = (float)mop.field_72307_f.field_72450_a - (float)ix;
            float hy = (float)mop.field_72307_f.field_72448_b - (float)iy;
            float hz = (float)mop.field_72307_f.field_72449_c - (float)iz;
            if (side < 2 && (double)hx < 0.5 || side < 4 && (double)hx < 0.5) {
                startX -= diameter / 2;
            }
            if (side > 1 && (double)hy < 0.5) {
                startY -= diameter / 2;
            }
            if (side < 2 && (double)hz < 0.5 || side > 3 && (double)hz < 0.5) {
                startZ -= diameter / 2;
            }
        } else {
            startX -= side == 4 || side == 5 ? 0 : diameter / 2;
            startY -= side == 0 || side == 1 ? 0 : diameter / 2;
            startZ -= side == 2 || side == 3 ? 0 : diameter / 2;
        }
        for (int dd = 0; dd < depth; ++dd) {
            for (int dw = 0; dw < diameter; ++dw) {
                for (int dh = 0; dh < diameter; ++dh) {
                    BlockEvent.BreakEvent event;
                    int x = startX + (side == 4 || side == 5 ? dd : dw);
                    int y = startY + (side == 0 || side == 1 ? dd : dh);
                    int z = startZ + (side == 0 || side == 1 ? dh : (side == 4 || side == 5 ? dw : dd));
                    if (x == ix && y == iy && z == iz || !world.func_72899_e(x, y, z)) continue;
                    Block block = world.func_147439_a(x, y, z);
                    int meta = world.func_72805_g(x, y, z);
                    if (block == null || block.isAir((IBlockAccess)world, x, y, z) || block.func_149737_a(player, world, x, y, z) == 0.0f || !this.canBreakExtraBlock(world, block, x, y, z, meta, player, stack, head, true) || (event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (int)x, (int)y, (int)z)).isCanceled()) continue;
                    if (player.field_71075_bZ.field_75098_d) {
                        block.func_149681_a(world, x, y, z, meta, player);
                        if (block.removedByPlayer(world, player, x, y, z, false)) {
                            block.func_149664_b(world, x, y, z, meta);
                        }
                    } else {
                        block.func_149681_a(world, x, y, z, meta, player);
                        if (block.removedByPlayer(world, player, x, y, z, true)) {
                            block.func_149664_b(world, x, y, z, meta);
                            block.func_149636_a(world, player, x, y, z, meta);
                            block.func_149657_c(world, x, y, z, event.getExpToDrop());
                        }
                        player.func_71045_bC().func_150999_a(world, block, x, y, z, player);
                    }
                    world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
                }
            }
        }
        return false;
    }

    public FluidStack getFluid(ItemStack container) {
        return ItemNBTHelper.getFluidStack(container, "fuel");
    }

    public int getCapacity(ItemStack container) {
        return 2000 + this.getUpgrades(container).func_74762_e("capacity");
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource != null && IEContent.fluidBiodiesel.equals(resource.getFluid())) {
            FluidStack fs = this.getFluid(container);
            int space = fs == null ? this.getCapacity(container) : this.getCapacity(container) - fs.amount;
            int accepted = Math.min(space, resource.amount);
            if (fs == null) {
                fs = new FluidStack(IEContent.fluidBiodiesel, accepted);
            } else {
                fs.amount += accepted;
            }
            if (doFill) {
                ItemNBTHelper.setFluidStack(container, "fuel", fs);
            }
            return accepted;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        FluidStack fs = this.getFluid(container);
        if (fs == null) {
            return null;
        }
        int drained = Math.min(maxDrain, fs.amount);
        FluidStack stack = new FluidStack(fs, drained);
        if (doDrain) {
            fs.amount -= drained;
            if (fs.amount <= 0) {
                ItemNBTHelper.remove(container, "fuel");
            } else {
                ItemNBTHelper.setFluidStack(container, "fuel", fs);
            }
        }
        return stack;
    }
}

