/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockMetalMultiblocks;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockFermenter;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityFermenter
extends TileEntityMultiblockPart
implements IFluidHandler,
ISidedInventory,
IEnergyReceiver {
    public int facing = 2;
    public FluidTank tank = new FluidTank(12000);
    public EnergyStorage energyStorage = new EnergyStorage(32000, 256, 32000);
    ItemStack[] inventory = new ItemStack[12];
    public int tick = 0;
    int processMaxTime = 0;

    public TileEntityFermenter master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - this.offset[0], this.field_145848_d - this.offset[1], this.field_145849_e - this.offset[2]);
        return te instanceof TileEntityFermenter ? (TileEntityFermenter)te : null;
    }

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (!this.formed) {
            return new ItemStack((Block)IEContent.blockMetalMultiblocks, 1, BlockMetalMultiblocks.META_fermenter);
        }
        return MultiblockFermenter.instance.getStructureManual()[this.pos % 9 / 3][this.pos / 9][this.pos % 3].func_77946_l();
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public void func_145845_h() {
        if (!this.formed || this.pos != 13) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean update = false;
            int[] valid = this.getValidInputs();
            int inputs = Math.min(9, valid[0]);
            this.processMaxTime = valid[1];
            if (inputs > 0) {
                int consumed = Config.getInt("fermenter_consumption");
                if (this.energyStorage.extractEnergy(consumed, true) == consumed) {
                    this.energyStorage.extractEnergy(consumed, false);
                    ++this.tick;
                }
                if (this.tick >= valid[1]) {
                    DieselHandler.FermenterRecipe recipe = null;
                    for (int i = 0; i < 9; ++i) {
                        DieselHandler.FermenterRecipe rr;
                        ItemStack stack = this.func_70301_a(i);
                        if (stack == null || (rr = this.getRecipe(stack)) == null || recipe != null && rr != recipe && !(rr.fluid != null ? rr.fluid.isFluidEqual(recipe.fluid) : recipe.fluid != null && recipe.fluid.isFluidEqual(rr.fluid))) continue;
                        recipe = rr;
                        if (recipe != null) {
                            int recipeInputSize;
                            int n = recipeInputSize = recipe.input instanceof ItemStack ? ((ItemStack)recipe.input).field_77994_a : 1;
                            int outLimit = recipe.output == null ? 9 : (64 - (this.inventory[11] != null ? this.inventory[11].field_77994_a : 0)) / recipe.output.field_77994_a;
                            int fluidLimit = recipe.fluid == null ? 9 : (this.tank.getCapacity() - this.tank.getFluidAmount()) / recipe.fluid.amount;
                            int taken = Math.min(Math.min(inputs, stack.field_77994_a / recipeInputSize), Math.min(outLimit, fluidLimit));
                            if (taken > 0) {
                                this.func_70298_a(i, taken * recipeInputSize);
                                if (recipe.output != null) {
                                    if (this.inventory[11] != null) {
                                        this.inventory[11].field_77994_a += taken * recipe.output.func_77946_l().field_77994_a;
                                    } else if (this.inventory[11] == null) {
                                        this.inventory[11] = Utils.copyStackWithAmount(recipe.output, taken * recipe.output.field_77994_a);
                                    }
                                }
                                if (recipe.fluid != null) {
                                    this.tank.fill(new FluidStack(recipe.fluid, taken * recipe.fluid.amount), true);
                                }
                                inputs -= taken;
                                update = true;
                            }
                        }
                        if (inputs <= 0 || this.tank.getFluidAmount() >= this.tank.getCapacity()) break;
                    }
                    this.tick = 0;
                }
            } else if (this.tick > 0) {
                this.tick = 0;
            }
            if (this.tank.getFluidAmount() > 0 && this.tank.getFluid() != null && (this.inventory[10] == null || this.inventory[10].field_77994_a + 1 < this.inventory[10].func_77976_d())) {
                ItemStack filledContainer = Utils.fillFluidContainer(this.tank, this.inventory[9], this.inventory[10]);
                if (filledContainer != null) {
                    if (this.inventory[10] != null && OreDictionary.itemMatches((ItemStack)this.inventory[10], (ItemStack)filledContainer, (boolean)true)) {
                        this.inventory[10].field_77994_a += filledContainer.field_77994_a;
                    } else if (this.inventory[10] == null) {
                        this.inventory[10] = filledContainer.func_77946_l();
                    }
                    this.func_70298_a(9, filledContainer.field_77994_a);
                    update = true;
                }
                if (this.tank.getFluidAmount() > 0 && this.tank.getFluid() != null) {
                    int connected = 0;
                    for (int f = 2; f < 6; ++f) {
                        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + (f == 4 ? -2 : (f == 5 ? 2 : 0)), this.field_145848_d - 1, this.field_145849_e + (f == 2 ? -2 : (f == 3 ? 2 : 0)));
                        if (te == null || !(te instanceof IFluidHandler) || !((IFluidHandler)te).canFill(ForgeDirection.getOrientation((int)f).getOpposite(), this.tank.getFluid().getFluid())) continue;
                        ++connected;
                    }
                    if (connected != 0) {
                        int out = Math.min(144, this.tank.getFluidAmount()) / connected;
                        for (int f = 2; f < 6; ++f) {
                            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + (f == 4 ? -2 : (f == 5 ? 2 : 0)), this.field_145848_d - 1, this.field_145849_e + (f == 2 ? -2 : (f == 3 ? 2 : 0)));
                            if (te == null || !(te instanceof IFluidHandler) || this.tank.getFluid() == null || !((IFluidHandler)te).canFill(ForgeDirection.getOrientation((int)f).getOpposite(), this.tank.getFluid().getFluid())) continue;
                            int accepted = ((IFluidHandler)te).fill(ForgeDirection.getOrientation((int)f).getOpposite(), new FluidStack(this.tank.getFluid().getFluid(), out), false);
                            FluidStack drained = this.tank.drain(accepted, true);
                            ((IFluidHandler)te).fill(ForgeDirection.getOrientation((int)f).getOpposite(), drained, true);
                            update = true;
                        }
                    }
                }
            }
            if (update) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public DieselHandler.FermenterRecipe getRecipe(ItemStack input) {
        DieselHandler.FermenterRecipe recipe = DieselHandler.findFermenterRecipe(input);
        if (recipe == null) {
            return null;
        }
        if ((this.inventory[11] == null || recipe.output == null || OreDictionary.itemMatches((ItemStack)this.inventory[11], (ItemStack)recipe.output, (boolean)false) && this.inventory[11].field_77994_a + recipe.output.field_77994_a <= recipe.output.func_77976_d()) && (this.tank.getFluid() == null || recipe.fluid == null || this.tank.getFluid().isFluidEqual(recipe.fluid) && this.tank.getFluidAmount() + recipe.fluid.amount <= this.tank.getCapacity())) {
            return recipe;
        }
        return null;
    }

    int[] getValidInputs() {
        int in = 0;
        int time = 0;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.func_70301_a(i);
            DieselHandler.FermenterRecipe r = this.getRecipe(stack);
            if (r == null) continue;
            in += stack.field_77994_a;
            if (r.time <= time) continue;
            time = r.time;
        }
        return new int[]{in, time};
    }

    public int getScaledProgress(int scale) {
        if (this.processMaxTime <= 0) {
            return 0;
        }
        return (int)((float)scale * ((float)this.tick / (float)this.processMaxTime));
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.func_74762_e("facing");
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.energyStorage.readFromNBT(nbt);
        this.tick = nbt.func_74762_e("tick");
        this.processMaxTime = nbt.func_74762_e("processMaxTime");
        if (!descPacket) {
            NBTTagList invList = nbt.func_150295_c("inventory", 10);
            for (int i = 0; i < invList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = invList.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank", (NBTBase)tankTag);
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74768_a("tick", this.tick);
        nbt.func_74768_a("processMaxTime", this.processMaxTime);
        if (!descPacket) {
            NBTTagList invList = new NBTTagList();
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(itemTag);
                invList.func_74742_a((NBTBase)itemTag);
            }
            nbt.func_74782_a("inventory", (NBTBase)invList);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            if (this.pos != 1 && this.pos != 9 && this.pos != 11 && this.pos != 19) {
                return null;
            }
            return this.master().drain(from, resource, doDrain);
        }
        if (resource != null) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            if (this.pos != 1 && this.pos != 9 && this.pos != 11 && this.pos != 19) {
                return null;
            }
            return this.master().drain(from, maxDrain, doDrain);
        }
        FluidStack fs = this.tank.drain(maxDrain, doDrain);
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return fs;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.formed;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.formed) {
            return new FluidTankInfo[0];
        }
        if (this.master() != null) {
            return this.master().getTankInfo(from);
        }
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.formed && !this.field_145850_b.field_72995_K) {
            int f = this.facing;
            int il = this.pos / 9;
            int ih = this.pos % 9 / 3 - 1;
            int iw = this.pos % 3 - 1;
            int startX = this.field_145851_c - (f == 4 ? il : (f == 5 ? -il : (f == 2 ? -iw : iw)));
            int startY = this.field_145848_d - ih;
            int startZ = this.field_145849_e - (f == 2 ? il : (f == 3 ? -il : (f == 5 ? -iw : iw)));
            for (int l = 0; l < 3; ++l) {
                for (int w = -1; w <= 1; ++w) {
                    for (int h = -1; h <= 1; ++h) {
                        int xx = f == 4 ? l : (f == 5 ? -l : (f == 2 ? -w : w));
                        int yy = h;
                        int zz = f == 2 ? l : (f == 3 ? -l : (f == 5 ? -w : w));
                        ItemStack s = null;
                        if (this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz) instanceof TileEntityFermenter) {
                            s = ((TileEntityFermenter)this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz)).getOriginalBlock();
                            ((TileEntityFermenter)this.field_145850_b.func_147438_o((int)(startX + xx), (int)(startY + yy), (int)(startZ + zz))).formed = false;
                        }
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, s));
                            continue;
                        }
                        if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblocks) {
                            this.field_145850_b.func_147468_f(startX + xx, startY + yy, startZ + zz);
                        }
                        this.field_145850_b.func_147465_d(startX + xx, startY + yy, startZ + zz, Block.func_149634_a((Item)s.func_77973_b()), s.func_77960_j(), 3);
                    }
                }
            }
        }
    }

    public int func_70302_i_() {
        if (!this.formed) {
            return 0;
        }
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70301_a(slot);
        }
        if (slot < this.inventory.length) {
            return this.inventory[slot];
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70298_a(slot, amount);
        }
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70304_b(slot);
        }
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (!this.formed) {
            return;
        }
        if (this.master() != null) {
            this.master().func_70299_a(slot, stack);
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "IEFermenter";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!this.formed) {
            return false;
        }
        if (this.master() != null) {
            return this.master().func_94041_b(slot, stack);
        }
        return slot < 9 ? DieselHandler.findFermenterRecipe(stack) != null : slot == 9 && FluidContainerRegistry.isEmptyContainer((ItemStack)stack);
    }

    public int[] func_94128_d(int side) {
        if (!this.formed) {
            return new int[0];
        }
        if (this.master() != null) {
            return this.master().func_94128_d(side);
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        if (this.master() != null) {
            return this.master().func_102007_a(slot, stack, side);
        }
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        if (this.master() != null) {
            return this.master().func_102008_b(slot, stack, side);
        }
        return slot == 10 && slot == 11;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.formed && (this.pos == 10 && from == ForgeDirection.DOWN || this.pos == 16 && from == ForgeDirection.UP);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.formed && this.master() != null && (this.pos == 10 && from == ForgeDirection.DOWN || this.pos == 16 && from == ForgeDirection.UP)) {
            TileEntityFermenter master = this.master();
            int rec = master.energyStorage.receiveEnergy(maxReceive, simulate);
            master.func_70296_d();
            return rec;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            this.master().energyStorage.getEnergyStored();
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            this.master().energyStorage.getMaxEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }
}

