/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import WayofTime.alchemicalWizardry.api.event.TeleposeEvent;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.items.ItemDrill;
import blusunrize.immersiveengineering.common.util.Lib;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.oredict.OreDictionary;

public class EventHandler {
    public static HashMap<UUID, TileEntityCrusher> crusherMap = new HashMap();

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        if (ImmersiveNetHandler.INSTANCE == null) {
            ImmersiveNetHandler.INSTANCE = new ImmersiveNetHandler();
        }
    }

    @SubscribeEvent
    public void onSave(WorldEvent.Save event) {
        IESaveData.setDirty(0);
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        IESaveData.setDirty(0);
    }

    @SubscribeEvent
    public void harvestCheck(PlayerEvent.HarvestCheck event) {
        MovingObjectPosition mop;
        if (event.block instanceof BlockIEBase && event.entityPlayer.func_71045_bC() != null && event.entityPlayer.func_71045_bC().func_77973_b().getToolClasses(event.entityPlayer.func_71045_bC()).contains("IE_HAMMER") && (mop = Utils.getMovingObjectPositionFromPlayer(event.entityPlayer.field_70170_p, (EntityLivingBase)event.entityPlayer, true)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && ((BlockIEBase)event.block).allowHammerHarvest(event.entityPlayer.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d))) {
            event.success = true;
        }
    }

    @SubscribeEvent
    public void bloodMagicTeleposer(TeleposeEvent event) {
        TileEntity tI = event.initialWorld.func_147438_o(event.initialX, event.initialY, event.initialZ);
        TileEntity tF = event.finalWorld.func_147438_o(event.finalX, event.finalY, event.finalZ);
        if (tI instanceof TileEntityImmersiveConnectable || tF instanceof TileEntityImmersiveConnectable) {
            event.setCanceled(true);
        }
        if (tI instanceof TileEntityMultiblockPart || tF instanceof TileEntityMultiblockPart) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDrops(LivingDropsEvent event) {
        TileEntityCrusher crusher;
        if (!event.isCanceled() && Lib.DMG_Crusher.equals(event.source.func_76355_l()) && (crusher = crusherMap.get(event.entityLiving.func_110124_au())) != null) {
            for (EntityItem item : event.drops) {
                if (item == null || item.func_92059_d() == null) continue;
                crusher.outputItem(item.func_92059_d());
            }
            crusherMap.remove(event.entityLiving.func_110124_au());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.target instanceof EntityLivingBase && OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemRevolver, 1, Short.MAX_VALUE), (ItemStack)event.entityPlayer.func_71045_bC(), (boolean)false)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
    }

    @SubscribeEvent
    public void digSpeedEvent(PlayerEvent.BreakSpeed event) {
        ItemStack current = event.entityPlayer.func_71045_bC();
        if (current != null && current.func_77973_b().equals((Object)IEContent.itemDrill) && current.func_77960_j() == 0 && event.entityPlayer.func_70055_a(Material.field_151586_h)) {
            if (((ItemDrill)IEContent.itemDrill).getUpgrades(current).func_74767_n("waterproof")) {
                event.newSpeed *= 5.0f;
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onAnvilChange(AnvilUpdateEvent event) {
        if (event.left != null && event.left.func_77973_b() instanceof IDrillHead && ((IDrillHead)event.left.func_77973_b()).getHeadDamage(event.left) > 0 && event.right != null && event.left.func_77973_b().func_82789_a(event.left, event.right)) {
            int cost;
            event.output = event.left.func_77946_l();
            int repair = Math.min(((IDrillHead)event.output.func_77973_b()).getHeadDamage(event.output), ((IDrillHead)event.output.func_77973_b()).getMaximumHeadDamage(event.output) / 4);
            for (cost = 0; repair > 0 && cost < event.right.field_77994_a; ++cost) {
                ((IDrillHead)event.output.func_77973_b()).damageHead(event.output, -repair);
                event.cost += Math.max(1, repair / 100);
                repair = Math.min(((IDrillHead)event.output.func_77973_b()).getHeadDamage(event.output), ((IDrillHead)event.output.func_77973_b()).getMaximumHeadDamage(event.output) / 4);
            }
            event.materialCost = cost;
            if (event.name == null || event.name.isEmpty()) {
                if (event.left.func_82837_s()) {
                    event.cost += 5;
                    event.output.func_135074_t();
                }
            } else if (!event.name.equals(event.left.func_82833_r())) {
                event.cost += 5;
                if (event.left.func_82837_s()) {
                    event.cost += 2;
                }
                event.output.func_151001_c(event.name);
            }
        }
    }
}

