/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.nei;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class NEIArcFurnaceHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(71, 16, 25, 15), "ieArcFurnace", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId == this.getOverlayIdentifier()) {
            for (ArcFurnaceRecipe r : ArcFurnaceRecipe.recipeList) {
                if (r == null) continue;
                this.arecipes.add(new CachedArcFurnaceRecipe(r));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"tile.ImmersiveEngineering.metalMultiblock.arcFurnace.name");
    }

    public String getGuiTexture() {
        return "immersiveengineering:textures/gui/arcFurnace.png";
    }

    public String getOverlayIdentifier() {
        return "ieArcFurnace";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result != null) {
            for (ArcFurnaceRecipe r : ArcFurnaceRecipe.recipeList) {
                if (r == null || !Utils.stackMatchesObject(result, r.output) && (r.slag == null || !Utils.stackMatchesObject(result, r.slag))) continue;
                this.arecipes.add(new CachedArcFurnaceRecipe(r));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient != null) {
            for (ArcFurnaceRecipe r : ArcFurnaceRecipe.recipeList) {
                if (r == null) continue;
                if (Utils.stackMatchesObject(ingredient, r.input)) {
                    this.arecipes.add(new CachedArcFurnaceRecipe(r));
                    continue;
                }
                for (Object o : r.additives) {
                    if (!Utils.stackMatchesObject(ingredient, o)) continue;
                    this.arecipes.add(new CachedArcFurnaceRecipe(r));
                }
            }
        }
    }

    public void drawBackground(int recipe) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CachedArcFurnaceRecipe r = (CachedArcFurnaceRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            ClientUtils.drawSlot(28, 0, 16, 16);
            for (int i = 0; i < 4; ++i) {
                ClientUtils.drawSlot(20 + i % 2 * 18, 24 + i / 2 * 18, 16, 16);
            }
            ClientUtils.drawSlot(r.output.relx, r.output.rely, 16, 16);
            if (r.slag != null) {
                ClientUtils.drawSlot(r.slag.relx, r.slag.rely, 16, 16);
            }
            String s = r.energy + " RF/t";
            ClientUtils.font().func_85187_a(s, 88 - ClientUtils.font().func_78256_a(s) / 2, 32, 0x777777, false);
            s = r.time + " ticks";
            ClientUtils.font().func_85187_a(s, 84 - ClientUtils.font().func_78256_a(s) / 2, 44, 0x777777, false);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiDraw.changeTexture((String)"textures/gui/container/furnace.png");
            GuiDraw.drawTexturedModalRect((int)72, (int)16, (int)80, (int)35, (int)22, (int)16);
            int w = this.cycleticks / 2 % 22;
            GuiDraw.drawTexturedModalRect((int)72, (int)16, (int)177, (int)14, (int)w, (int)16);
        }
        GL11.glPopMatrix();
    }

    public class CachedArcFurnaceRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack[] inputs;
        PositionedStack output;
        PositionedStack slag;
        public int time;
        public int energy;

        public CachedArcFurnaceRecipe(ArcFurnaceRecipe recipe) {
            super((TemplateRecipeHandler)NEIArcFurnaceHandler.this);
            this.inputs = new PositionedStack[recipe.additives.length + 1];
            this.inputs[0] = new PositionedStack(recipe.input, 28, 0);
            for (int i = 0; i < recipe.additives.length; ++i) {
                if (recipe.additives[i] == null) continue;
                this.inputs[i + 1] = new PositionedStack(recipe.additives[i], 20 + i % 2 * 18, 24 + i / 2 * 18);
            }
            this.output = new PositionedStack((Object)recipe.output, 122, 16);
            if (recipe.slag != null) {
                this.slag = new PositionedStack((Object)recipe.slag, 122, 36);
            }
            this.time = recipe.time;
            this.energy = recipe.energyPerTick;
        }

        public PositionedStack getOtherStack() {
            return this.slag;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIArcFurnaceHandler.this.cycleticks / 20, Arrays.asList(this.inputs));
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

