/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.item.construct.clockwork;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lumaceon.mods.clockworkphase.init.ModItems;
import lumaceon.mods.clockworkphase.item.construct.abstracts.IClockwork;
import lumaceon.mods.clockworkphase.item.construct.clockwork.ItemClockworkSaber;
import lumaceon.mods.clockworkphase.lib.MechanicTweaker;
import lumaceon.mods.clockworkphase.network.MessageTemporalItemChange;
import lumaceon.mods.clockworkphase.network.PacketHandler;
import lumaceon.mods.clockworkphase.util.NBTHelper;
import lumaceon.mods.clockworkphase.util.TimeSandParser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemTemporalClockworkSaber
extends ItemClockworkSaber {
    public ItemTemporalClockworkSaber() {
        this.func_77637_a(null);
    }

    public void func_77663_a(ItemStack is, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            int timeSand = this.getTimeSand(is);
            if ((timeSand += this.getTimeSandFromInventory((IInventory)player.field_71071_by)) < MechanicTweaker.TIME_SAND_PER_ENTITY_HIT && player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c) != null && player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c).equals(is)) {
                ItemStack newItem = new ItemStack(this.getItemChangeTo());
                newItem.func_77982_d(is.field_77990_d);
                newItem.func_77964_b(is.func_77960_j());
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newItem);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean flag) {
        list.add("Tension: \u00a7e" + NBTHelper.getInt(is, "tension_energy") + "/" + "\u00a7e" + NBTHelper.getInt(is, "max_tension"));
        int timeSand = this.getTimeSand(is);
        if (timeSand > 0) {
            list.add(TimeSandParser.getStringForRenderingFromTimeSand(timeSand));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("");
            list.add("Clockwork Quality: \u00a7e" + NBTHelper.getInt(is, "cp_quality") + " " + "\u00a7b" + "x 1.5");
            list.add("Clockwork Speed: \u00a7e" + NBTHelper.getInt(is, "cp_speed") + " " + "\u00a7b" + "x 1.5");
            list.add("Memory: \u00a7e" + NBTHelper.getInt(is, "cp_memory"));
            list.add("");
        } else {
            list.add("-Hold shift for details-");
        }
    }

    @Override
    public boolean func_77644_a(ItemStack is, EntityLivingBase entity1, EntityLivingBase entity2) {
        if (is.func_77973_b() instanceof IClockwork && entity2 instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity2;
            int tension = NBTHelper.getInt(is, "tension_energy");
            int quality = NBTHelper.getInt(is, "cp_quality");
            if (quality <= 0) {
                return false;
            }
            int speed = NBTHelper.getInt(is, "cp_speed");
            float efficiency = (float)speed / (float)quality;
            int tensionCost = (int)Math.round((double)MechanicTweaker.TENSION_PER_HIT * Math.pow(efficiency, 2.0));
            int newTension = tension - tensionCost;
            if (newTension <= 0) {
                this.removeTension(is, tension);
                return true;
            }
            entity1.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)speed * 1.5f / 25.0f);
            this.removeTension(is, tensionCost);
            int amountToRemove = MechanicTweaker.TIME_SAND_PER_ENTITY_HIT;
            amountToRemove -= this.removeTimeSandFromInventory((IInventory)player.field_71071_by, amountToRemove);
            amountToRemove -= this.removeTimeSand(is, amountToRemove);
            if (amountToRemove > 0) {
                ItemStack newItem = new ItemStack(this.getItemChangeTo());
                newItem.func_77982_d(is.field_77990_d);
                newItem.func_77964_b(is.func_77960_j());
                if (player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c).equals(is)) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newItem);
                }
            }
        }
        return true;
    }

    @Override
    public void disassemble(World world, double x, double y, double z, ItemStack is) {
    }

    @Override
    public void useTemporalAbility() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageTemporalItemChange());
    }

    @Override
    public Item getItemChangeTo() {
        return ModItems.clockworkSaber;
    }
}

