/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.handler;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import lumaceon.mods.clockworkphase.block.extractor.ExtractorAreas;
import lumaceon.mods.clockworkphase.block.tileentity.TileEntityExtractor;
import lumaceon.mods.clockworkphase.extendeddata.ExtendedPlayerProperties;
import lumaceon.mods.clockworkphase.extendeddata.ExtendedWorldData;
import lumaceon.mods.clockworkphase.init.ModItems;
import lumaceon.mods.clockworkphase.item.construct.clockwork.ItemClockworkSaber;
import lumaceon.mods.clockworkphase.item.construct.clockwork.ItemTemporalClockworkSaber;
import lumaceon.mods.clockworkphase.item.construct.pocketwatch.ItemPocketWatch;
import lumaceon.mods.clockworkphase.lib.MechanicTweaker;
import lumaceon.mods.clockworkphase.lib.Phases;
import lumaceon.mods.clockworkphase.network.MessageParticleSpawn;
import lumaceon.mods.clockworkphase.network.PacketHandler;
import lumaceon.mods.clockworkphase.phaseevent.PhaseEventAbstract;
import lumaceon.mods.clockworkphase.registry.MemoryItemRegistry;
import lumaceon.mods.clockworkphase.util.InventorySearchHelper;
import lumaceon.mods.clockworkphase.util.NBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class EntityHandler {
    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        TileEntity te;
        ExtractorAreas.ExtractorArea area;
        EntityPlayer player;
        if (event.entityLiving instanceof EntityPlayer) {
            player = (EntityPlayer)event.entityLiving;
            ItemStack[] armor = player.field_71071_by.field_70460_b;
            ItemStack[] pocketWatches = InventorySearchHelper.getPocketWatches((IInventory)player.field_71071_by);
            float newAmount = ISpecialArmor.ArmorProperties.ApplyArmor((EntityLivingBase)event.entityLiving, (ItemStack[])armor, (DamageSource)event.source, (double)event.ammount);
            if (newAmount <= 0.0f) {
                return;
            }
            if (pocketWatches != null && ItemPocketWatch.doesActiveItemModuleExist(pocketWatches, ModItems.moduleLifeWalk)) {
                ItemStack lifeWalk = ItemPocketWatch.getItemModuleFromMultiple(pocketWatches, ModItems.moduleLifeWalk);
                double lifeModulePower = NBTHelper.getInt(lifeWalk, "module_power");
                if (lifeModulePower >= 50.0) {
                    if (lifeModulePower / 50.0 >= (double)newAmount) {
                        NBTHelper.setInteger(lifeWalk, "module_power", (int)(lifeModulePower - (double)(50.0f * newAmount)));
                        newAmount = 0.0f;
                    } else {
                        NBTHelper.setInteger(lifeWalk, "module_power", 0);
                        newAmount = (float)((double)newAmount - lifeModulePower / 50.0);
                    }
                }
                event.ammount = newAmount;
            }
        }
        if (event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityPlayer) {
            ItemStack deathWalk;
            double deathModulePower;
            player = (EntityPlayer)event.source.func_76346_g();
            ItemStack[] pocketWatches = InventorySearchHelper.getPocketWatches((IInventory)player.field_71071_by);
            if (pocketWatches != null && ItemPocketWatch.doesActiveItemModuleExist(pocketWatches, ModItems.moduleDeathWalk) && (deathModulePower = (double)NBTHelper.getInt(deathWalk = ItemPocketWatch.getItemModuleFromMultiple(pocketWatches, ModItems.moduleDeathWalk), "module_power")) >= 50.0) {
                NBTHelper.setInteger(deathWalk, "module_power", 0);
                event.ammount = (float)((double)event.ammount + deathModulePower / 50.0);
            }
        }
        if (event.source.func_76347_k() && (area = ExtractorAreas.getAreasFromWorld(event.entity.field_70170_p, Phases.FIRE).getValidArea(event.entity.field_70170_p, (int)event.entityLiving.field_70165_t, (int)event.entityLiving.field_70163_u, (int)event.entityLiving.field_70161_v)) != null && (te = event.entity.field_70170_p.func_147438_o(area.extractorX, area.extractorY, area.extractorZ)) != null && te instanceof TileEntityExtractor) {
            for (float n = 0.0f; n < event.ammount; n += 1.0f) {
                ((TileEntityExtractor)te).applyEffect(Phases.FIRE);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        TileEntity te;
        ExtractorAreas.ExtractorArea area = ExtractorAreas.getAreasFromWorld(event.entity.field_70170_p, Phases.DEATH).getValidArea(event.entity.field_70170_p, (int)event.entityLiving.field_70165_t, (int)event.entityLiving.field_70163_u, (int)event.entityLiving.field_70161_v);
        if (area != null && (te = event.entity.field_70170_p.func_147438_o(area.extractorX, area.extractorY, area.extractorZ)) != null && te instanceof TileEntityExtractor) {
            ((TileEntityExtractor)te).applyEffect(Phases.DEATH);
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        if (event.source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
            if (event.entityLiving.func_110143_aJ() > 0.0f && event.entityLiving.func_110143_aJ() - event.ammount <= 0.0f && player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemClockworkSaber) {
                ItemStack is = player.field_71071_by.func_70448_g();
                int memory = NBTHelper.getInt(is, "cp_memory");
                if (memory > 0 && !player.field_70170_p.field_72995_K) {
                    int memoryWebPower = (int)((double)memory * Math.pow((float)player.field_71068_ca + 1.0f, 2.0));
                    int chance = 12800000;
                    if (memoryWebPower > 0) {
                        chance = 12800000 / memoryWebPower;
                    }
                    if (chance < 1) {
                        chance = 1;
                    }
                    if (player.field_70170_p.field_73012_v.nextInt(chance) == 0) {
                        ((ItemClockworkSaber)is.func_77973_b()).addTimeSand(is, MechanicTweaker.SABER_TIME_SAND_INCREMENT_KILL);
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageParticleSpawn(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, 1), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.field_76574_g, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, 64.0));
                    }
                }
                if (!player.field_70170_p.field_72995_K && is.func_77973_b() instanceof ItemTemporalClockworkSaber) {
                    ItemStack result = new ItemStack(ModItems.nuggetTemporal);
                    float f = 0.7f;
                    double d0 = (double)(player.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(player.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(player.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityitem = new EntityItem(player.field_70170_p, event.entity.field_70165_t + d0, event.entity.field_70163_u + d1, event.entity.field_70161_v + d2, result);
                    entityitem.field_145804_b = 10;
                    player.field_70170_p.func_72838_d((Entity)entityitem);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(LivingSpawnEvent.CheckSpawn event) {
        TileEntity te;
        ExtractorAreas.ExtractorArea area;
        if (!(event.entityLiving instanceof EntityPlayer) && (area = ExtractorAreas.getAreasFromWorld(event.entity.field_70170_p, Phases.LIFE).getValidArea(event.entity.field_70170_p, (int)event.entity.field_70165_t, (int)event.entity.field_70163_u, (int)event.entity.field_70161_v)) != null && (te = event.entity.field_70170_p.func_147438_o(area.extractorX, area.extractorY, area.extractorZ)) != null && te instanceof TileEntityExtractor) {
            ((TileEntityExtractor)te).addTimeSand(MechanicTweaker.TIME_SAND_FROM_NATURAL_SPAWN);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && ExtendedPlayerProperties.get((EntityPlayer)event.entity) == null) {
            ExtendedPlayerProperties.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onEntityItemDrop(LivingDropsEvent event) {
        if (event.entityLiving.field_70170_p != null) {
            if (event.entityLiving.field_70170_p.field_73012_v.nextInt(99) == 0) {
                if (MemoryItemRegistry.memoryItemDrops.size() == 1) {
                    event.drops.add(new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, new ItemStack(MemoryItemRegistry.memoryItemDrops.get(0))));
                } else {
                    if (MemoryItemRegistry.memoryItemDrops.size() <= 0) {
                        return;
                    }
                    event.drops.add(new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, new ItemStack(MemoryItemRegistry.memoryItemDrops.get(event.entity.field_70170_p.field_73012_v.nextInt(MemoryItemRegistry.memoryItemDrops.size())))));
                }
            }
            if (event.entityLiving.field_70170_p.field_73012_v.nextInt(1000) == 0) {
                event.drops.add(new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, new ItemStack(ModItems.gearChronosphere)));
            }
        }
    }

    @SubscribeEvent
    public void onItemDestroyed(PlayerDestroyItemEvent event) {
        ItemStack is = event.original;
        if (NBTHelper.hasTag(is, "temporal_items")) {
            ItemStack[] items = NBTHelper.getInventoryFromNBTTag(is, "temporal_items");
            ItemStack[] newItems = new ItemStack[items.length - 1];
            ItemStack newItem = items[items.length - 1];
            int amountInNew = 0;
            for (int n = 0; n < newItems.length; ++n) {
                if (items[n] == null) continue;
                newItems[n] = items[amountInNew];
                ++amountInNew;
            }
            NBTHelper.setNBTTagListFromInventory(newItem, "temporal_items", newItems);
            if (event.entityPlayer.field_71071_by.func_70448_g() == null) {
                event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, newItem);
            } else {
                if (event.entityPlayer.field_71071_by.func_70441_a(newItem)) {
                    return;
                }
                event.entityPlayer.field_70170_p.func_72838_d((Entity)new EntityItem(event.entityPlayer.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, newItem));
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving != null && MechanicTweaker.PHASE_EVENTS) {
            ExtendedWorldData ewd = ExtendedWorldData.get(event.entityLiving.field_70170_p);
            PhaseEventAbstract phaseEvent = ewd.phaseEvent;
            if (phaseEvent != null) {
                phaseEvent.applyEntityEffects(event.entityLiving);
            }
        }
    }
}

