/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.client.particle.sequence;

import lumaceon.mods.clockworkphase.client.particle.ParticleGenerator;
import lumaceon.mods.clockworkphase.client.particle.entityfx.EntityGrowthAbsorptionFX;
import lumaceon.mods.clockworkphase.client.particle.sequence.ParticleSequence;
import lumaceon.mods.clockworkphase.util.Range2I;

public class ParticleSequenceGrowthAbsorption
extends ParticleSequence {
    public double[] from = new double[3];
    public double[] to = new double[3];
    public double currentTrunkCenter;
    public int startTimer = this.timer = 100;

    public ParticleSequenceGrowthAbsorption(ParticleGenerator particleGenerator, double xFrom, double yFrom, double zFrom, double xTo, double yTo, double zTo) {
        super(particleGenerator);
        this.sequencePhases.add(new Range2I(100, 100));
        this.sequencePhases.add(new Range2I(78, 100));
        this.sequencePhases.add(new Range2I(0, 20));
        this.from[0] = xFrom;
        this.from[1] = yFrom;
        this.from[2] = zFrom;
        this.to[0] = xTo;
        this.to[1] = yTo;
        this.to[2] = zTo;
        this.currentTrunkCenter = this.from[1];
    }

    @Override
    public boolean updateParticleSequence() {
        double x = this.from[0] * (double)this.random.nextFloat();
        double y = this.from[1] * (double)this.random.nextFloat();
        double z = this.from[2] * (double)this.random.nextFloat();
        if (((Range2I)this.sequencePhases.get(0)).isValueInclusivelyWithinRange(this.timer)) {
            x = this.to[0] + 0.5;
            y = this.to[1] + 2.0;
            z = this.to[2] + 0.5;
        }
        if (((Range2I)this.sequencePhases.get(1)).isValueInclusivelyWithinRange(this.timer)) {
            x = this.to[0] + 0.5;
            y = this.to[1] + 2.0;
            z = this.to[2] + 0.5;
        }
        if (((Range2I)this.sequencePhases.get(2)).isValueInclusivelyWithinRange(this.timer)) {
            x = this.from[0] + 0.5;
            y = this.from[1] + 1.5;
            z = this.from[2] + 0.5;
            EntityGrowthAbsorptionFX particle = new EntityGrowthAbsorptionFX(this.particleGenerator.world, x, y, z, this.to[0] + 0.5, this.to[1] + 0.5, this.to[2] + 0.5);
            this.particleGenerator.spawnParticle(particle, 64.0);
        }
        if (this.timer <= 0) {
            return false;
        }
        --this.timer;
        return true;
    }
}

