/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.client.particle;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import lumaceon.mods.clockworkphase.client.particle.ParticleSpawner;
import lumaceon.mods.clockworkphase.client.particle.sequence.ParticleSequence;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class ParticleGenerator {
    public final ParticleSpawner SPAWNER = new ParticleSpawner(this);
    public Minecraft mc;
    public World world;
    public Random random;
    private ArrayList<ParticleSequence> activeSequences = new ArrayList(100);

    public ParticleGenerator(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void spawnParticleSequence(ParticleSequence particleSequence) {
        this.activeSequences.add(particleSequence);
    }

    public void initWorldAndRandom() {
        this.world = this.mc.field_71441_e;
        this.random = this.mc.field_71441_e.field_73012_v;
    }

    public void updateParticleSequences() {
        for (int n = 0; n < this.activeSequences.size(); ++n) {
            if (this.world != null && this.activeSequences.get(n).updateParticleSequence()) continue;
            this.activeSequences.remove(n);
        }
    }

    public EntityFX spawnParticle(EntityFX particle, double cutoff) {
        if (this.canSpawnParticle(particle.field_70165_t, particle.field_70163_u, particle.field_70161_v, cutoff)) {
            this.mc.field_71452_i.func_78873_a(particle);
            return particle;
        }
        return null;
    }

    private boolean canSpawnParticle(double x, double y, double z, double maxDistance) {
        if (this.mc == null || Minecraft.func_71410_x().field_71441_e == null || this.mc.field_71451_h == null || this.mc.field_71452_i == null) {
            return false;
        }
        int userSettings = this.mc.field_71474_y.field_74362_aa;
        if (userSettings == 1 && this.world.field_73012_v.nextInt(3) == 0 || userSettings == 2) {
            return false;
        }
        double xDistance = this.mc.field_71451_h.field_70165_t - x;
        double yDistance = this.mc.field_71451_h.field_70163_u - y;
        double zDistance = this.mc.field_71451_h.field_70161_v - z;
        double cutoffDistance = maxDistance;
        if (xDistance * xDistance + yDistance * yDistance + zDistance * zDistance > cutoffDistance * cutoffDistance) {
            return false;
        }
        if (this.world == null) {
            this.world = this.mc.field_71441_e;
        }
        return true;
    }
}

