/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.tileentity;

import com.whammich.sstow.utils.Config;
import com.whammich.sstow.utils.EntityMapper;
import com.whammich.sstow.utils.ModLogger;
import com.whammich.sstow.utils.Register;
import com.whammich.sstow.utils.TierHandler;
import com.whammich.sstow.utils.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityCage
extends TileEntity
implements ISidedInventory {
    private ItemStack inventory;
    private int counter = 0;
    private int updateCounter = 0;
    private int tier;
    private static final int[] slot = new int[]{0, 1, 2, 3, 4, 5};
    private String entName;
    private boolean redstoneActive = false;
    private boolean initChecks = false;
    private boolean active = false;
    String Owner;

    public void addOwner(String playerName) {
        this.Owner = playerName;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, Register.SOUL_CAGE);
        if (!this.initChecks) {
            this.checkRedstone();
            this.initChecks = true;
        }
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 0 || this.tier <= 0) {
            this.updateCounter = 0;
            this.counter = 0;
            return;
        }
        if (this.updateCounter == 19) {
            EntityLiving ent = EntityMapper.getNewEntityInstance(this.field_145850_b, this.entName);
            if (this.canEntitySpawn(ent)) {
                this.setMetadata(2);
                this.active = true;
            } else {
                this.setMetadata(1);
                this.active = false;
            }
            this.updateCounter = 0;
        } else {
            ++this.updateCounter;
        }
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) <= 1) {
            this.counter = 0;
            return;
        }
        if (this.counter >= TierHandler.getCooldown(this.tier - 1) * 20 - 1) {
            if (Config.ENABLE_DEBUG) {
                ModLogger.logInfo("Successfully spawned: " + this.entName);
            }
            EntityLiving[] toSpawn = new EntityLiving[TierHandler.getNumSpawns(this.tier - 1)];
            ItemStack heldItem = Utils.getEntityHeldItem(this.inventory);
            for (int i = 0; i < toSpawn.length; ++i) {
                toSpawn[i] = EntityMapper.getNewEntityInstance(this.field_145850_b, this.entName);
                if (toSpawn[i] instanceof EntitySlime) {
                    toSpawn[i].func_70096_w().func_75692_b(16, (Object)1);
                }
                if (heldItem != null) {
                    toSpawn[i].func_70062_b(0, heldItem);
                }
                for (int j = 1; j <= 4; ++j) {
                    toSpawn[i].func_70062_b(j, Utils.getEntityArmor(this.inventory, j));
                }
                toSpawn[i].getEntityData().func_74757_a("SSTOW", true);
                toSpawn[i].field_98038_p = true;
                toSpawn[i].func_110163_bv();
            }
            this.spawnEntities(toSpawn);
            this.counter = 0;
        } else {
            ++this.counter;
        }
    }

    public void checkRedstone() {
        this.redstoneActive = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void setMetadata(int meta) {
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) != meta) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, 2);
        }
    }

    private boolean canEntitySpawn(EntityLiving ent) {
        if (Config.ENABLE_FLOOD_PREVENTION && this.hasReachedSpawnLimit(ent)) {
            return false;
        }
        if (TierHandler.getChecksRedstone(this.tier - 1) && this.redstoneActive == Config.INVERT_REDSTONE) {
            return false;
        }
        if (TierHandler.getChecksPlayer(this.tier - 1) && !this.isPlayerClose(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return false;
        }
        if (TierHandler.getChecksLight(this.tier - 1) && !this.canSpawnInLight(ent)) {
            return false;
        }
        return !TierHandler.getChecksWorld(this.tier - 1) || this.canSpawnInWorld(ent);
    }

    private boolean isPlayerClose(int x, int y, int z) {
        return this.field_145850_b.func_72977_a((double)x, (double)y, (double)z, 16.0) != null;
    }

    private boolean canSpawnInWorld(EntityLiving ent) {
        int dimension = this.field_145850_b.field_73011_w.field_76574_g;
        if (ent instanceof EntitySkeleton) {
            EntitySkeleton skele = (EntitySkeleton)ent;
            if (skele.func_82202_m() == 1 && dimension == -1) {
                return true;
            }
            return dimension == 0;
        }
        if (ent instanceof EntityBlaze || ent instanceof EntityPigZombie || ent instanceof EntityGhast || ent instanceof EntityMagmaCube) {
            return dimension == -1;
        }
        if (ent instanceof EntityEnderman) {
            return dimension == 1;
        }
        return true;
    }

    private boolean canSpawnInLight(EntityLiving ent) {
        int light = this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (ent instanceof EntityMob || ent instanceof IMob) {
            return light <= 8;
        }
        if (ent instanceof EntityAnimal || ent instanceof IAnimals) {
            return light > 8;
        }
        return true;
    }

    private boolean canSpawnAtCoords(EntityLiving ent) {
        return this.field_145850_b.func_72945_a((Entity)ent, ent.field_70121_D).isEmpty();
    }

    private boolean hasReachedSpawnLimit(EntityLiving ent) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 16), (double)(this.field_145848_d - 16), (double)(this.field_145849_e - 16), (double)(this.field_145851_c + 16), (double)(this.field_145848_d + 16), (double)(this.field_145849_e + 16));
        int mobCount = 0;
        for (EntityLiving entity : this.field_145850_b.func_72872_a(ent.getClass(), aabb)) {
            if (!entity.getEntityData().func_74767_n("SSTOW")) continue;
            ++mobCount;
        }
        return mobCount >= Config.MAX_NUM_ENTITIES;
    }

    private void spawnEntities(EntityLiving[] ents) {
        for (EntityLiving ent : ents) {
            int counter = 0;
            do {
                if (++counter >= 5) {
                    ent.func_70106_y();
                    break;
                }
                double x = (double)this.field_145851_c + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * 4.0;
                double y = this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(3) - 1;
                double z = (double)this.field_145849_e + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * 4.0;
                ent.func_70012_b(x, y, z, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            } while (!this.canSpawnAtCoords(ent) || counter >= 5);
            if (ent.field_70128_L) continue;
            this.field_145850_b.func_72838_d((Entity)ent);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.initChecks = false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventory = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Shard"));
        if (this.inventory != null) {
            this.tier = Utils.getShardTier(this.inventory);
            this.entName = Utils.getShardBoundEnt(this.inventory);
        }
        this.active = nbt.func_74767_n("active");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.inventory != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.inventory.func_77955_b(tag);
            nbt.func_74782_a("Shard", (NBTBase)tag);
        }
        nbt.func_74757_a("active", this.active);
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory;
    }

    public ItemStack func_70298_a(int slot, int qty) {
        if (qty == 0) {
            return null;
        }
        ItemStack stack = this.inventory.func_77946_l();
        this.inventory = null;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
        this.tier = 0;
        this.entName = null;
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory = stack;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
        this.tier = Utils.getShardTier(this.inventory);
        this.entName = Utils.getShardBoundEnt(this.inventory);
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int getTier() {
        return this.tier;
    }

    public String getEntityName() {
        return this.entName;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null && stack.func_77973_b() == Register.SOUL_SHARD && Utils.isShardBound(stack) && Utils.getShardTier(stack) > 0;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public int[] func_94128_d(int var1) {
        return var1 == 0 ? slot : (var1 == 1 ? slot : slot);
    }

    public boolean func_102007_a(int var1, ItemStack stack, int p_102007_3_) {
        return this.func_94041_b(var1, stack);
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return true;
    }
}

