/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.events;

import cofh.core.entity.CoFHFakePlayer;
import com.whammich.sstow.utils.Config;
import com.whammich.sstow.utils.EntityMapper;
import com.whammich.sstow.utils.ModLogger;
import com.whammich.sstow.utils.Register;
import com.whammich.sstow.utils.Utils;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class PlayerKillEntityEvent {
    @SubscribeEvent
    public void onEntityKill(LivingDeathEvent event) {
        ItemStack shard;
        World world = event.entity.field_70170_p;
        if (Loader.isModLoaded((String)"CoFHCore") && event.source.func_76346_g() instanceof CoFHFakePlayer) {
            return;
        }
        if (world.field_72995_K || !(event.entity instanceof EntityLiving) || !(event.source.func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityLiving dead = (EntityLiving)event.entity;
        if (dead.getEntityData().func_74767_n("SSTOW")) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
        String entName = EntityList.func_75621_b((Entity)dead);
        if (entName == null || entName.isEmpty()) {
            ModLogger.logFatal("Player killed entity with no unlocalized name: " + dead);
            return;
        }
        if (!EntityMapper.isEntityValid(entName)) {
            return;
        }
        if (dead instanceof EntitySkeleton && ((EntitySkeleton)dead).func_82202_m() == 1) {
            entName = "Wither Skeleton";
        }
        if ((shard = Utils.getShardFromInv(player, entName)) != null) {
            if (!Utils.isShardBound(shard)) {
                Utils.setShardBoundEnt(shard, entName);
                Utils.writeEntityHeldItem(shard, dead);
            }
            Utils.writeEntityArmor(shard, dead);
            int soulStealer = EnchantmentHelper.func_77506_a((int)Register.SOUL_STEALER.field_77352_x, (ItemStack)player.func_70694_bm());
            Utils.increaseShardKillCount(shard, (short)(1 + (soulStealer *= Config.ENCHANT_KILL_BONUS)));
            Utils.checkForAchievements(player, shard);
        }
    }
}

