/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.util.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.lomeli.lomlib.util.BlockUtil;
import net.lomeli.lomlib.util.entity.SimpleEggInfo;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityUtil {
    private static List<SimpleEggInfo> eggList = new ArrayList<SimpleEggInfo>();

    public static void addEgg(SimpleEggInfo info) {
        eggList.add(info);
    }

    public static SimpleEggInfo getEggInfo(int index) {
        return index < eggList.size() ? eggList.get(index) : null;
    }

    public static int getEggListSize() {
        return eggList.size();
    }

    public static void sendToChat(EntityPlayer player, String message) {
        player.func_146105_b((IChatComponent)new ChatComponentText(message));
    }

    public static boolean isHostileEntity(EntityLivingBase entity) {
        return entity instanceof IMob;
    }

    public static boolean isUndeadEntity(EntityLivingBase entity) {
        return EntityUtil.isHostileEntity(entity) ? entity.func_70668_bt().equals((Object)EnumCreatureAttribute.UNDEAD) : false;
    }

    public static boolean isEntityMoving(Entity entity) {
        return entity != null && (entity.field_70159_w != 0.0 || entity.field_70181_x != 0.0 || entity.field_70179_y != 0.0);
    }

    public static void entityDropItem(EntityLivingBase entity, ItemStack itemStack, double dropRate, boolean hostile) {
        if (hostile) {
            double random;
            if (EntityUtil.isHostileEntity(entity) && (random = Math.random()) < dropRate) {
                entity.func_70099_a(itemStack, 0.0f);
            }
        } else {
            double random = Math.random();
            if (random < dropRate) {
                entity.func_70099_a(itemStack, 0.0f);
            }
        }
    }

    @Deprecated
    public static boolean wasEntityKilledByPlayer(DamageSource source) {
        return EntityUtil.damageFromPlayer(source);
    }

    public static boolean damageFromPlayer(DamageSource source) {
        if (source.func_76355_l().equals("player")) {
            return true;
        }
        return source.func_76364_f() instanceof EntityArrow && ((EntityArrow)source.func_76364_f()).field_70250_c != null && ((EntityArrow)source.func_76364_f()).field_70250_c instanceof EntityPlayer;
    }

    public static void spawnItemOnPlayer(World worldObj, EntityPlayer player, ItemStack stack) {
        Random rand = new Random();
        EntityItem entityItem = new EntityItem(worldObj, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
        float factor = 0.05f;
        entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
        entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
        worldObj.func_72838_d((Entity)entityItem);
    }

    public static boolean transformEntityItem(World world, int x, int y, int z, EntityPlayer player, ItemStack init, ItemStack transformation, ItemStack requiredItem, boolean effect) {
        List entityList = world.func_72872_a(EntityItem.class, player.field_70121_D.func_72314_b(15.0, 15.0, 15.0));
        for (int i = 0; i < entityList.size(); ++i) {
            EntityItem item;
            Entity ent = (Entity)entityList.get(i);
            if (ent == null || !(ent instanceof EntityItem) || !BlockUtil.isAboveBlock((Entity)(item = (EntityItem)ent), x, y, z) || item == null || !item.func_92059_d().func_77977_a().equals(init.func_77977_a()) || player.func_71045_bC() == null || !player.func_71045_bC().func_77977_a().equals(requiredItem.func_77977_a()) || player.func_71045_bC().func_77960_j() != requiredItem.func_77960_j()) continue;
            ItemStack manual = transformation;
            manual.field_77994_a = item.func_92059_d().field_77994_a;
            if (manual == null) continue;
            if (!world.field_72995_K) {
                item.func_92058_a(manual);
                player.func_71045_bC().func_77972_a(manual.field_77994_a, (EntityLivingBase)player);
            }
            if (effect) {
                for (int k = 0; k < 2; ++k) {
                    world.func_72869_a("largesmoke", item.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * (double)item.field_70130_N, item.field_70163_u + 0.5 + world.field_73012_v.nextDouble() * (double)item.field_70131_O, item.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * (double)item.field_70130_N, 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean teleportRandomly(EntityLivingBase entity) {
        double var1 = entity.field_70165_t + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * 64.0;
        double var3 = entity.field_70163_u + (double)(entity.field_70170_p.field_73012_v.nextInt(64) - 32);
        double var5 = entity.field_70161_v + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * 64.0;
        return EntityUtil.teleportTo(entity, var1, var3, var5);
    }

    public static boolean teleportToEntity(EntityLivingBase entity, Entity par1Entity) {
        Vec3 var2 = Vec3.func_72443_a((double)(entity.field_70165_t - par1Entity.field_70165_t), (double)(entity.field_70121_D.field_72338_b + (double)(entity.field_70131_O / 2.0f) - par1Entity.field_70163_u + (double)par1Entity.func_70047_e()), (double)(entity.field_70161_v - par1Entity.field_70161_v));
        var2 = var2.func_72432_b();
        double var3 = 16.0;
        double var5 = entity.field_70165_t + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * 8.0 - var2.field_72450_a * var3;
        double var7 = entity.field_70163_u + (double)(entity.field_70170_p.field_73012_v.nextInt(16) - 8) - var2.field_72448_b * var3;
        double var9 = entity.field_70161_v + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * 8.0 - var2.field_72449_c * var3;
        return EntityUtil.teleportTo(entity, var5, var7, var9);
    }

    public static boolean teleportTo(EntityLivingBase entity, double par1, double par3, double par5) {
        int var16;
        int var15;
        double var7 = entity.field_70165_t;
        double var9 = entity.field_70163_u;
        double var11 = entity.field_70161_v;
        entity.field_70165_t = par1;
        entity.field_70163_u = par3;
        entity.field_70161_v = par5;
        boolean var13 = false;
        int var14 = MathHelper.func_76128_c((double)entity.field_70165_t);
        if (entity.field_70170_p.func_72899_e(var14, var15 = MathHelper.func_76128_c((double)entity.field_70163_u), var16 = MathHelper.func_76128_c((double)entity.field_70161_v))) {
            boolean var17 = false;
            while (!var17 && var15 > 0) {
                Block var18 = entity.field_70170_p.func_147439_a(var14, var15 - 1, var16);
                if (var18 != null && var18.func_149688_o().func_76230_c()) {
                    var17 = true;
                    continue;
                }
                entity.field_70163_u -= 1.0;
                --var15;
            }
            if (var17) {
                entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (entity.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty() && !entity.field_70170_p.func_72953_d(entity.field_70121_D)) {
                    var13 = true;
                }
            }
        }
        if (!var13) {
            entity.func_70634_a(var7, var9, var11);
            return false;
        }
        int var30 = 128;
        for (int j = 0; j < var30; ++j) {
            double var19 = (double)j / ((double)var30 - 1.0);
            float var21 = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float var22 = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float var23 = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            double var24 = var7 + (entity.field_70165_t - var7) * var19 + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            double var26 = var9 + (entity.field_70163_u - var9) * var19 + entity.field_70170_p.field_73012_v.nextDouble() * (double)entity.field_70131_O;
            double var28 = var11 + (entity.field_70161_v - var11) * var19 + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            entity.field_70170_p.func_72869_a("portal", var24, var26, var28, (double)var21, (double)var22, (double)var23);
        }
        entity.field_70170_p.func_72908_a(var7, var9, var11, "mob.endermen.portal", 1.0f, 1.0f);
        entity.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    public static boolean isFakePlayer(EntityPlayer player) {
        return player != null ? player.getClass() != EntityPlayerMP.class : false;
    }

    public static MovingObjectPosition rayTrace(EntityPlayer player, World world) {
        return EntityUtil.rayTrace(player, world, true);
    }

    public static MovingObjectPosition rayTrace(EntityPlayer player, World world, boolean hitLiquids) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (double)player.func_70047_e() + (player.field_70163_u - player.field_70167_r) * ((double)f + 1.62);
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3d = Vec3.func_72443_a((double)d, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * 0.01745329f - 3.141593f));
        float f4 = MathHelper.func_76126_a((float)(-f2 * 0.01745329f - 3.141593f));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * 0.01745329f));
        float f6 = MathHelper.func_76126_a((float)(-f1 * 0.01745329f));
        float f7 = f4 * f5;
        float f8 = f6;
        float f9 = f3 * f5;
        double d3 = 5000.0;
        Vec3 vec3d2 = vec3d.func_72441_c((double)f7 * d3, (double)f8 * d3, (double)f9 * d3);
        MovingObjectPosition mop = world.func_72901_a(vec3d, vec3d2, hitLiquids);
        return mop;
    }
}

