/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.util;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    public static final Color blankColor = new Color(255, 255, 255);
    public static final ResourceLocation BLOCK_TEXTURE = TextureMap.field_110575_b;
    public static final ResourceLocation ITEM_TEXTURE = TextureMap.field_110576_c;
    public static final int DISPLAY_STAGES = 100;
    public static final ResourceLocation texEnchant = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public static final float magicNum = 0.0625f;
    private static Map<Fluid, int[]> flowingRenderCache = new HashMap<Fluid, int[]>();
    private static Map<Fluid, int[]> stillRenderCache = new HashMap<Fluid, int[]>();

    public static void drawBlockFaces(RenderBlocks renderer, Block block, IIcon icon) {
        RenderUtils.drawBlockFaces(renderer, block, icon, icon, icon, icon, icon, icon);
    }

    public static void drawBlockFaces(RenderBlocks renderer, Block block, IIcon i0, IIcon i1, IIcon i2, IIcon i3, IIcon i4, IIcon i5) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        if (block != null) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderer.func_147768_a(block, 0.0, -0.5, 0.0, i0);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderer.func_147806_b(block, 0.0, -0.5, 0.0, i1);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderer.func_147761_c(block, 0.0, -0.5, 0.0, i2);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderer.func_147734_d(block, 0.0, -0.5, 0.0, i3);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderer.func_147798_e(block, 0.0, -0.5, 0.0, i4);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderer.func_147764_f(block, 0.0, -0.5, 0.0, i5);
            tessellator.func_78381_a();
            GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderBlock(IBlockAccess world, int x, int y, int z, Block block, RenderBlocks renderer, IIcon icon) {
        if (block.func_149646_a(world, x + 1, y, z, 6)) {
            renderer.func_147764_f(block, (double)x, (double)y, (double)z, icon);
        }
        if (block.func_149646_a(world, x - 1, y, z, 6)) {
            renderer.func_147798_e(block, (double)x, (double)y, (double)z, icon);
        }
        if (block.func_149646_a(world, x, y, z + 1, 6)) {
            renderer.func_147734_d(block, (double)x, (double)y, (double)z, icon);
        }
        if (block.func_149646_a(world, x, y, z - 1, 6)) {
            renderer.func_147761_c(block, (double)x, (double)y, (double)z, icon);
        }
        if (block.func_149646_a(world, x, y + 1, z, 6)) {
            renderer.func_147806_b(block, (double)x, (double)y, (double)z, icon);
        }
        if (block.func_149646_a(world, x, y - 1, z, 6)) {
            renderer.func_147768_a(block, (double)x, (double)y, (double)z, icon);
        }
    }

    public static void bindTexture(String modid, String texture) {
        ResourceLocation rl = new ResourceLocation(modid + ":" + texture);
        RenderUtils.bindTexture(rl);
    }

    public static void bindTexture(ResourceLocation rl) {
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(rl);
    }

    public static void resetColor() {
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static IIcon multiRenderPass(int renderPass, IIcon ... icons) {
        return renderPass < icons.length ? icons[renderPass] : icons[0];
    }

    public static void applyColor(Color color) {
        RenderUtils.applyColor(color, 1.0f);
    }

    public static void applyColor(Color color, float alpha) {
        RenderUtils.applyColor(color.getRGB(), alpha);
    }

    public static void applyColor(int rgb) {
        RenderUtils.applyColor(rgb, 1.0f);
    }

    public static void applyColor(float r, float g, float b) {
        RenderUtils.applyColor(r, g, b, 1.0f);
    }

    public static void applyColor(int rgb, float alpha) {
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        RenderUtils.applyColor(r, g, b, alpha);
    }

    public static void applyColor(float r, float g, float b, float alpha) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)alpha);
    }

    public static IIcon getFluidTexture(FluidStack fluidStack, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        return RenderUtils.getFluidTexture(fluidStack.getFluid(), flowing);
    }

    public static IIcon getFluidTexture(Fluid fluid, boolean flowing) {
        IIcon icon;
        if (fluid == null) {
            return null;
        }
        IIcon iIcon = icon = flowing ? fluid.getFlowingIcon() : fluid.getStillIcon();
        if (icon == null) {
            icon = ((TextureMap)RenderUtils.getTextureManager().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    public static ResourceLocation getFluidSheet(FluidStack liquid) {
        if (liquid == null) {
            return BLOCK_TEXTURE;
        }
        return RenderUtils.getFluidSheet(liquid.getFluid());
    }

    public static ResourceLocation getFluidSheet(Fluid liquid) {
        return BLOCK_TEXTURE;
    }

    public static void setColorForFluidStack(FluidStack fluidstack) {
        if (fluidstack != null) {
            RenderUtils.applyColor(fluidstack.getFluid().getColor(fluidstack));
        }
    }

    public static void renderItemIn3d(ItemStack stack) {
        TextureManager textureManager = RenderUtils.getTextureManager();
        if (textureManager == null) {
            return;
        }
        Item item = stack.func_77973_b();
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)32826);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.03125f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int passes = item.getRenderPasses(stack.func_77960_j());
        for (int pass = 0; pass < passes; ++pass) {
            textureManager.func_110577_a(stack.func_94608_d() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
            IIcon icon = item.getIcon(stack, pass);
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            RenderUtils.applyColor(item.func_82790_a(stack, pass));
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        }
        if (stack.hasEffect(0)) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            textureManager.func_110577_a(texEnchant);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            float f7 = 0.76f;
            GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public static void renderEntityGhostItem(World world, ItemStack stack, RenderItem customRender, int x, int y, int z, ForgeDirection forgeDirection) {
        GL11.glPushMatrix();
        if (stack != null) {
            float scaleFactor = RenderUtils.getGhostItemScaleFactor(stack, customRender);
            float rotationAngle = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
            EntityItem ghostEntityItem = new EntityItem(world);
            ghostEntityItem.field_70290_d = 0.0f;
            ghostEntityItem.func_92058_a(stack);
            RenderUtils.translateGhostItemByOrientation(ghostEntityItem.func_92059_d(), x, y, z, forgeDirection);
            GL11.glScalef((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
            GL11.glRotatef((float)rotationAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            customRender.func_76986_a(ghostEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        }
        GL11.glPopMatrix();
    }

    private static void translateGhostItemByOrientation(ItemStack ghostItemStack, double x, double y, double z, ForgeDirection forgeDirection) {
        if (ghostItemStack != null) {
            if (ghostItemStack.func_77973_b() instanceof ItemBlock) {
                switch (forgeDirection) {
                    case DOWN: {
                        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.7f), (float)((float)z + 0.5f));
                        return;
                    }
                    case UP: {
                        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.25f), (float)((float)z + 0.5f));
                        return;
                    }
                    case NORTH: {
                        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.7f));
                        return;
                    }
                    case SOUTH: {
                        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.3f));
                        return;
                    }
                    case EAST: {
                        GL11.glTranslatef((float)((float)x + 0.3f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
                        return;
                    }
                    case WEST: {
                        GL11.glTranslatef((float)((float)x + 0.7f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
                        return;
                    }
                    case UNKNOWN: {
                        return;
                    }
                }
                return;
            }
            switch (forgeDirection) {
                case DOWN: {
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.6f), (float)((float)z + 0.5f));
                    return;
                }
                case UP: {
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.2f), (float)((float)z + 0.5f));
                    return;
                }
                case NORTH: {
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.4f), (float)((float)z + 0.7f));
                    return;
                }
                case SOUTH: {
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.4f), (float)((float)z + 0.3f));
                    return;
                }
                case EAST: {
                    GL11.glTranslatef((float)((float)x + 0.3f), (float)((float)y + 0.4f), (float)((float)z + 0.5f));
                    return;
                }
                case WEST: {
                    GL11.glTranslatef((float)((float)x + 0.7f), (float)((float)y + 0.4f), (float)((float)z + 0.5f));
                    return;
                }
                case UNKNOWN: {
                    return;
                }
            }
            return;
        }
    }

    private static float getGhostItemScaleFactor(ItemStack itemStack, RenderItem customRenderItem) {
        float scaleFactor = 1.0f;
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof ItemBlock) {
                switch (customRenderItem.getMiniBlockCount(itemStack, (byte)0)) {
                    case 1: {
                        return 0.9f;
                    }
                    case 2: {
                        return 0.9f;
                    }
                    case 3: {
                        return 0.9f;
                    }
                    case 4: {
                        return 0.9f;
                    }
                    case 5: {
                        return 0.8f;
                    }
                }
                return 0.9f;
            }
            switch (customRenderItem.getMiniItemCount(itemStack, (byte)0)) {
                case 1: {
                    return 0.65f;
                }
                case 2: {
                    return 0.65f;
                }
                case 3: {
                    return 0.65f;
                }
                case 4: {
                    return 0.65f;
                }
            }
            return 0.65f;
        }
        return scaleFactor;
    }

    public static TextureManager getTextureManager() {
        return Minecraft.func_71410_x().func_110434_K();
    }

    public static void renderItemToolTip(int x, int y, ItemStack stack) {
        int color = 0x505000FF;
        int color2 = -267386864;
        List toolTipData = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
        ArrayList<String> parsedTooltip = new ArrayList<String>();
        boolean first = true;
        Iterator iterator = toolTipData.iterator();
        while (iterator.hasNext()) {
            String s;
            String s_ = s = (String)iterator.next();
            if (!first) {
                s_ = EnumChatFormatting.GRAY + s;
            }
            parsedTooltip.add(s_);
            first = false;
        }
        RenderUtils.renderTooltip(x, y, parsedTooltip, color, color2);
    }

    public static void renderTooltip(int x, int y, List<String> tooltipData, int color, int color2) {
        boolean lighting = GL11.glGetBoolean((int)2896);
        if (lighting) {
            RenderHelper.func_74518_a();
        }
        if (!tooltipData.isEmpty()) {
            int var7;
            int var6;
            int var5 = 0;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            for (var6 = 0; var6 < tooltipData.size(); ++var6) {
                var7 = fontRenderer.func_78256_a(tooltipData.get(var6));
                if (var7 <= var5) continue;
                var5 = var7;
            }
            var6 = x + 12;
            var7 = y - 12;
            int var9 = 8;
            if (tooltipData.size() > 1) {
                var9 += 2 + (tooltipData.size() - 1) * 10;
            }
            float z = 300.0f;
            RenderUtils.drawGradientRect(var6 - 3, var7 - 4, z, var6 + var5 + 3, var7 - 3, color2, color2);
            RenderUtils.drawGradientRect(var6 - 3, var7 + var9 + 3, z, var6 + var5 + 3, var7 + var9 + 4, color2, color2);
            RenderUtils.drawGradientRect(var6 - 3, var7 - 3, z, var6 + var5 + 3, var7 + var9 + 3, color2, color2);
            RenderUtils.drawGradientRect(var6 - 4, var7 - 3, z, var6 - 3, var7 + var9 + 3, color2, color2);
            RenderUtils.drawGradientRect(var6 + var5 + 3, var7 - 3, z, var6 + var5 + 4, var7 + var9 + 3, color2, color2);
            int var12 = (color & 0xFFFFFF) >> 1 | color & 0xFF000000;
            RenderUtils.drawGradientRect(var6 - 3, var7 - 3 + 1, z, var6 - 3 + 1, var7 + var9 + 3 - 1, color, var12);
            RenderUtils.drawGradientRect(var6 + var5 + 2, var7 - 3 + 1, z, var6 + var5 + 3, var7 + var9 + 3 - 1, color, var12);
            RenderUtils.drawGradientRect(var6 - 3, var7 - 3, z, var6 + var5 + 3, var7 - 3 + 1, color, color);
            RenderUtils.drawGradientRect(var6 - 3, var7 + var9 + 2, z, var6 + var5 + 3, var7 + var9 + 3, var12, var12);
            GL11.glDisable((int)2929);
            for (int var13 = 0; var13 < tooltipData.size(); ++var13) {
                String var14 = tooltipData.get(var13);
                fontRenderer.func_78261_a(var14, var6, var7, -1);
                if (var13 == 0) {
                    var7 += 2;
                }
                var7 += 10;
            }
            GL11.glEnable((int)2929);
        }
        if (!lighting) {
            RenderHelper.func_74518_a();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawGradientRect(int par1, int par2, float z, int par3, int par4, int par5, int par6) {
        float var7 = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(par5 & 0xFF) / 255.0f;
        float var11 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float var12 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float var13 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float var14 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator var15 = Tessellator.field_78398_a;
        var15.func_78382_b();
        var15.func_78369_a(var8, var9, var10, var7);
        var15.func_78377_a((double)par3, (double)par2, (double)z);
        var15.func_78377_a((double)par1, (double)par2, (double)z);
        var15.func_78369_a(var12, var13, var14, var11);
        var15.func_78377_a((double)par1, (double)par4, (double)z);
        var15.func_78377_a((double)par3, (double)par4, (double)z);
        var15.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }
}

