/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.core.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.lomeli.lomlib.LomLib;
import net.lomeli.lomlib.core.network.AbstractPacket;
import net.lomeli.lomlib.core.network.BasicIndexCodec;
import net.lomeli.lomlib.core.network.SidedPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;

@ChannelHandler.Sharable
public class PacketHandler
extends SimpleChannelInboundHandler<AbstractPacket> {
    private EnumMap<Side, FMLEmbeddedChannel> channel;
    private BasicIndexCodec packetCodec;

    public PacketHandler(String modid, Class<? extends AbstractPacket> ... classes) {
        LomLib.logger.logInfo("Creating packet handler for " + modid);
        this.packetCodec = new BasicIndexCodec(classes);
        this.channel = NetworkRegistry.INSTANCE.newChannel(modid, new ChannelHandler[]{this.packetCodec, this});
    }

    protected void channelRead0(ChannelHandlerContext ctx, AbstractPacket msg) throws Exception {
        SidedPacket sidedPacket = msg.getClass().getAnnotation(SidedPacket.class);
        if (sidedPacket == null) {
            throw new RuntimeException("Packet not sided. Packet must use @SidedPacket annotation!");
        }
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                if (!sidedPacket.acceptedClientSide()) break;
                msg.handlePacket(FMLCommonHandler.instance().getEffectiveSide());
                break;
            }
            case SERVER: {
                if (!sidedPacket.acceptedServerSide()) break;
                msg.handlePacket(FMLCommonHandler.instance().getEffectiveSide());
            }
        }
    }

    public void sendToAll(AbstractPacket message) {
        SidedPacket sidedPacket = message.getClass().getAnnotation(SidedPacket.class);
        if (sidedPacket == null) {
            LomLib.logger.logError("Packet class must be sided using SidedPacket.");
            return;
        }
        if (!sidedPacket.acceptedClientSide()) {
            LomLib.logger.logError("Packet must be accepted on client side.");
            return;
        }
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channel.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendTo(AbstractPacket message, EntityPlayer player) {
        SidedPacket sidedPacket = message.getClass().getAnnotation(SidedPacket.class);
        if (sidedPacket == null) {
            LomLib.logger.logError("Packet class must be sided using SidedPacket.");
            return;
        }
        if (!sidedPacket.acceptedClientSide()) {
            LomLib.logger.logError("Packet must be accepted on client side.");
            return;
        }
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channel.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToAllAround(AbstractPacket message, NetworkRegistry.TargetPoint point) {
        SidedPacket sidedPacket = message.getClass().getAnnotation(SidedPacket.class);
        if (sidedPacket == null) {
            LomLib.logger.logError("Packet class must be sided using SidedPacket.");
            return;
        }
        if (!sidedPacket.acceptedClientSide()) {
            LomLib.logger.logError("Packet must be accepted on client side.");
            return;
        }
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channel.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToDimension(AbstractPacket message, int dimensionId) {
        SidedPacket sidedPacket = message.getClass().getAnnotation(SidedPacket.class);
        if (sidedPacket == null) {
            LomLib.logger.logError("Packet class must be sided using SidedPacket.");
            return;
        }
        if (!sidedPacket.acceptedClientSide()) {
            LomLib.logger.logError("Packet must be accepted on client side.");
            return;
        }
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channel.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToServer(AbstractPacket message) {
        SidedPacket sidedPacket = message.getClass().getAnnotation(SidedPacket.class);
        if (sidedPacket == null) {
            LomLib.logger.logError("Packet class must be sided using SidedPacket.");
            return;
        }
        if (!sidedPacket.acceptedServerSide()) {
            LomLib.logger.logError("Packet must be accepted server side.");
            return;
        }
        this.channel.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channel.get(Side.CLIENT).writeAndFlush((Object)message);
    }

    public Packet generatePacketFrom(AbstractPacket message) {
        return this.channel.get(Side.SERVER).generatePacketFrom((Object)message);
    }

    public void sendEverywhere(AbstractPacket message) {
        this.sendToAll(message);
        this.sendToServer(message);
    }
}

