/*
 * Decompiled with CFR 0.152.
 */
package com.sapient.ibench.inventory;

import com.sapient.ibench.items.ItemIBench;
import com.sapient.ibench.util.NBTHelper;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryIBench
extends InventoryCrafting {
    public ItemStack parent;
    public EntityPlayer player;
    protected ItemStack[] inventory;
    private Container eventHandler;
    protected ItemStack[] recipes;

    public InventoryIBench(EntityPlayer player, ItemStack itemStack) {
        super(null, 3, 3);
        this.parent = itemStack;
        this.player = player;
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.readFromNBT(this.parent.func_77978_p());
    }

    public void setEventHandler(Container eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.eventHandler.func_75130_a((IInventory)this);
    }

    public ItemStack func_70463_b(int row, int col) {
        if (row >= 0 && row < 3) {
            int k = row + col * 3;
            return this.func_70301_a(k);
        }
        return null;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return slotIndex >= this.func_70302_i_() ? null : this.inventory[slotIndex];
    }

    public int func_70302_i_() {
        return 9;
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        if (this.inventory[slotIndex] != null) {
            if (this.inventory[slotIndex].field_77994_a <= amount) {
                ItemStack itemstack = this.inventory[slotIndex];
                this.inventory[slotIndex] = null;
                this.eventHandler.func_75130_a((IInventory)this);
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slotIndex].func_77979_a(amount);
            if (this.inventory[slotIndex].field_77994_a == 0) {
                this.inventory[slotIndex] = null;
            }
            this.eventHandler.func_75130_a((IInventory)this);
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public String func_145825_b() {
        return "crafting.inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void onGuiSaved(EntityPlayer entityPlayer) {
        if (this.parent != null) {
            this.save();
        }
    }

    public ItemStack findParentItemStack(EntityPlayer entityPlayer) {
        if (NBTHelper.hasUUID(this.parent)) {
            UUID parentUUID = new UUID(this.parent.func_77978_p().func_74763_f("MostSigUUID"), this.parent.func_77978_p().func_74763_f("LeastSigUUID"));
            for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = entityPlayer.field_71071_by.func_70301_a(i);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemIBench) || !NBTHelper.hasUUID(itemStack) || itemStack.func_77978_p().func_74763_f("MostSigUUID") != parentUUID.getMostSignificantBits() || itemStack.func_77978_p().func_74763_f("LeastSigUUID") != parentUUID.getLeastSignificantBits()) continue;
                return itemStack;
            }
        }
        return null;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.parent = this.findParentItemStack(this.player);
        if (this.parent != null && (nbtTagCompound = this.parent.func_77978_p()) != null && nbtTagCompound.func_74764_b("Items")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
            this.inventory = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                byte j = stackTag.func_74771_c("Slot");
                if (i < 0 || i > this.inventory.length) continue;
                this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
            }
        }
    }

    public void save() {
        NBTTagCompound nbtTagCompound = this.parent.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
        }
        this.writeToNBT(nbtTagCompound);
        this.parent.func_77982_d(nbtTagCompound);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = this.findParentItemStack(this.player).func_77978_p();
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
    }
}

