/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.core.network.message;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import de.keridos.floodlights.tileentity.TileEntityCarbonFloodlight;
import de.keridos.floodlights.tileentity.TileEntityFL;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;

public class MessageTileEntityFL
implements IMessage,
IMessageHandler<MessageTileEntityFL, IMessage> {
    public int x;
    public int y;
    public int z;
    public int timeRemaining;
    public byte orientation;
    public byte state;
    public String customName;
    public String owner;

    public MessageTileEntityFL() {
    }

    public MessageTileEntityFL(TileEntity tileEntity) {
        if (tileEntity instanceof TileEntityFL) {
            TileEntityFL tileEntityFL = (TileEntityFL)tileEntity;
            this.x = tileEntityFL.field_145851_c;
            this.y = tileEntityFL.field_145848_d;
            this.z = tileEntityFL.field_145849_e;
            this.timeRemaining = tileEntity instanceof TileEntityCarbonFloodlight ? ((TileEntityCarbonFloodlight)tileEntity).timeRemaining : 0;
            this.orientation = (byte)tileEntityFL.getOrientation().ordinal();
            this.state = (byte)tileEntityFL.getState();
            this.customName = tileEntityFL.getCustomName();
            this.owner = tileEntityFL.getOwner();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.timeRemaining = buf.readInt();
        this.orientation = buf.readByte();
        this.state = buf.readByte();
        int customNameLength = buf.readInt();
        this.customName = new String(buf.readBytes(customNameLength).array());
        int ownerLength = buf.readInt();
        this.owner = new String(buf.readBytes(ownerLength).array());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.timeRemaining);
        buf.writeByte((int)this.orientation);
        buf.writeByte((int)this.state);
        buf.writeInt(this.customName.length());
        buf.writeBytes(this.customName.getBytes());
        buf.writeInt(this.owner.length());
        buf.writeBytes(this.owner.getBytes());
    }

    public IMessage onMessage(MessageTileEntityFL message, MessageContext ctx) {
        TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.x, message.y, message.z);
        if (tileEntity instanceof TileEntityFL) {
            ((TileEntityFL)tileEntity).setOrientation(message.orientation);
            ((TileEntityFL)tileEntity).setState(message.state);
            ((TileEntityFL)tileEntity).setCustomName(message.customName);
            ((TileEntityFL)tileEntity).setOwner(message.owner);
        }
        if (tileEntity instanceof TileEntityCarbonFloodlight) {
            ((TileEntityCarbonFloodlight)tileEntity).timeRemaining = message.timeRemaining;
        }
        return null;
    }

    public String toString() {
        return String.format("MessageTileEntityFL - x:%s, y:%s, z:%s, timeRemaining:%s, orientation:%s, state:%s, customName:%s, owner:%s", this.x, this.y, this.z, this.timeRemaining, this.orientation, this.state, this.customName, this.owner);
    }
}

