/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.lib;

import li.cil.repack.org.luaj.vm2.LuaTable;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.Varargs;
import li.cil.repack.org.luaj.vm2.lib.LibFunction;
import li.cil.repack.org.luaj.vm2.lib.TwoArgFunction;
import li.cil.repack.org.luaj.vm2.lib.VarArgFunction;

public class TableLib
extends TwoArgFunction {
    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        LuaTable table = new LuaTable();
        table.set("concat", (LuaValue)new concat());
        table.set("insert", (LuaValue)new insert());
        table.set("pack", (LuaValue)new pack());
        table.set("remove", (LuaValue)new remove());
        table.set("sort", (LuaValue)new sort());
        table.set("unpack", (LuaValue)new unpack());
        env.set("table", (LuaValue)table);
        env.get("package").get("loaded").set("table", (LuaValue)table);
        return NIL;
    }

    static class unpack
    extends VarArgFunction {
        unpack() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaTable t = args.checktable(1);
            switch (args.narg()) {
                case 1: {
                    return t.unpack();
                }
                case 2: {
                    return t.unpack(args.checkint(2));
                }
            }
            return t.unpack(args.checkint(2), args.checkint(3));
        }
    }

    static class sort
    extends TwoArgFunction {
        sort() {
        }

        @Override
        public LuaValue call(LuaValue table, LuaValue compare) {
            table.checktable().sort(compare.isnil() ? NIL : compare.checkfunction());
            return NONE;
        }
    }

    static class remove
    extends TableLibFunction {
        remove() {
        }

        @Override
        public LuaValue call(LuaValue list2) {
            return list2.checktable().remove(0);
        }

        @Override
        public LuaValue call(LuaValue list2, LuaValue pos) {
            return list2.checktable().remove(pos.checkint());
        }
    }

    static class pack
    extends VarArgFunction {
        pack() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaTable t = pack.tableOf(args, 1);
            t.set("n", args.narg());
            return t;
        }
    }

    static class insert
    extends TableLibFunction {
        insert() {
        }

        @Override
        public LuaValue call(LuaValue list2) {
            return insert.argerror(2, "value expected");
        }

        @Override
        public LuaValue call(LuaValue table, LuaValue value) {
            table.checktable().insert(table.length() + 1, value);
            return NONE;
        }

        @Override
        public LuaValue call(LuaValue table, LuaValue pos, LuaValue value) {
            table.checktable().insert(pos.checkint(), value);
            return NONE;
        }
    }

    static class concat
    extends TableLibFunction {
        concat() {
        }

        @Override
        public LuaValue call(LuaValue list2) {
            return list2.checktable().concat(EMPTYSTRING, 1, list2.length());
        }

        @Override
        public LuaValue call(LuaValue list2, LuaValue sep) {
            return list2.checktable().concat(sep.checkstring(), 1, list2.length());
        }

        @Override
        public LuaValue call(LuaValue list2, LuaValue sep, LuaValue i) {
            return list2.checktable().concat(sep.checkstring(), i.checkint(), list2.length());
        }

        @Override
        public LuaValue call(LuaValue list2, LuaValue sep, LuaValue i, LuaValue j) {
            return list2.checktable().concat(sep.checkstring(), i.checkint(), j.checkint());
        }
    }

    static class TableLibFunction
    extends LibFunction {
        TableLibFunction() {
        }

        @Override
        public LuaValue call() {
            return TableLibFunction.argerror(1, "table expected, got no value");
        }
    }
}

