/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.component;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings$;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.EnvironmentHost;
import li.cil.oc.api.fs.Label;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.ManagedEnvironment;
import li.cil.oc.server.PacketSender$;
import li.cil.oc.server.component.Drive$;
import li.cil.oc.server.component.package$;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import scala.Array$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001B\u0001\u0003\u00015\u0011Q\u0001\u0012:jm\u0016T!a\u0001\u0003\u0002\u0013\r|W\u000e]8oK:$(BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u0003_\u000eT!!\u0003\u0006\u0002\u0007\rLGNC\u0001\f\u0003\ta\u0017n\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0019\u0001(/\u001a4bE*\u00111CB\u0001\u0004CBL\u0017BA\u000b\u0011\u0005Ii\u0015M\\1hK\u0012,eN^5s_:lWM\u001c;\t\u0011]\u0001!Q1A\u0005\u0002a\t\u0001bY1qC\u000eLG/_\u000b\u00023A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t\u0019\u0011J\u001c;\t\u0011\u0001\u0002!\u0011!Q\u0001\ne\t\u0011bY1qC\u000eLG/\u001f\u0011\t\u0011\t\u0002!Q1A\u0005\u0002a\tA\u0002\u001d7biR,'oQ8v]RD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!G\u0001\u000ea2\fG\u000f^3s\u0007>,h\u000e\u001e\u0011\t\u0011\u0019\u0002!Q1A\u0005\u0002\u001d\nQ\u0001\\1cK2,\u0012\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0003WI\t!AZ:\n\u00055R#!\u0002'bE\u0016d\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\r1\f'-\u001a7!\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014\u0001\u00025pgR\u00042AG\u001a6\u0013\t!4D\u0001\u0004PaRLwN\u001c\t\u0003mej\u0011a\u000e\u0006\u0003qI\ta\u0001\u001a:jm\u0016\u0014\u0018B\u0001\u001e8\u0005=)eN^5s_:lWM\u001c;I_N$\b\u0002\u0003\u001f\u0001\u0005\u000b\u0007I\u0011A\u001f\u0002\u000bM|WO\u001c3\u0016\u0003y\u00022AG\u001a@!\t\u00015I\u0004\u0002\u001b\u0003&\u0011!iG\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002C7!Aq\t\u0001B\u0001B\u0003%a(\u0001\u0004t_VtG\r\t\u0005\u0006\u0013\u0002!\tAS\u0001\u0007y%t\u0017\u000e\u001e \u0015\r-kej\u0014)R!\ta\u0005!D\u0001\u0003\u0011\u00159\u0002\n1\u0001\u001a\u0011\u0015\u0011\u0003\n1\u0001\u001a\u0011\u00151\u0003\n1\u0001)\u0011\u0015\t\u0004\n1\u00013\u0011\u0015a\u0004\n1\u0001?\u0011\u001d\u0019\u0006A1A\u0005BQ\u000bAA\\8eKV\tQ\u000b\u0005\u0002W36\tqK\u0003\u0002Y%\u00059a.\u001a;x_J\\\u0017B\u0001.X\u0005I\u0019u.\u001c9p]\u0016tGoQ8o]\u0016\u001cGo\u001c:\t\rq\u0003\u0001\u0015!\u0003V\u0003\u0015qw\u000eZ3!\u0011\u0015q\u0006\u0001\"\u0003`\u0003!\u0019\u0018M^3QCRDW#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017AA5p\u0015\u0005)\u0017\u0001\u00026bm\u0006L!a\u001a2\u0003\t\u0019KG.\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0004k\u0003)\u0019Xm\u0019;peNK'0Z\u000b\u0002W>\tA.\b\u0002\u0003\u0001!1a\u000e\u0001Q\u0001\u000e-\f1b]3di>\u00148+\u001b>fA!9\u0001\u000f\u0001b\u0001\n\u0013\t\u0018\u0001\u00023bi\u0006,\u0012A\u001d\t\u00045M,\u0018B\u0001;\u001c\u0005\u0015\t%O]1z!\tQb/\u0003\u0002x7\t!!)\u001f;f\u0011\u0019I\b\u0001)A\u0005e\u0006)A-\u0019;bA!91\u0010\u0001b\u0001\n\u0013A\u0012aC:fGR|'oQ8v]RDa! \u0001!\u0002\u0013I\u0012\u0001D:fGR|'oQ8v]R\u0004\u0003bB@\u0001\u0005\u0004%I\u0001G\u0001\u0012g\u0016\u001cGo\u001c:t!\u0016\u0014\b\u000b\\1ui\u0016\u0014\bbBA\u0002\u0001\u0001\u0006I!G\u0001\u0013g\u0016\u001cGo\u001c:t!\u0016\u0014\b\u000b\\1ui\u0016\u0014\b\u0005\u0003\u0005\u0002\b\u0001\u0001\r\u0011\"\u0003\u0019\u0003\u001dAW-\u00193Q_ND\u0011\"a\u0003\u0001\u0001\u0004%I!!\u0004\u0002\u0017!,\u0017\r\u001a)pg~#S-\u001d\u000b\u0005\u0003\u001f\t)\u0002E\u0002\u001b\u0003#I1!a\u0005\u001c\u0005\u0011)f.\u001b;\t\u0013\u0005]\u0011\u0011BA\u0001\u0002\u0004I\u0012a\u0001=%c!9\u00111\u0004\u0001!B\u0013I\u0012\u0001\u00035fC\u0012\u0004vn\u001d\u0011\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\u0005Aq-\u001a;MC\n,G\u000e\u0006\u0004\u0002$\u0005-\u00121\b\t\u00055M\f)\u0003E\u0002\u001b\u0003OI1!!\u000b\u001c\u0005\u0019\te.\u001f*fM\"A\u0011QFA\u000f\u0001\u0004\ty#A\u0004d_:$X\r\u001f;\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e\u0013\u0003\u001di\u0017m\u00195j]\u0016LA!!\u000f\u00024\t91i\u001c8uKb$\b\u0002CA\u001f\u0003;\u0001\r!a\u0010\u0002\t\u0005\u0014xm\u001d\t\u0005\u0003c\t\t%\u0003\u0003\u0002D\u0005M\"!C!sOVlWM\u001c;tQ1\ti\"a\u0012\u0002N\u0005=\u0013\u0011KA*!\u0011\t\t$!\u0013\n\t\u0005-\u00131\u0007\u0002\t\u0007\u0006dGNY1dW\u00061A-\u001b:fGRL\u0012!A\u0001\u0004I>\u001c\u0017EAA+\u0003a2WO\\2uS>t\u0007&\u000b\u001etiJLgn\u001a\u0011.[\u0001:U\r\u001e\u0011uQ\u0016\u00043-\u001e:sK:$\b\u0005\\1cK2\u0004sN\u001a\u0011uQ\u0016\u0004CM]5wK:Bq!!\u0017\u0001\t\u0003\tY&\u0001\u0005tKRd\u0015MY3m)\u0019\t\u0019#!\u0018\u0002`!A\u0011QFA,\u0001\u0004\ty\u0003\u0003\u0005\u0002>\u0005]\u0003\u0019AA Q!\t9&a\u0012\u0002R\u0005\r\u0014EAA3\u000314WO\\2uS>t\u0007F^1mk\u0016T4\u000f\u001e:j]\u001eL#h\u001d;sS:<\u0007%L\u0017!'\u0016$8\u000f\t;iK\u0002b\u0017MY3mA=4\u0007\u0005\u001e5fA\u0011\u0014\u0018N^3/AI+G/\u001e:og\u0002\"\b.\u001a\u0011oK^\u0004c/\u00197vK2\u0002s\u000f[5dQ\u0002j\u0017-\u001f\u0011cK\u0002\"(/\u001e8dCR,GM\f\u0005\b\u0003S\u0002A\u0011AA6\u0003-9W\r^\"ba\u0006\u001c\u0017\u000e^=\u0015\r\u0005\r\u0012QNA8\u0011!\ti#a\u001aA\u0002\u0005=\u0002\u0002CA\u001f\u0003O\u0002\r!a\u0010)\u0019\u0005\u001d\u0014qIA'\u0003\u001f\n\t&a\u001d\"\u0005\u0005U\u0014a\u00124v]\u000e$\u0018n\u001c8)SirW/\u001c2fe\u0002jS\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004Co\u001c;bY\u0002\u001a\u0017\r]1dSRL\be\u001c4!i\",\u0007\u0005\u001a:jm\u0016d\u0003%\u001b8!Ef$Xm\u001d\u0018\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|\u0005iq-\u001a;TK\u000e$xN]*ju\u0016$b!a\t\u0002~\u0005}\u0004\u0002CA\u0017\u0003o\u0002\r!a\f\t\u0011\u0005u\u0012q\u000fa\u0001\u0003\u007fAC\"a\u001e\u0002H\u00055\u0013qJA)\u0003\u0007\u000b#!!\"\u0002!\u001a,hn\u0019;j_:D\u0013F\u000f8v[\n,'\u000fI\u0017.AI+G/\u001e:og\u0002\"\b.\u001a\u0011tSj,\u0007e\u001c4!C\u0002\u001a\u0018N\\4mK\u0002\u001aXm\u0019;pe\u0002zg\u000e\t;iK\u0002\"'/\u001b<fY\u0001Jg\u000e\t2zi\u0016\u001ch\u0006C\u0004\u0002\n\u0002!\t!a#\u0002\u001f\u001d,G\u000f\u00157biR,'oQ8v]R$b!a\t\u0002\u000e\u0006=\u0005\u0002CA\u0017\u0003\u000f\u0003\r!a\f\t\u0011\u0005u\u0012q\u0011a\u0001\u0003\u007fAC\"a\"\u0002H\u00055\u0013qJA)\u0003'\u000b#!!&\u0002\u0003\u001a,hn\u0019;j_:D\u0013F\u000f8v[\n,'\u000fI\u0017.AI+G/\u001e:og\u0002\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002\u0002H.\u0019;uKJ\u001c\b%\u001b8!i\",\u0007\u0005\u001a:jm\u0016t\u0003bBAM\u0001\u0011\u0005\u00111T\u0001\u000be\u0016\fGmU3di>\u0014HCBA\u0012\u0003;\u000by\n\u0003\u0005\u0002.\u0005]\u0005\u0019AA\u0018\u0011!\ti$a&A\u0002\u0005}\u0002bBAR\u0001\u0011\u0005\u0011QU\u0001\foJLG/Z*fGR|'\u000f\u0006\u0004\u0002$\u0005\u001d\u0016\u0011\u0016\u0005\t\u0003[\t\t\u000b1\u0001\u00020!A\u0011QHAQ\u0001\u0004\ty\u0004C\u0004\u0002.\u0002!\t!a,\u0002\u0011I,\u0017\r\u001a\"zi\u0016$b!a\t\u00022\u0006M\u0006\u0002CA\u0017\u0003W\u0003\r!a\f\t\u0011\u0005u\u00121\u0016a\u0001\u0003\u007fAq!a.\u0001\t\u0003\tI,A\u0005xe&$XMQ=uKR1\u00111EA^\u0003{C\u0001\"!\f\u00026\u0002\u0007\u0011q\u0006\u0005\t\u0003{\t)\f1\u0001\u0002@!9\u0011\u0011\u0019\u0001\u0005B\u0005\r\u0017\u0001\u00027pC\u0012$B!a\u0004\u0002F\"A\u0011qYA`\u0001\u0004\tI-A\u0002oER\u0004B!a3\u0002X6\u0011\u0011Q\u001a\u0006\u0005\u0003\u000f\fyM\u0003\u0003\u0002R\u0006M\u0017!C7j]\u0016\u001c'/\u00194u\u0015\t\t).A\u0002oKRLA!!7\u0002N\nqaJ\u0011+UC\u001e\u001cu.\u001c9pk:$\u0007bBAo\u0001\u0011\u0005\u0013q\\\u0001\u0005g\u00064X\r\u0006\u0003\u0002\u0010\u0005\u0005\b\u0002CAd\u00037\u0004\r!!3\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\u0006qa/\u00197jI\u0006$XmU3di>\u0014HcA\r\u0002j\"9\u00111^Ar\u0001\u0004I\u0012AB:fGR|'\u000fC\u0004\u0002p\u0002!I!!=\u0002\u0017\rDWmY6TK\u000e$xN\u001d\u000b\u00043\u0005M\bbBA{\u0003[\u0004\r!G\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005=\b\u0001\"\u0003\u0002zR)\u0011$a?\u0002~\"A\u0011QHA|\u0001\u0004\ty\u0004C\u0004\u0002\u0000\u0006]\b\u0019A\r\u0002\u00039DqAa\u0001\u0001\t\u0013\u0011)!\u0001\u0007n_Z,Gk\\*fGR|'\u000fF\u0003\u001a\u0005\u000f\u0011I\u0001\u0003\u0005\u0002.\t\u0005\u0001\u0019AA\u0018\u0011\u001d\tYO!\u0001A\u0002eAqA!\u0004\u0001\t\u0013\u0011y!A\btK\u000e$xN\u001d+p\u0011\u0016\fG\rU8t)\rI\"\u0011\u0003\u0005\b\u0003W\u0014Y\u00011\u0001\u001a\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005/\tAb]3di>\u0014xJ\u001a4tKR$2!\u0007B\r\u0011\u001d\tYOa\u0005A\u0002eAqA!\b\u0001\t\u0013\u0011y\"\u0001\u0007pM\u001a\u001cX\r^*fGR|'\u000fF\u0002\u001a\u0005CAq!!>\u0003\u001c\u0001\u0007\u0011\u0004C\u0004\u0003&\u0001!IAa\n\u0002\u0019\u0011L7o[!di&4\u0018\u000e^=\u0015\u0005\u0005=qa\u0002B\u0016\u0005!\u0005!QF\u0001\u0006\tJLg/\u001a\t\u0004\u0019\n=bAB\u0001\u0003\u0011\u0003\u0011\td\u0005\u0003\u00030\u0005\u0015\u0002bB%\u00030\u0011\u0005!Q\u0007\u000b\u0003\u0005[A\u0001B!\u000f\u00030\u0011\u0005!1H\u0001\u0006CB\u0004H.\u001f\u000b\u000e\u0017\nu\"q\bB!\u0005\u0007\u0012)Ea\u0012\t\r]\u00119\u00041\u0001\u001a\u0011\u0019\u0011#q\u0007a\u00013!1aEa\u000eA\u0002!Ba!\rB\u001c\u0001\u0004\u0011\u0004B\u0002\u001f\u00038\u0001\u0007a\bC\u0005\u0003J\t]\u0002\u0013!a\u00013\u0005)1\u000f]3fI\"Q!Q\nB\u0018#\u0003%\tAa\u0014\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIY*\"A!\u0015+\u0007e\u0011\u0019f\u000b\u0002\u0003VA!!q\u000bB1\u001b\t\u0011IF\u0003\u0003\u0003\\\tu\u0013!C;oG\",7m[3e\u0015\r\u0011yfG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B2\u00053\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class Drive
extends ManagedEnvironment {
    private final int capacity;
    private final int platterCount;
    private final Label label;
    private final Option<EnvironmentHost> host;
    private final Option<String> sound;
    private final ComponentConnector node;
    private final int sectorSize;
    private final byte[] data;
    private final int sectorCount;
    private final int sectorsPerPlatter;
    private int headPos;

    public static int apply$default$6() {
        return Drive$.MODULE$.apply$default$6();
    }

    public static Drive apply(int n, int n2, Label label, Option<EnvironmentHost> option, Option<String> option2, int n3) {
        return Drive$.MODULE$.apply(n, n2, label, option, option2, n3);
    }

    public int capacity() {
        return this.capacity;
    }

    public int platterCount() {
        return this.platterCount;
    }

    public Label label() {
        return this.label;
    }

    public Option<String> sound() {
        return this.sound;
    }

    @Override
    public ComponentConnector node() {
        return this.node;
    }

    private File savePath() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), new StringBuilder().append((Object)Settings$.MODULE$.savePath()).append((Object)this.node().address()).append((Object)".bin").toString());
    }

    private final int sectorSize() {
        return 512;
    }

    private byte[] data() {
        return this.data;
    }

    private int sectorCount() {
        return this.sectorCount;
    }

    private int sectorsPerPlatter() {
        return this.sectorsPerPlatter;
    }

    private int headPos() {
        return this.headPos;
    }

    private void headPos_$eq(int x$1) {
        this.headPos = x$1;
    }

    @Callback(direct=true, doc="function():string -- Get the current label of the drive.")
    public synchronized Object[] getLabel(Context context, Arguments args) {
        return this.label() == null ? null : package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.label().getLabel()}));
    }

    @Callback(doc="function(value:string):string -- Sets the label of the drive. Returns the new value, which may be truncated.")
    public synchronized Object[] setLabel(Context context, Arguments args) {
        if (this.label() == null) {
            throw new Exception("drive does not support labeling");
        }
        if (args.checkAny(0) == null) {
            this.label().setLabel(null);
        } else {
            this.label().setLabel(args.checkString(0));
        }
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.label().getLabel()}));
    }

    @Callback(direct=true, doc="function():number -- Returns the total capacity of the drive, in bytes.")
    public Object[] getCapacity(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.capacity())}));
    }

    @Callback(direct=true, doc="function():number -- Returns the size of a single sector on the drive, in bytes.")
    public Object[] getSectorSize(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)512)}));
    }

    @Callback(direct=true, doc="function():number -- Returns the number of platters in the drive.")
    public Object[] getPlatterCount(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.platterCount())}));
    }

    public synchronized Object[] readSector(Context context, Arguments args) {
        int sector = this.moveToSector(context, this.checkSector(args, 0));
        this.diskActivity();
        byte[] sectorData = new byte[512];
        Array$.MODULE$.copy((Object)this.data(), this.sectorOffset(sector), (Object)sectorData, 0, 512);
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sectorData}));
    }

    public synchronized Object[] writeSector(Context context, Arguments args) {
        byte[] sectorData = args.checkByteArray(1);
        int sector = this.moveToSector(context, this.checkSector(args, 0));
        this.diskActivity();
        Array$.MODULE$.copy((Object)sectorData, 0, (Object)this.data(), this.sectorOffset(sector), scala.math.package$.MODULE$.min(512, sectorData.length));
        return null;
    }

    public synchronized Object[] readByte(Context context, Arguments args) {
        int offset = args.checkInteger(0) - 1;
        this.moveToSector(context, this.checkSector(offset));
        this.diskActivity();
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)this.data()[offset])}));
    }

    public synchronized Object[] writeByte(Context context, Arguments args) {
        int offset = args.checkInteger(0) - 1;
        byte value = (byte)args.checkInteger(1);
        this.moveToSector(context, this.checkSector(offset));
        this.diskActivity();
        this.data()[offset] = value;
        return null;
    }

    @Override
    public synchronized void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (this.node().address() != null) {
            try {
                File path = this.savePath();
                if (path.exists()) {
                    ByteArrayInputStream bin = new ByteArrayInputStream(Files.toByteArray((File)path));
                    GZIPInputStream zin = new GZIPInputStream(bin);
                    int read = 0;
                    for (int offset = 0; read >= 0 && offset < this.data().length; offset += read) {
                        read = zin.read(this.data(), offset, this.data().length - offset);
                    }
                }
            }
            catch (Throwable throwable) {
                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed loading drive contents for '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node().address()})), throwable);
            }
        }
        this.headPos_$eq(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(nbt.func_74762_e("headPos")), 0)), this.sectorToHeadPos(this.sectorCount())));
        if (this.label() != null) {
            this.label().load(nbt);
        }
    }

    @Override
    public synchronized void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.node().address() != null) {
            try {
                File path = this.savePath();
                path.getParentFile().mkdirs();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                GZIPOutputStream zos = new GZIPOutputStream(bos);
                zos.write(this.data());
                zos.close();
                Files.write((byte[])bos.toByteArray(), (File)path);
            }
            catch (Throwable throwable) {
                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed saving drive contents for '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node().address()})), throwable);
            }
        }
        nbt.func_74768_a("headPos", this.headPos());
        if (this.label() != null) {
            this.label().save(nbt);
        }
    }

    private int validateSector(int sector) {
        if (sector < 0 || sector >= this.sectorCount()) {
            throw new IllegalArgumentException("invalid offset, not in a usable sector");
        }
        return sector;
    }

    private int checkSector(int offset) {
        return this.validateSector(this.offsetSector(offset));
    }

    private int checkSector(Arguments args, int n) {
        return this.validateSector(args.checkInteger(n) - 1);
    }

    private int moveToSector(Context context, int sector) {
        int newHeadPos = this.sectorToHeadPos(sector);
        if (this.headPos() != newHeadPos) {
            int delta = scala.math.package$.MODULE$.abs(this.headPos() - newHeadPos);
            Object object = delta > Settings$.MODULE$.get().sectorSeekThreshold() ? BoxesRunTime.boxToBoolean((boolean)context.pause(Settings$.MODULE$.get().sectorSeekTime())) : BoxedUnit.UNIT;
            this.headPos_$eq(newHeadPos);
        }
        return sector;
    }

    private int sectorToHeadPos(int sector) {
        return sector % this.sectorsPerPlatter();
    }

    private int sectorOffset(int sector) {
        return sector * 512;
    }

    private int offsetSector(int offset) {
        return offset / 512;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void diskActivity() {
        Tuple2 tuple2 = new Tuple2(this.sound(), this.host);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String s = (String)some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    EnvironmentHost h = (EnvironmentHost)some2.x();
                    PacketSender$.MODULE$.sendFileSystemActivity(this.node(), h, s);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Drive(int capacity, int platterCount, Label label, Option<EnvironmentHost> host, Option<String> sound) {
        this.capacity = capacity;
        this.platterCount = platterCount;
        this.label = label;
        this.host = host;
        this.sound = sound;
        this.node = (ComponentConnector)Network.newNode(this, Visibility.Network).withComponent("drive", Visibility.Neighbors).withConnector().create();
        this.data = new byte[capacity];
        this.sectorCount = capacity / 512;
        this.sectorsPerPlatter = this.sectorCount() / platterCount;
        this.headPos = 0;
    }
}

