/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mcjty.network.NetworkTools;
import mcjty.rftools.items.teleportprobe.GuiAdvancedPorter;

public class PacketTargetsReady
implements IMessage,
IMessageHandler<PacketTargetsReady, IMessage> {
    private int target;
    private int[] targets;
    private String[] names;

    public void fromBytes(ByteBuf buf) {
        this.target = buf.readInt();
        int size = buf.readInt();
        this.targets = new int[size];
        this.names = new String[size];
        for (int i = 0; i < size; ++i) {
            this.targets[i] = buf.readInt();
            this.names[i] = NetworkTools.readString((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.target);
        buf.writeInt(this.targets.length);
        for (int i = 0; i < this.targets.length; ++i) {
            buf.writeInt(this.targets[i]);
            NetworkTools.writeString((ByteBuf)buf, (String)this.names[i]);
        }
    }

    public PacketTargetsReady() {
    }

    public PacketTargetsReady(int target, int[] targets, String[] names) {
        this.target = target;
        this.targets = targets;
        this.names = names;
    }

    public IMessage onMessage(PacketTargetsReady message, MessageContext ctx) {
        GuiAdvancedPorter.setInfo(message.target, message.targets, message.names);
        return null;
    }
}

