/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.varia.Logging;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class StorageModuleItem
extends Item {
    private final IIcon[] icons = new IIcon[7];
    private IIcon activeIcon;
    public static final int STORAGE_TIER1 = 0;
    public static final int STORAGE_TIER2 = 1;
    public static final int STORAGE_TIER3 = 2;
    public static final int STORAGE_REMOTE = 6;
    public static final int[] MAXSIZE = new int[]{100, 200, 300, 0, 0, 0, -1};

    public StorageModuleItem() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        for (int i = 0; i < 7; ++i) {
            if (MAXSIZE[i] == 0) continue;
            this.icons[i] = iconRegister.func_94245_a("rftools:storage/storageModule" + i);
        }
        this.activeIcon = iconRegister.func_94245_a("rftools:storage/storageModule6Active");
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "Place this module in a storage module tablet to access contents"));
            return stack;
        }
        return stack;
    }

    public static void updateStackSize(ItemStack stack, int numStacks) {
        if (stack == null || stack.field_77994_a == 0) {
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a("count", numStacks);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        int max = MAXSIZE[itemStack.func_77960_j()];
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            StorageModuleItem.addModuleInformation(list, max, tagCompound);
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This storage module is for the Modular Storage block.");
            if (max == -1) {
                list.add(EnumChatFormatting.WHITE + "This module supports a remote inventory.");
                list.add(EnumChatFormatting.WHITE + "Link to another storage module in the remote storage block.");
            } else {
                list.add(EnumChatFormatting.WHITE + "This module supports " + max + " stacks");
            }
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    public static void addModuleInformation(List list, int max, NBTTagCompound tagCompound) {
        if (max == -1) {
            if (tagCompound.func_74764_b("id")) {
                int id = tagCompound.func_74762_e("id");
                list.add(EnumChatFormatting.GREEN + "Remote id: " + id);
            } else {
                list.add(EnumChatFormatting.YELLOW + "Unlinked");
            }
        } else {
            int cnt = tagCompound.func_74762_e("count");
            if (tagCompound.func_74764_b("id")) {
                int id = tagCompound.func_74762_e("id");
                list.add(EnumChatFormatting.GREEN + "Contents id: " + id);
            }
            list.add(EnumChatFormatting.GREEN + "Contents: " + cnt + "/" + max + " stacks");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        int damage = stack.func_77960_j();
        if (damage == 6) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null && tagCompound.func_74764_b("id")) {
                return this.activeIcon;
            }
            return this.icons[damage];
        }
        return this.icons[damage];
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + itemStack.func_77960_j();
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < 7; ++i) {
            if (MAXSIZE[i] == 0) continue;
            list.add(new ItemStack((Item)ModularStorageSetup.storageModuleItem, 1, i));
        }
    }
}

