/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimensionmonitor;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.DimensionStorage;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.network.PacketGetDimensionEnergy;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.varia.Logging;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class DimensionMonitorItem
extends Item {
    private static long lastTime = 0L;
    private IIcon[] powerLevel = new IIcon[9];

    public DimensionMonitorItem() {
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            int id = player.field_70170_p.field_73011_w.field_76574_g;
            RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(player.field_70170_p);
            DimensionInformation dimensionInformation = dimensionManager.getDimensionInformation(id);
            if (dimensionInformation == null) {
                Logging.message((EntityPlayer)player, (String)"Not an RFTools dimension!");
            } else {
                String name = dimensionInformation.getName();
                DimensionStorage storage = DimensionStorage.getDimensionStorage(player.func_130014_f_());
                int power = storage != null ? storage.getEnergyLevel(id) : 0;
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.BLUE + "Name: " + name + " (Id " + id + ")" + EnumChatFormatting.YELLOW + "    Power: " + power + " RF"));
                if (player.func_70093_af()) {
                    Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Description: " + dimensionInformation.getDescriptor().getDescriptionString()));
                    System.out.println("Description:  = " + dimensionInformation.getDescriptor().getDescriptionString());
                }
            }
            return stack;
        }
        return stack;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        for (int i = 0; i <= 8; ++i) {
            this.powerLevel[i] = iconRegister.func_94245_a("rftools:dimensionMonitorItemL" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        int id = player.field_70170_p.field_73011_w.field_76574_g;
        DimensionStorage storage = DimensionStorage.getDimensionStorage(player.field_70170_p);
        int energyLevel = storage.getEnergyLevel(id);
        int level = 9 * energyLevel / DimletConfiguration.MAX_DIMENSION_POWER;
        if (level < 0) {
            level = 0;
        } else if (level > 8) {
            level = 8;
        }
        return this.powerLevel[8 - level];
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        int id = player.field_70170_p.field_73011_w.field_76574_g;
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(player.field_70170_p);
        DimensionInformation dimensionInformation = dimensionManager.getDimensionInformation(id);
        if (dimensionInformation == null) {
            list.add("Not an RFTools dimension!");
        } else {
            if (System.currentTimeMillis() - lastTime > 500L) {
                lastTime = System.currentTimeMillis();
                RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetDimensionEnergy(id));
            }
            String name = dimensionInformation.getName();
            DimensionStorage storage = DimensionStorage.getDimensionStorage(player.func_130014_f_());
            int power = storage != null ? storage.getEnergyLevel(id) : 0;
            list.add(EnumChatFormatting.BLUE + "Name: " + name + " (Id " + id + ")");
            list.add(EnumChatFormatting.YELLOW + "Power: " + power + " RF");
        }
    }
}

