/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.devdelight;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.gui.Scrollable;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.Layout;
import mcjty.gui.layout.VerticalLayout;
import mcjty.gui.widgets.AbstractContainerWidget;
import mcjty.gui.widgets.ChoiceLabel;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Slider;
import mcjty.gui.widgets.TabbedPanel;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.ToggleButton;
import mcjty.gui.widgets.Widget;
import mcjty.gui.widgets.WidgetList;
import mcjty.rftools.items.devdelight.DelightingInfoHelper;
import mcjty.rftools.items.devdelight.PacketGetDelightingInfo;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;

public class GuiDevelopersDelight
extends GuiScreen {
    protected int xSize = 410;
    protected int ySize = 210;
    private static int selectedX;
    private static int selectedY;
    private static int selectedZ;
    private static List<String> blockClasses;
    private static List<String> teClasses;
    private static Map<String, DelightingInfoHelper.NBTDescription> nbtData;
    private static int server_metadata;
    private Window window;
    private WidgetList blockClassList;
    private WidgetList teClassList;
    private WidgetList nbtDataList;
    private TabbedPanel tabbedPanel;
    private ChoiceLabel clientServerMode;
    private TextField metaData;
    private List<ToggleButton> pageButtons = new ArrayList<ToggleButton>();
    private boolean listsDirty = true;

    public boolean func_73868_f() {
        return false;
    }

    public static void setSelected(int x, int y, int z) {
        selectedX = x;
        selectedY = y;
        selectedZ = z;
    }

    public static void setServerBlockClasses(List<String> blockClasses) {
        GuiDevelopersDelight.blockClasses = new ArrayList<String>(blockClasses);
    }

    public static void setServerTEClasses(List<String> teClasses) {
        GuiDevelopersDelight.teClasses = new ArrayList<String>(teClasses);
    }

    public static void setServerNBTData(Map<String, DelightingInfoHelper.NBTDescription> nbtData) {
        GuiDevelopersDelight.nbtData = new HashMap<String, DelightingInfoHelper.NBTDescription>(nbtData);
    }

    public static void setMetadata(int metadata) {
        server_metadata = metadata;
    }

    private void requestDelightingInfoFromServer() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetDelightingInfo(selectedX, selectedY, selectedZ));
    }

    private void requestDelightingInfoFromClient() {
        blockClasses = new ArrayList<String>();
        teClasses = new ArrayList<String>();
        nbtData = new HashMap<String, DelightingInfoHelper.NBTDescription>();
        server_metadata = DelightingInfoHelper.fillDelightingData(selectedX, selectedY, selectedZ, (World)this.field_146297_k.field_71441_e, blockClasses, teClasses, nbtData);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int k = (this.field_146294_l - this.xSize) / 2;
        int l = (this.field_146295_m - this.ySize) / 2;
        this.tabbedPanel = new TabbedPanel(this.field_146297_k, (Gui)this);
        Panel tab1 = this.createBlockClassesPage();
        Panel tab2 = this.createTeClassesPage();
        Panel tab3 = this.createNbtDataPage();
        this.tabbedPanel.addPage("Block", (Widget)tab1).addPage("TE", (Widget)tab2).addPage("NBT", (Widget)tab3);
        ToggleButton tab1Button = this.createToggleButton("Block");
        ToggleButton tab2Button = this.createToggleButton("TE");
        ToggleButton tab3Button = this.createToggleButton("NBT");
        this.clientServerMode = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{"Server", "Client"}).setChoice("Server").addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiDevelopersDelight.this.requestNewLists();
            }
        }).setDesiredHeight(16)).setTooltips(new String[]{"Switch between client", "and server information"});
        this.metaData = (TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setDesiredHeight(14)).setTooltips(new String[]{"Metadata for this block"});
        Panel buttonPanel = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new VerticalLayout()).setDesiredWidth(50)).addChild((Widget)tab1Button)).addChild((Widget)tab2Button)).addChild((Widget)tab3Button)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setDynamic(true))).addChild((Widget)this.clientServerMode)).addChild((Widget)this.metaData)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setDynamic(true));
        AbstractContainerWidget toplevel = ((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)new HorizontalLayout()).addChild((Widget)buttonPanel)).addChild((Widget)this.tabbedPanel);
        toplevel.setBounds(new Rectangle(k, l, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        this.requestNewLists();
    }

    private void requestNewLists() {
        this.listsDirty = true;
        teClasses = null;
        blockClasses = null;
        nbtData = null;
        if ("Server".equals(this.clientServerMode.getCurrentChoice())) {
            this.requestDelightingInfoFromServer();
        } else {
            this.requestDelightingInfoFromClient();
        }
    }

    private ToggleButton createToggleButton(final String pagename) {
        ToggleButton toggleButton = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setText(pagename)).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                ToggleButton tb = (ToggleButton)parent;
                if (tb.isPressed()) {
                    GuiDevelopersDelight.this.activatePage(tb, pagename);
                }
            }
        }).setDynamic(true)).setDesiredHeight(18);
        this.pageButtons.add(toggleButton);
        return toggleButton;
    }

    private void activatePage(ToggleButton tb, String pagename) {
        for (ToggleButton toggleButton : this.pageButtons) {
            if (tb == toggleButton) continue;
            toggleButton.setPressed(false);
        }
        this.tabbedPanel.setCurrent(pagename);
    }

    private Panel createBlockClassesPage() {
        this.blockClassList = new WidgetList(this.field_146297_k, (Gui)this);
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(12)).setVertical().setScrollable((Scrollable)this.blockClassList);
        return (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)this.blockClassList)).addChild((Widget)listSlider);
    }

    private Panel createTeClassesPage() {
        this.teClassList = new WidgetList(this.field_146297_k, (Gui)this);
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(12)).setVertical().setScrollable((Scrollable)this.teClassList);
        return (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)this.teClassList)).addChild((Widget)listSlider);
    }

    private Panel createNbtDataPage() {
        this.nbtDataList = new WidgetList(this.field_146297_k, (Gui)this);
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(12)).setVertical().setScrollable((Scrollable)this.nbtDataList);
        return (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)this.nbtDataList)).addChild((Widget)listSlider);
    }

    private void populateLists() {
        if (!this.listsDirty) {
            return;
        }
        if (teClasses == null || blockClasses == null || nbtData == null) {
            return;
        }
        this.listsDirty = false;
        this.blockClassList.removeChildren();
        Block block = Minecraft.func_71410_x().field_71441_e.func_147439_a(selectedX, selectedY, selectedZ);
        this.blockClassList.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Loc Name: " + block.func_149732_F()).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT));
        this.blockClassList.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Unloc Name: " + block.func_149739_a()).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT));
        this.blockClassList.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Icon Name: " + block.func_149702_O()).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT));
        this.blockClassList.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Block Name: " + Block.field_149771_c.func_148750_c((Object)block)).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT));
        for (String string : blockClasses) {
            this.blockClassList.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Class: " + string).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT));
        }
        this.teClassList.removeChildren();
        for (String string : teClasses) {
            this.teClassList.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(string).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT));
        }
        this.nbtDataList.removeChildren();
        for (Map.Entry entry : nbtData.entrySet()) {
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout());
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText((String)entry.getKey()).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDesiredWidth(70));
            DelightingInfoHelper.NBTDescription value = (DelightingInfoHelper.NBTDescription)entry.getValue();
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(value.getType()).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDesiredWidth(50));
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(value.getValue()).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT));
            this.nbtDataList.addChild((Widget)panel);
        }
        this.metaData.setText(String.valueOf(server_metadata));
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.window.mouseClicked(x, y, button);
    }

    public void func_146274_d() {
        super.func_146274_d();
        this.window.handleMouseInput();
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        this.window.mouseMovedOrUp(x, y, button);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        super.func_73869_a(typedChar, keyCode);
        this.window.keyTyped(typedChar, keyCode);
    }

    public void func_73863_a(int xSize_lo, int ySize_lo, float par3) {
        super.func_73863_a(xSize_lo, ySize_lo, par3);
        this.populateLists();
        this.window.draw();
        List tooltips = this.window.getTooltips();
        if (tooltips != null) {
            int guiLeft = (this.field_146294_l - this.xSize) / 2;
            int guiTop = (this.field_146295_m - this.ySize) / 2;
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.drawHoveringText(tooltips, x - guiLeft, y - guiTop, this.field_146297_k.field_71466_p);
        }
    }

    static {
        blockClasses = null;
        teClasses = null;
        nbtData = null;
        server_metadata = 0;
    }
}

