/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mcjty.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;

public class WorldRefresher {
    public static void refreshChunks(World world) {
        try {
            ChunkProviderServer chunkServer = (ChunkProviderServer)world.func_72863_F();
            ArrayList<ChunkCoordIntPair> toUnload = new ArrayList<ChunkCoordIntPair>();
            for (Object obj : chunkServer.field_73245_g) {
                Chunk chunk = (Chunk)obj;
                toUnload.add(chunk.func_76632_l());
            }
            for (ChunkCoordIntPair pair : toUnload) {
                Chunk oldChunk = world.func_72964_e(pair.field_77276_a, pair.field_77275_b);
                WorldServer worldServer = (WorldServer)world;
                ChunkProviderServer chunkProviderServer = worldServer.field_73059_b;
                IChunkProvider chunkProviderGenerate = chunkProviderServer.field_73246_d;
                Chunk newChunk = chunkProviderGenerate.func_73154_d(oldChunk.field_76635_g, oldChunk.field_76647_h);
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < world.func_72800_K(); ++y) {
                            Block blockID = newChunk.func_150810_a(x, y, z);
                            int metadata = newChunk.func_76628_c(x, y, z);
                            worldServer.func_147465_d(x + oldChunk.field_76635_g * 16, y, z + oldChunk.field_76647_h * 16, blockID, metadata, 2);
                            TileEntity tileEntity = newChunk.getTileEntityUnsafe(x, y, z);
                            if (tileEntity == null) continue;
                            worldServer.func_147455_a(x + oldChunk.field_76635_g * 16, y, z + oldChunk.field_76647_h * 16, tileEntity);
                        }
                    }
                }
                oldChunk.field_76646_k = false;
                chunkProviderGenerate.func_73153_a(chunkProviderGenerate, oldChunk.field_76635_g, oldChunk.field_76647_h);
            }
        }
        catch (Exception e) {
            Logging.logError((String)"Failed to regenerate chunks!");
            e.printStackTrace();
        }
    }

    public static void refreshChunksBad(World world) {
        try {
            Field p;
            Field lc;
            Field m;
            Field u;
            ChunkProviderServer chunkServer = (ChunkProviderServer)world.func_72863_F();
            try {
                u = ChunkProviderServer.class.getDeclaredField("field_73248_b");
            }
            catch (NoSuchFieldException e) {
                u = ChunkProviderServer.class.getDeclaredField("chunksToUnload");
            }
            u.setAccessible(true);
            Set unloadQueue = (Set)u.get(chunkServer);
            try {
                m = ChunkProviderServer.class.getDeclaredField("field_73244_f");
            }
            catch (NoSuchFieldException e) {
                m = ChunkProviderServer.class.getDeclaredField("loadedChunkHashMap");
            }
            m.setAccessible(true);
            LongHashMap loadedMap = (LongHashMap)m.get(chunkServer);
            try {
                lc = ChunkProviderServer.class.getDeclaredField("field_73245_g");
            }
            catch (NoSuchFieldException e) {
                lc = ChunkProviderServer.class.getDeclaredField("loadedChunks");
            }
            lc.setAccessible(true);
            List loaded = (List)lc.get(chunkServer);
            try {
                p = ChunkProviderServer.class.getDeclaredField("field_73246_d");
            }
            catch (NoSuchFieldException e) {
                p = ChunkProviderServer.class.getDeclaredField("currentChunkProvider");
            }
            p.setAccessible(true);
            IChunkProvider chunkProvider = (IChunkProvider)p.get(chunkServer);
            ArrayList<ChunkCoordIntPair> toUnload = new ArrayList<ChunkCoordIntPair>();
            for (Object obj : chunkServer.field_73245_g) {
                Chunk chunk = (Chunk)obj;
                toUnload.add(chunk.func_76632_l());
            }
            for (ChunkCoordIntPair pair : toUnload) {
                Chunk chunk;
                int x = pair.field_77276_a;
                int z = pair.field_77275_b;
                long pos = ChunkCoordIntPair.func_77272_a((int)x, (int)z);
                if (chunkServer.func_73149_a(x, z)) {
                    chunk = chunkServer.func_73158_c(x, z);
                    chunk.func_76623_d();
                }
                unloadQueue.remove(pos);
                loadedMap.func_76159_d(pos);
                chunk = chunkProvider.func_73154_d(x, z);
                loadedMap.func_76163_a(pos, (Object)chunk);
                loaded.add(chunk);
                if (chunk == null) continue;
                chunk.func_76631_c();
                chunk.func_76624_a(chunkProvider, chunkProvider, x, z);
            }
        }
        catch (Exception e) {
            Logging.logError((String)"Failed to regenerate chunks!");
            e.printStackTrace();
        }
    }
}

