/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ivorius.reccomplex.dimensions.DimensionDictionary;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import mcjty.rftools.api.dimension.RFToolsWorldProvider;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.DimensionStorage;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.description.WeatherDescriptor;
import mcjty.rftools.dimension.network.PacketGetDimensionEnergy;
import mcjty.rftools.dimension.world.GenericChunkProvider;
import mcjty.rftools.dimension.world.GenericWorldChunkManager;
import mcjty.rftools.dimension.world.SingleBiomeWorldChunkManager;
import mcjty.rftools.dimension.world.SkyRenderer;
import mcjty.rftools.dimension.world.types.ControllerType;
import mcjty.rftools.dimension.world.types.SkyType;
import mcjty.rftools.dimension.world.types.StructureType;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.varia.Logging;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.DimensionManager;

@Optional.InterfaceList(value={@Optional.Interface(iface="ivorius.reccomplex.dimensions.DimensionDictionary$Handler", modid="reccomplex")})
public class GenericWorldProvider
extends WorldProvider
implements DimensionDictionary.Handler,
RFToolsWorldProvider {
    public static final String RFTOOLS_DIMENSION = "rftools dimension";
    private DimensionInformation dimensionInformation;
    private DimensionStorage storage;
    private long seed;
    private Set<String> dimensionTypes = null;
    private static long lastFogTime = 0L;
    private static long lastTime = 0L;

    private long calculateSeed(long seed, int dim) {
        return (long)dim * 13L + seed;
    }

    public long getSeed() {
        if (this.dimensionInformation == null || this.dimensionInformation.getWorldVersion() < 1) {
            return super.getSeed();
        }
        return this.seed;
    }

    private DimensionInformation getDimensionInformation() {
        if (this.dimensionInformation == null) {
            int dim = this.field_76579_a.field_73011_w.field_76574_g;
            this.dimensionInformation = RfToolsDimensionManager.getDimensionManager(this.field_76579_a).getDimensionInformation(dim);
            if (this.dimensionInformation == null) {
                Logging.log((String)("Dimension information for dimension " + dim + " is missing!"));
            } else {
                this.setSeed(dim);
                this.setupProviderInfo();
            }
        }
        return this.dimensionInformation;
    }

    @Optional.Method(modid="reccomplex")
    public Set<String> getDimensionTypes() {
        this.getDimensionInformation();
        if (this.dimensionInformation == null) {
            return Collections.EMPTY_SET;
        }
        if (this.dimensionTypes == null) {
            this.dimensionTypes = new HashSet<String>();
            this.dimensionTypes.add("INFINITE");
            this.dimensionTypes.add("RFTOOLS_DIMENSION");
            switch (this.dimensionInformation.getTerrainType()) {
                case TERRAIN_VOID: 
                case TERRAIN_ISLAND: 
                case TERRAIN_ISLANDS: 
                case TERRAIN_CHAOTIC: 
                case TERRAIN_PLATEAUS: 
                case TERRAIN_GRID: {
                    this.dimensionTypes.add("NO_TOP_LIMIT");
                    this.dimensionTypes.add("NO_BOTTOM_LIMIT");
                    break;
                }
                case TERRAIN_FLAT: 
                case TERRAIN_AMPLIFIED: 
                case TERRAIN_NORMAL: 
                case TERRAIN_NEARLANDS: {
                    this.dimensionTypes.add("NO_TOP_LIMIT");
                    this.dimensionTypes.add("BOTTOM_LIMIT");
                    break;
                }
                case TERRAIN_CAVERN_OLD: {
                    this.dimensionTypes.add("BOTTOM_LIMIT");
                    this.dimensionTypes.add("TOP_LIMIT");
                    break;
                }
                case TERRAIN_CAVERN: 
                case TERRAIN_LOW_CAVERN: 
                case TERRAIN_FLOODED_CAVERN: {
                    this.dimensionTypes.add("BOTTOM_LIMIT");
                    this.dimensionTypes.add("NO_TOP_LIMIT");
                }
            }
            if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_RECURRENTCOMPLEX)) {
                Collections.addAll(this.dimensionTypes, this.dimensionInformation.getDimensionTypes());
            }
        }
        return this.dimensionTypes;
    }

    private void setSeed(int dim) {
        long forcedSeed;
        if (this.dimensionInformation == null) {
            if (this.field_76579_a == null) {
                return;
            }
            this.dimensionInformation = RfToolsDimensionManager.getDimensionManager(this.field_76579_a).getDimensionInformation(dim);
            if (this.dimensionInformation == null) {
                Logging.log((String)"Error: setSeed() called with null diminfo. Error ignored!");
                return;
            }
        }
        if ((forcedSeed = this.dimensionInformation.getForcedDimensionSeed()) != 0L) {
            Logging.log((String)("Forced seed for dimension " + dim + ": " + forcedSeed));
            this.seed = forcedSeed;
        } else {
            long baseSeed = this.dimensionInformation.getBaseSeed();
            this.seed = baseSeed != 0L ? this.calculateSeed(baseSeed, dim) : this.calculateSeed(this.field_76579_a.func_72905_C(), dim);
        }
    }

    public void func_76572_b() {
        this.getDimensionInformation();
        this.storage = DimensionStorage.getDimensionStorage(this.field_76579_a);
        this.setupProviderInfo();
    }

    private void setupProviderInfo() {
        if (this.dimensionInformation != null) {
            ControllerType type = this.dimensionInformation.getControllerType();
            if (type == ControllerType.CONTROLLER_SINGLE) {
                this.field_76578_c = new SingleBiomeWorldChunkManager(this.field_76579_a, this.field_76579_a.func_72905_C(), this.field_76577_b);
            } else if (type == ControllerType.CONTROLLER_DEFAULT) {
                this.field_76578_c = new WorldChunkManager(this.seed, this.field_76579_a.func_72912_H().func_76067_t());
            } else {
                GenericWorldChunkManager.hackyDimensionInformation = this.dimensionInformation;
                this.field_76578_c = new GenericWorldChunkManager(this.seed, this.field_76579_a.func_72912_H().func_76067_t(), this.dimensionInformation);
            }
        } else {
            this.field_76578_c = new WorldChunkManager(this.seed, this.field_76579_a.func_72912_H().func_76067_t());
        }
        if (this.dimensionInformation != null) {
            boolean bl = this.field_76576_e = !this.dimensionInformation.getTerrainType().hasSky();
            if (this.field_76579_a.field_72995_K) {
                SkyType skyType = this.dimensionInformation.getSkyDescriptor().getSkyType();
                if (this.field_76576_e) {
                    SkyRenderer.registerNoSky(this);
                } else if (skyType == SkyType.SKY_ENDER) {
                    SkyRenderer.registerEnderSky(this);
                } else if (skyType == SkyType.SKY_INFERNO || skyType == SkyType.SKY_STARS1 || skyType == SkyType.SKY_STARS2 || skyType == SkyType.SKY_STARS3) {
                    SkyRenderer.registerSkybox(this, skyType);
                } else {
                    SkyRenderer.registerSky(this, this.dimensionInformation);
                }
            }
        }
    }

    public static WorldProvider getProviderForDimension(int id) {
        return DimensionManager.createProviderFor((int)id);
    }

    public double getHorizon() {
        this.getDimensionInformation();
        if (this.dimensionInformation != null && this.dimensionInformation.getTerrainType().hasNoHorizon()) {
            return 0.0;
        }
        return super.getHorizon();
    }

    public boolean func_76569_d() {
        this.getDimensionInformation();
        if (this.dimensionInformation == null) {
            return super.func_76569_d();
        }
        return this.dimensionInformation.getTerrainType().hasSky();
    }

    public String func_80007_l() {
        return RFTOOLS_DIMENSION;
    }

    public String getWelcomeMessage() {
        return "Entering the rftools dimension!";
    }

    public boolean func_76567_e() {
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        this.getDimensionInformation();
        if (DimletConfiguration.respawnSameDim || this.dimensionInformation != null && this.dimensionInformation.isRespawnHere()) {
            DimensionStorage dimensionStorage = DimensionStorage.getDimensionStorage(this.field_76579_a);
            int power = dimensionStorage.getEnergyLevel(this.field_76574_g);
            if (power < 1000) {
                return DimletConfiguration.spawnDimension;
            }
            return this.field_76574_g;
        }
        return DimletConfiguration.spawnDimension;
    }

    public IChunkProvider func_76555_c() {
        int dim = this.field_76579_a.field_73011_w.field_76574_g;
        this.setSeed(dim);
        return new GenericChunkProvider(this.field_76579_a, this.seed);
    }

    public BiomeGenBase getBiomeGenForCoords(int x, int z) {
        return super.getBiomeGenForCoords(x, z);
    }

    public int getActualHeight() {
        return 256;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float angle, float dt) {
        float r;
        float g;
        float b;
        int dim = this.field_76579_a.field_73011_w.field_76574_g;
        if (System.currentTimeMillis() - lastFogTime > 1000L) {
            lastFogTime = System.currentTimeMillis();
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetDimensionEnergy(dim));
        }
        float factor = this.calculatePowerBlackout(dim);
        this.getDimensionInformation();
        if (this.dimensionInformation == null) {
            b = 1.0f;
            g = 1.0f;
            r = 1.0f;
        } else {
            r = this.dimensionInformation.getSkyDescriptor().getFogColorFactorR() * factor;
            g = this.dimensionInformation.getSkyDescriptor().getFogColorFactorG() * factor;
            b = this.dimensionInformation.getSkyDescriptor().getFogColorFactorB() * factor;
        }
        Vec3 color = super.func_76562_b(angle, dt);
        return Vec3.func_72443_a((double)(color.field_72450_a * (double)r), (double)(color.field_72448_b * (double)g), (double)(color.field_72449_c * (double)b));
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 getSkyColor(Entity cameraEntity, float partialTicks) {
        float r;
        float g;
        float b;
        int dim = this.field_76579_a.field_73011_w.field_76574_g;
        if (System.currentTimeMillis() - lastTime > 1000L) {
            lastTime = System.currentTimeMillis();
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetDimensionEnergy(dim));
        }
        float factor = this.calculatePowerBlackout(dim);
        this.getDimensionInformation();
        if (this.dimensionInformation == null) {
            b = 1.0f;
            g = 1.0f;
            r = 1.0f;
        } else {
            r = this.dimensionInformation.getSkyDescriptor().getSkyColorFactorR() * factor;
            g = this.dimensionInformation.getSkyDescriptor().getSkyColorFactorG() * factor;
            b = this.dimensionInformation.getSkyDescriptor().getSkyColorFactorB() * factor;
        }
        Vec3 skyColor = super.getSkyColor(cameraEntity, partialTicks);
        return Vec3.func_72443_a((double)(skyColor.field_72450_a * (double)r), (double)(skyColor.field_72448_b * (double)g), (double)(skyColor.field_72449_c * (double)b));
    }

    private float calculatePowerBlackout(int dim) {
        float factor = 1.0f;
        int power = this.storage.getEnergyLevel(dim);
        if (power < DimletConfiguration.DIMPOWER_WARN3) {
            factor = (float)power / (float)DimletConfiguration.DIMPOWER_WARN3 * 0.2f;
        } else if (power < DimletConfiguration.DIMPOWER_WARN2) {
            factor = (float)(power - DimletConfiguration.DIMPOWER_WARN3) / (float)(DimletConfiguration.DIMPOWER_WARN2 - DimletConfiguration.DIMPOWER_WARN3) * 0.3f + 0.2f;
        } else if (power < DimletConfiguration.DIMPOWER_WARN1) {
            factor = (float)(power - DimletConfiguration.DIMPOWER_WARN2) / (float)(DimletConfiguration.DIMPOWER_WARN1 - DimletConfiguration.DIMPOWER_WARN2) * 0.3f + 0.5f;
        } else if (power < DimletConfiguration.DIMPOWER_WARN0) {
            factor = (float)(power - DimletConfiguration.DIMPOWER_WARN1) / (float)(DimletConfiguration.DIMPOWER_WARN0 - DimletConfiguration.DIMPOWER_WARN1) * 0.2f + 0.8f;
        }
        return factor;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        this.getDimensionInformation();
        if (this.dimensionInformation == null) {
            return super.getSunBrightness(par1);
        }
        int dim = this.field_76579_a.field_73011_w.field_76574_g;
        float factor = this.calculatePowerBlackout(dim);
        return super.getSunBrightness(par1) * this.dimensionInformation.getSkyDescriptor().getSunBrightnessFactor() * factor;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        this.getDimensionInformation();
        if (this.dimensionInformation == null) {
            return super.getStarBrightness(par1);
        }
        return super.getStarBrightness(par1) * this.dimensionInformation.getSkyDescriptor().getStarBrightnessFactor();
    }

    public void updateWeather() {
        super.updateWeather();
        if (!this.field_76579_a.field_72995_K) {
            this.getDimensionInformation();
            if (this.dimensionInformation != null) {
                float ts;
                WeatherDescriptor descriptor = this.dimensionInformation.getWeatherDescriptor();
                float rs = descriptor.getRainStrength();
                if (rs > -0.5f) {
                    this.field_76579_a.field_73004_o = rs;
                    if ((double)Math.abs(this.field_76579_a.field_73004_o) < 0.001) {
                        this.field_76579_a.field_73003_n = 0.0f;
                        this.field_76579_a.field_73004_o = 0.0f;
                        this.field_76579_a.func_72912_H().func_76084_b(false);
                    }
                }
                if ((ts = descriptor.getThunderStrength()) > -0.5f) {
                    this.field_76579_a.field_73017_q = ts;
                    if ((double)Math.abs(this.field_76579_a.field_73017_q) < 0.001) {
                        this.field_76579_a.field_73018_p = 0.0f;
                        this.field_76579_a.field_73017_q = 0.0f;
                        this.field_76579_a.func_72912_H().func_76069_a(false);
                    }
                }
            }
        }
    }

    public float func_76563_a(long time, float dt) {
        this.getDimensionInformation();
        if (this.dimensionInformation == null) {
            return super.func_76563_a(time, dt);
        }
        if (!this.dimensionInformation.getTerrainType().hasSky()) {
            return 0.5f;
        }
        if (this.dimensionInformation.getCelestialAngle() == null) {
            if (this.dimensionInformation.getTimeSpeed() == null) {
                return super.func_76563_a(time, dt);
            }
            return super.func_76563_a((long)((float)time * this.dimensionInformation.getTimeSpeed().floatValue()), dt);
        }
        return this.dimensionInformation.getCelestialAngle().floatValue();
    }

    @Override
    public int getCurrentRF() {
        DimensionStorage dimensionStorage = DimensionStorage.getDimensionStorage(this.field_76579_a);
        return dimensionStorage.getEnergyLevel(this.field_76574_g);
    }
}

