/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.description.DimensionDescriptor;
import mcjty.rftools.dimension.network.PacketCheckDimletConfig;
import mcjty.rftools.dimension.network.PacketSyncDimensionInfo;
import mcjty.rftools.dimension.world.GenericWorldProvider;
import mcjty.rftools.items.dimensionmonitor.PhasedFieldGeneratorItem;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletMapping;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.rftools.network.PacketRegisterDimensions;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.varia.Coordinate;
import mcjty.varia.Logging;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public class RfToolsDimensionManager
extends WorldSavedData {
    public static final String DIMMANAGER_NAME = "RFToolsDimensionManager";
    private static RfToolsDimensionManager instance = null;
    private final Map<Integer, DimensionDescriptor> dimensions = new HashMap<Integer, DimensionDescriptor>();
    private final Map<DimensionDescriptor, Integer> dimensionToID = new HashMap<DimensionDescriptor, Integer>();
    private final Map<Integer, DimensionInformation> dimensionInformation = new HashMap<Integer, DimensionInformation>();
    private final Set<Integer> reclaimedIds = new HashSet<Integer>();

    public void syncFromServer(Map<Integer, DimensionDescriptor> dims, Map<Integer, DimensionInformation> dimInfo) {
        int id;
        Logging.log((String)"RfToolsDimensionManager.syncFromServer");
        if (dims.isEmpty() || dimInfo.isEmpty()) {
            Logging.log((String)"Dimension information from server is empty.");
        }
        for (Map.Entry<Integer, DimensionDescriptor> entry : dims.entrySet()) {
            id = entry.getKey();
            DimensionDescriptor descriptor = entry.getValue();
            if (this.dimensions.containsKey(id)) {
                this.dimensionToID.remove(this.dimensions.get(id));
            }
            this.dimensions.put(id, descriptor);
            this.dimensionToID.put(descriptor, id);
        }
        for (Map.Entry<Integer, Object> entry : dimInfo.entrySet()) {
            id = entry.getKey();
            DimensionInformation info = (DimensionInformation)entry.getValue();
            this.dimensionInformation.put(id, info);
        }
    }

    public RfToolsDimensionManager(String identifier) {
        super(identifier);
    }

    public static void clearInstance() {
        if (instance != null) {
            RfToolsDimensionManager.instance.dimensions.clear();
            RfToolsDimensionManager.instance.dimensionToID.clear();
            RfToolsDimensionManager.instance.dimensionInformation.clear();
            RfToolsDimensionManager.instance.reclaimedIds.clear();
            instance = null;
        }
    }

    public static void cleanupDimensionInformation() {
        if (instance != null) {
            Logging.log((String)"Cleaning up RFTools dimensions");
            RfToolsDimensionManager.unregisterDimensions();
            instance.getDimensions().clear();
            RfToolsDimensionManager.instance.dimensionToID.clear();
            RfToolsDimensionManager.instance.dimensionInformation.clear();
            RfToolsDimensionManager.instance.reclaimedIds.clear();
            instance = null;
        }
    }

    public static void unregisterDimensions() {
        for (Map.Entry<Integer, DimensionDescriptor> me : instance.getDimensions().entrySet()) {
            int id = me.getKey();
            if (DimensionManager.isDimensionRegistered((int)id)) {
                Logging.log((String)("    Unregister dimension: " + id));
                try {
                    DimensionManager.unregisterDimension((int)id);
                }
                catch (Exception e) {
                    Logging.log((String)("        Could not unregister dimension: " + id));
                }
                try {
                    DimensionManager.unregisterProviderType((int)id);
                }
                catch (Exception e) {
                    Logging.log((String)("        Could not unregister provider: " + id));
                }
                continue;
            }
            Logging.log((String)("    Already unregistered! Dimension: " + id));
        }
    }

    public void save(World world) {
        world.field_72988_C.func_75745_a(DIMMANAGER_NAME, (WorldSavedData)this);
        this.func_76185_a();
        this.syncDimInfoToClients(world);
    }

    public void reclaimId(int id) {
        this.reclaimedIds.add(id);
    }

    public static void freezeDimension(World world) {
        ArrayList<Coordinate> pfgList = new ArrayList<Coordinate>();
        int radius = DimletConfiguration.phasedFieldGeneratorRange;
        if (radius > 0) {
            for (Object ent : world.field_73010_i) {
                EntityPlayer player = (EntityPlayer)ent;
                if (!RfToolsDimensionManager.checkValidPhasedFieldGenerator(player, false)) continue;
                pfgList.add(new Coordinate((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v));
            }
        }
        ArrayList tokeep = new ArrayList();
        tokeep.addAll(world.field_73010_i);
        for (Coordinate coordinate : pfgList) {
            RfToolsDimensionManager.getEntitiesInSphere(world, coordinate, (float)radius, tokeep);
        }
        world.field_72996_f.clear();
        world.field_72996_f.addAll(tokeep);
        world.field_147482_g.clear();
    }

    private static void getEntitiesInSphere(World world, Coordinate c, float radius, List tokeep) {
        int i = MathHelper.func_76128_c((double)((double)((float)c.getX() - radius) / 16.0));
        int j = MathHelper.func_76128_c((double)((double)((float)(c.getX() + 1) + radius) / 16.0));
        int k = MathHelper.func_76128_c((double)((double)((float)c.getZ() - radius) / 16.0));
        int l = MathHelper.func_76128_c((double)((double)((float)(c.getZ() + 1) + radius) / 16.0));
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (!world.func_72863_F().func_73149_a(i1, j1)) continue;
                Chunk chunk = world.func_72964_e(i1, j1);
                RfToolsDimensionManager.getEntitiesInSphere(chunk, c, radius, tokeep);
            }
        }
    }

    private static void getEntitiesInSphere(Chunk chunk, Coordinate c, float radius, List entities) {
        float squaredRange = radius * radius;
        int i = MathHelper.func_76128_c((double)((double)((float)c.getY() - radius) / 16.0));
        int j = MathHelper.func_76128_c((double)((double)((float)(c.getY() + 1) + radius) / 16.0));
        i = MathHelper.func_76125_a((int)i, (int)0, (int)(chunk.field_76645_j.length - 1));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)(chunk.field_76645_j.length - 1));
        block0: for (int k = i; k <= j; ++k) {
            List entityList = chunk.field_76645_j[k];
            for (Object o : entityList) {
                if (o instanceof EntityPlayer) continue;
                Entity entity = (Entity)o;
                float sqdist = c.squaredDistance((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v);
                if (!(sqdist < squaredRange)) continue;
                entities.add(entity);
                continue block0;
            }
        }
    }

    public static void unfreezeDimension(World world) {
        WorldServer worldServer = (WorldServer)world;
        for (Object chunk : worldServer.field_73059_b.field_73245_g) {
            Chunk c = (Chunk)chunk;
            RfToolsDimensionManager.unfreezeChunk(c);
        }
    }

    public static void unfreezeChunk(Chunk chunk) {
        chunk.field_76636_d = true;
        chunk.field_76637_e.func_147448_a(chunk.field_150816_i.values());
        for (List entityList : chunk.field_76645_j) {
            chunk.field_76637_e.field_72996_f.addAll(entityList);
        }
    }

    public static boolean checkValidPhasedFieldGenerator(EntityPlayer player, boolean consume) {
        InventoryPlayer inventory = player.field_71071_by;
        for (int i = 0; i < inventory.func_70451_h(); ++i) {
            int toConsume;
            PhasedFieldGeneratorItem pfg;
            int energyStored;
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null || slot.func_77973_b() != DimletSetup.phasedFieldGeneratorItem || (energyStored = (pfg = (PhasedFieldGeneratorItem)slot.func_77973_b()).getEnergyStored(slot)) < (toConsume = 10 * DimletConfiguration.PHASEDFIELD_CONSUMEPERTICK)) continue;
            if (consume) {
                pfg.extractEnergy(slot, toConsume, false);
            }
            return true;
        }
        return false;
    }

    public void checkDimletConfig(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            Logging.log((String)"Send validation data to the client");
            DimletMapping mapping = DimletMapping.getDimletMapping(player.func_130014_f_());
            HashMap<Integer, DimletKey> dimlets = new HashMap<Integer, DimletKey>();
            for (Integer id : mapping.getIds()) {
                dimlets.put(id, mapping.getKey(id));
            }
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketCheckDimletConfig(dimlets), (EntityPlayerMP)player);
        }
    }

    public void checkDimletConfigFromServer(Map<Integer, DimletKey> dimlets, World world) {
        Logging.log((String)"Getting dimlet mapping from server");
        DimletMapping mapping = DimletMapping.getDimletMapping(world);
        mapping.overrideServerMapping(dimlets);
        KnownDimletConfiguration.init(world, false);
        KnownDimletConfiguration.initCrafting(world);
    }

    public void syncDimInfoToClients(World world) {
        if (!world.field_72995_K) {
            Logging.log((String)"Sync dimension info to clients!");
            RFToolsMessages.INSTANCE.sendToAll((IMessage)new PacketSyncDimensionInfo(this.dimensions, this.dimensionInformation));
        }
    }

    public Map<Integer, DimensionDescriptor> getDimensions() {
        return this.dimensions;
    }

    public void registerDimensions() {
        Logging.log((String)"Registering RFTools dimensions");
        for (Map.Entry<Integer, DimensionDescriptor> me : this.dimensions.entrySet()) {
            int id = me.getKey();
            Logging.log((String)("    Dimension: " + id));
            this.registerDimensionToServerAndClient(id);
        }
    }

    private void registerDimensionToServerAndClient(int id) {
        if (!DimensionManager.isDimensionRegistered((int)id)) {
            DimensionManager.registerProviderType((int)id, GenericWorldProvider.class, (boolean)false);
            DimensionManager.registerDimension((int)id, (int)id);
        }
        RFToolsMessages.INSTANCE.sendToAll((IMessage)new PacketRegisterDimensions(id));
    }

    public static RfToolsDimensionManager getDimensionManager(World world) {
        if (instance != null) {
            return instance;
        }
        instance = (RfToolsDimensionManager)world.field_72988_C.func_75742_a(RfToolsDimensionManager.class, DIMMANAGER_NAME);
        if (instance == null) {
            instance = new RfToolsDimensionManager(DIMMANAGER_NAME);
        }
        return instance;
    }

    public DimensionDescriptor getDimensionDescriptor(int id) {
        return this.dimensions.get(id);
    }

    public Integer getDimensionID(DimensionDescriptor descriptor) {
        return this.dimensionToID.get(descriptor);
    }

    public DimensionInformation getDimensionInformation(int id) {
        return this.dimensionInformation.get(id);
    }

    public static World getWorldForDimension(int id) {
        WorldServer w = DimensionManager.getWorld((int)id);
        if (w == null) {
            w = MinecraftServer.func_71276_C().func_71203_ab().func_72365_p().func_71218_a(id);
        }
        return w;
    }

    public void removeDimension(int id) {
        DimensionDescriptor descriptor = this.dimensions.get(id);
        this.dimensions.remove(id);
        this.dimensionToID.remove(descriptor);
        this.dimensionInformation.remove(id);
        if (DimensionManager.isDimensionRegistered((int)id)) {
            DimensionManager.unregisterDimension((int)id);
        }
        DimensionManager.unregisterProviderType((int)id);
    }

    public void recoverDimension(World world, int id, DimensionDescriptor descriptor, String name) {
        if (!DimensionManager.isDimensionRegistered((int)id)) {
            this.registerDimensionToServerAndClient(id);
        }
        DimensionInformation dimensionInfo = new DimensionInformation(name, descriptor, world);
        this.dimensions.put(id, descriptor);
        this.dimensionToID.put(descriptor, id);
        this.dimensionInformation.put(id, dimensionInfo);
        this.save(world);
        this.touchSpawnChunk(id);
    }

    public int createNewDimension(World world, DimensionDescriptor descriptor, String name) {
        int id = 0;
        while (!this.reclaimedIds.isEmpty()) {
            int rid = this.reclaimedIds.iterator().next();
            this.reclaimedIds.remove(rid);
            if (DimensionManager.isDimensionRegistered((int)rid)) continue;
            id = rid;
            break;
        }
        if (id == 0) {
            id = DimensionManager.getNextFreeDimId();
        }
        this.registerDimensionToServerAndClient(id);
        Logging.log((String)("id = " + id + " for " + name + ", descriptor = " + descriptor.getDescriptionString()));
        this.dimensions.put(id, descriptor);
        this.dimensionToID.put(descriptor, id);
        DimensionInformation dimensionInfo = new DimensionInformation(name, descriptor, world);
        this.dimensionInformation.put(id, dimensionInfo);
        this.save(world);
        this.touchSpawnChunk(id);
        return id;
    }

    private void touchSpawnChunk(int id) {
        WorldServer worldServerForDimension = MinecraftServer.func_71276_C().func_71218_a(id);
        ChunkProviderServer providerServer = worldServerForDimension.field_73059_b;
        if (!providerServer.func_73149_a(0, 0)) {
            try {
                providerServer.func_73158_c(0, 0);
                providerServer.func_73153_a((IChunkProvider)providerServer, 0, 0);
                providerServer.func_73241_b(0, 0);
            }
            catch (Exception e) {
                Logging.logError((String)"Something went wrong during creation of the dimension!");
                e.printStackTrace();
            }
        }
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        int[] lstIds;
        this.dimensions.clear();
        this.dimensionToID.clear();
        this.dimensionInformation.clear();
        this.reclaimedIds.clear();
        NBTTagList lst = tagCompound.func_150295_c("dimensions", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            int id = tc.func_74762_e("id");
            DimensionDescriptor descriptor = new DimensionDescriptor(tc);
            this.dimensions.put(id, descriptor);
            this.dimensionToID.put(descriptor, id);
            DimensionInformation dimensionInfo = new DimensionInformation(descriptor, tc);
            this.dimensionInformation.put(id, dimensionInfo);
        }
        for (int id : lstIds = tagCompound.func_74759_k("reclaimedIds")) {
            this.reclaimedIds.add(id);
        }
    }

    public void func_76187_b(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, DimensionDescriptor> me : this.dimensions.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            Integer id = me.getKey();
            tc.func_74768_a("id", id.intValue());
            me.getValue().writeToNBT(tc);
            DimensionInformation dimensionInfo = this.dimensionInformation.get(id);
            dimensionInfo.writeToNBT(tc);
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("dimensions", (NBTBase)lst);
        ArrayList<Integer> ids = new ArrayList<Integer>(this.reclaimedIds);
        int[] lstIds = new int[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            lstIds[i] = (Integer)ids.get(i);
        }
        tagCompound.func_74783_a("reclaimedIds", lstIds);
    }
}

