/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.api.Infusable;
import mcjty.container.EmptyContainer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.teleporter.GuiMatterReceiver;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.varia.Coordinate;
import mcjty.varia.GlobalCoordinate;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class MatterReceiverBlock
extends GenericRFToolsBlock
implements Infusable {
    private IIcon iconTop;

    public MatterReceiverBlock() {
        super(Material.field_151573_f, MatterReceiverTileEntity.class, true);
        this.func_149663_c("matterReceiverBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            String name = tagCompound.func_74779_i("tpName");
            int id = tagCompound.func_74762_e("destinationId");
            list.add(EnumChatFormatting.GREEN + "Name: " + name + (id == -1 ? "" : ", Id: " + id));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "If you place this block anywhere in the world then");
            list.add(EnumChatFormatting.WHITE + "you can dial to it using a Dialing Device. Before");
            list.add(EnumChatFormatting.WHITE + "teleporting to this block make sure to give it power!");
            list.add(EnumChatFormatting.YELLOW + "Infusing bonus: reduced power consumption.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof MatterReceiverTileEntity) {
            MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
            String name = matterReceiverTileEntity.getName();
            int id = matterReceiverTileEntity.getId();
            currenttip.add(EnumChatFormatting.GREEN + "Name: " + name + (id == -1 ? "" : ", Id: " + id));
        }
        return currenttip;
    }

    public int getGuiID() {
        return RFTools.GUI_MATTER_RECEIVER;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)tileEntity;
        EmptyContainer matterReceiverContainer = new EmptyContainer(entityPlayer);
        return new GuiMatterReceiver(matterReceiverTileEntity, matterReceiverContainer);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float sx, float sy, float sz, int meta) {
        int rc = super.func_149660_a(world, x, y, z, side, sx, sy, sz, meta);
        if (world.field_72995_K) {
            return rc;
        }
        TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
        GlobalCoordinate gc = new GlobalCoordinate(new Coordinate(x, y, z), world.field_73011_w.field_76574_g);
        destinations.getNewId(gc);
        destinations.addDestination(gc);
        destinations.save(world);
        return rc;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        this.restoreBlockFromNBT(world, x, y, z, itemStack);
        if (!world.field_72995_K) {
            MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)world.func_147438_o(x, y, z);
            matterReceiverTileEntity.getOrCalculateID();
            matterReceiverTileEntity.updateDestination();
        }
        this.setOwner(world, x, y, z, entityLivingBase);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        if (world.field_72995_K) {
            return;
        }
        TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
        destinations.removeDestination(new Coordinate(x, y, z), world.field_73011_w.field_76574_g);
        destinations.save(world);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.iconTop = iconRegister.func_94245_a("rftools:machineReceiver");
        this.iconSide = iconRegister.func_94245_a("rftools:machineSide");
        this.iconBottom = iconRegister.func_94245_a("rftools:machineBottom");
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (side == ForgeDirection.UP.ordinal()) {
            return this.iconTop;
        }
        if (side == ForgeDirection.DOWN.ordinal()) {
            return this.iconBottom;
        }
        return this.iconSide;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == ForgeDirection.UP.ordinal()) {
            return this.iconTop;
        }
        if (side == ForgeDirection.DOWN.ordinal()) {
            return this.iconBottom;
        }
        return this.iconSide;
    }
}

