/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.Map;
import mcjty.container.InventoryHelper;
import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.network.Argument;
import mcjty.rftools.blocks.storage.ModularStorageConfiguration;
import mcjty.rftools.blocks.storage.RemoteStorageContainer;
import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.items.storage.StorageModuleItem;
import mcjty.varia.Coordinate;
import mcjty.varia.GlobalCoordinate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RemoteStorageTileEntity
extends GenericEnergyReceiverTileEntity
implements ISidedInventory {
    public static final String CMD_SETGLOBAL = "setGlobal";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, RemoteStorageContainer.factory, 8);
    private ItemStack[][] slots = new ItemStack[][]{new ItemStack[0], new ItemStack[0], new ItemStack[0], new ItemStack[0]};
    private int[] maxsize = new int[]{0, 0, 0, 0};
    private int[] numStacks = new int[]{0, 0, 0, 0};
    private boolean[] global = new boolean[]{false, false, false, false};
    private int timer = 0;

    public RemoteStorageTileEntity() {
        super(ModularStorageConfiguration.REMOTE_MAXENERGY, ModularStorageConfiguration.REMOTE_RECEIVEPERTICK);
    }

    public boolean isPowerLow() {
        return this.getEnergyStored(ForgeDirection.DOWN) < ModularStorageConfiguration.remoteShareLocal;
    }

    protected void checkStateServer() {
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = 5;
        int hasPower = this.isPowerLow() ? 0 : 8;
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int newmeta = meta & 7 | hasPower;
        if (newmeta != meta) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, newmeta, 2);
        }
        RemoteStorageIdRegistry registry = RemoteStorageIdRegistry.getRegistry(this.field_145850_b);
        for (int i = 0; i < 4; ++i) {
            ItemStack stack;
            NBTTagCompound tagCompound;
            if (!this.inventoryHelper.containsItem(i) || (tagCompound = (stack = this.inventoryHelper.getStackInSlot(i)).func_77978_p()) == null || !tagCompound.func_74764_b("id")) continue;
            int rf = this.isGlobal(i) ? ModularStorageConfiguration.remoteShareGlobal : ModularStorageConfiguration.remoteShareLocal;
            rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f);
            if (this.getEnergyStored(ForgeDirection.DOWN) < rf) {
                return;
            }
            this.consumeEnergy(rf);
            this.func_70296_d();
            int id = tagCompound.func_74762_e("id");
            registry.publishStorage(id, new GlobalCoordinate(new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.field_145850_b.field_73011_w.field_76574_g));
        }
    }

    public int[] func_94128_d(int side) {
        return RemoteStorageContainer.factory.getAccessibleSlots();
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return RemoteStorageContainer.factory.isInputSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return RemoteStorageContainer.factory.isOutputSlot(index);
    }

    public boolean hasStorage(int index) {
        return this.inventoryHelper.containsItem(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void compact(int id) {
        int si = this.findRemoteIndex(id);
        if (si == -1) {
            return;
        }
        ItemStack[] s = this.findStacksForId(id);
        InventoryHelper.compactStacks((ItemStack[])s, (int)0, (int)this.maxsize[si]);
        this.updateStackCount(si);
        this.func_70296_d();
    }

    public int cycle(int id) {
        int si = this.findRemoteIndex(id);
        if (si == -1) {
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack == null || stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("id")) continue;
                return stack.func_77978_p().func_74762_e("id");
            }
            return -1;
        }
        for (int i = si + 1; i < si + 4; ++i) {
            int ii = i % 4;
            ItemStack stack = this.func_70301_a(ii);
            if (stack == null || stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("id")) continue;
            return stack.func_77978_p().func_74762_e("id");
        }
        return id;
    }

    private void link(int index) {
        int id;
        if (index >= 4) {
            index -= 4;
        }
        if (!this.inventoryHelper.containsItem(index)) {
            return;
        }
        if (!this.inventoryHelper.containsItem(index + 4)) {
            return;
        }
        ItemStack source = this.inventoryHelper.getStackInSlot(index);
        ItemStack dest = this.inventoryHelper.getStackInSlot(index + 4);
        if (dest.func_77960_j() != 6) {
            return;
        }
        NBTTagCompound tagCompound = source.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            source.func_77982_d(tagCompound);
        }
        if (tagCompound.func_74764_b("id")) {
            id = tagCompound.func_74762_e("id");
        } else {
            RemoteStorageIdRegistry registry = RemoteStorageIdRegistry.getRegistry(this.field_145850_b);
            id = registry.getNewId();
            registry.save(this.field_145850_b);
            tagCompound.func_74768_a("id", id);
        }
        tagCompound = dest.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            dest.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a("id", id);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (index < 4) {
            this.copyFromModule(stack, index);
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.field_145850_b.field_72995_K) {
            this.link(index);
        }
    }

    public String func_145825_b() {
        return "Remote Storage Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int findRemoteIndex(int id) {
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound tagCompound;
            ItemStack stack;
            if (!this.inventoryHelper.containsItem(i) || (stack = this.inventoryHelper.getStackInSlot(i)).func_77960_j() == 6 || (tagCompound = stack.func_77978_p()) == null || !tagCompound.func_74764_b("id") || id != tagCompound.func_74762_e("id")) continue;
            return i;
        }
        return -1;
    }

    public boolean isGlobal(int index) {
        return this.global[index];
    }

    public void setGlobal(int index, boolean global) {
        this.global[index] = global;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ItemStack[] getRemoteStacks(int si) {
        return this.slots[si];
    }

    public ItemStack getRemoteSlot(int si, int index) {
        if (index >= this.slots[si].length) {
            return null;
        }
        return this.slots[si][index];
    }

    public void updateCount(int si, int cnt) {
        this.numStacks[si] = cnt;
        StorageModuleItem.updateStackSize(this.func_70301_a(si), this.numStacks[si]);
    }

    public int getCount(int si) {
        return this.numStacks[si];
    }

    public int getMaxStacks(int si) {
        return this.maxsize[si];
    }

    public ItemStack decrStackSizeRemote(int si, int index, int amount) {
        boolean hasNew;
        if (index >= this.slots[si].length) {
            return null;
        }
        ItemStack[] stacks = this.slots[si];
        boolean hasOld = stacks[index] != null;
        ItemStack its = null;
        if (stacks[index] != null) {
            if (stacks[index].field_77994_a <= amount) {
                ItemStack old = stacks[index];
                stacks[index] = null;
                its = old;
            } else {
                its = stacks[index].func_77979_a(amount);
                if (stacks[index].field_77994_a == 0) {
                    stacks[index] = null;
                }
            }
        }
        boolean bl = hasNew = stacks[index] != null;
        if (hasOld && !hasNew) {
            int n = si;
            this.numStacks[n] = this.numStacks[n] - 1;
        } else if (hasNew && !hasOld) {
            int n = si;
            this.numStacks[n] = this.numStacks[n] + 1;
        }
        StorageModuleItem.updateStackSize(this.func_70301_a(si), this.numStacks[si]);
        this.func_70296_d();
        return its;
    }

    public boolean updateRemoteSlot(int si, int limit, int index, ItemStack stack) {
        boolean hasNew;
        if (index >= this.slots[si].length) {
            return false;
        }
        boolean hasOld = this.slots[si][index] != null;
        this.slots[si][index] = stack;
        if (stack != null && stack.field_77994_a > limit) {
            stack.field_77994_a = limit;
        }
        boolean bl = hasNew = stack != null;
        if (hasOld && !hasNew) {
            int n = si;
            this.numStacks[n] = this.numStacks[n] - 1;
        } else if (hasNew && !hasOld) {
            int n = si;
            this.numStacks[n] = this.numStacks[n] + 1;
        }
        StorageModuleItem.updateStackSize(this.func_70301_a(si), this.numStacks[si]);
        this.func_70296_d();
        return true;
    }

    public ItemStack findStorageWithId(int id) {
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound tagCompound;
            ItemStack stack;
            if (!this.inventoryHelper.containsItem(i) || (stack = this.inventoryHelper.getStackInSlot(i)).func_77960_j() == 6 || (tagCompound = stack.func_77978_p()) == null || !tagCompound.func_74764_b("id") || id != tagCompound.func_74762_e("id")) continue;
            return stack;
        }
        return null;
    }

    public ItemStack[] findStacksForId(int id) {
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound tagCompound;
            ItemStack stack;
            if (!this.inventoryHelper.containsItem(i) || (stack = this.inventoryHelper.getStackInSlot(i)).func_77960_j() == 6 || (tagCompound = stack.func_77978_p()) == null || !tagCompound.func_74764_b("id") || id != tagCompound.func_74762_e("id")) continue;
            return this.slots[i];
        }
        return null;
    }

    public void copyToModule(int si) {
        ItemStack stack = this.inventoryHelper.getStackInSlot(si);
        if (stack == null) {
            return;
        }
        if (stack.func_77960_j() == 6) {
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        int cnt = this.writeSlotsToNBT(tagCompound, "Items", si);
        tagCompound.func_74768_a("count", cnt);
    }

    public void copyFromModule(ItemStack stack, int si) {
        if (stack == null) {
            this.setMaxSize(si, 0);
            return;
        }
        if (stack.func_77960_j() == 6) {
            this.setMaxSize(si, 0);
            return;
        }
        this.setMaxSize(si, StorageModuleItem.MAXSIZE[stack.func_77960_j()]);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            this.readSlotsFromNBT(tagCompound, "Items", si);
        }
        this.updateStackCount(si);
    }

    private void setMaxSize(int si, int ms) {
        this.maxsize[si] = ms;
        this.slots[si] = new ItemStack[ms];
        this.numStacks[si] = 0;
    }

    private void updateStackCount(int si) {
        ItemStack[] stacks;
        this.numStacks[si] = 0;
        for (ItemStack stack : stacks = this.slots[si]) {
            if (stack == null) continue;
            int n = si;
            this.numStacks[n] = this.numStacks[n] + 1;
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        for (int i = 0; i < 4; ++i) {
            int max = tagCompound.func_74762_e("maxSize" + i);
            this.setMaxSize(i, max);
            this.readSlotsFromNBT(tagCompound, "Slots" + i, i);
            this.global[i] = tagCompound.func_74767_n("global" + i);
            this.updateStackCount(i);
        }
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    private void readSlotsFromNBT(NBTTagCompound tagCompound, String tagname, int index) {
        NBTTagList bufferTagList = tagCompound.func_150295_c(tagname, 10);
        for (int i = 0; i < Math.min(bufferTagList.func_74745_c(), this.slots[index].length); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.slots[index][i] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        for (int i = 0; i < 4; ++i) {
            this.writeSlotsToNBT(tagCompound, "Slots" + i, i);
            tagCompound.func_74768_a("maxSize" + i, this.maxsize[i]);
            tagCompound.func_74757_a("global" + i, this.global[i]);
        }
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    private int writeSlotsToNBT(NBTTagCompound tagCompound, String tagname, int index) {
        NBTTagList bufferTagList = new NBTTagList();
        int cnt = 0;
        for (int i = 0; i < this.slots[index].length; ++i) {
            ItemStack stack = this.slots[index][i];
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
                if (stack.field_77994_a > 0) {
                    ++cnt;
                }
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a(tagname, (NBTBase)bufferTagList);
        return cnt;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return rc;
        }
        if (CMD_SETGLOBAL.equals(command)) {
            int index = args.get("index").getInteger();
            boolean global = args.get("global").getBoolean();
            this.setGlobal(index, global);
            return true;
        }
        return false;
    }
}

