/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import mcjty.container.BaseSlot;
import mcjty.container.ContainerFactory;
import mcjty.container.GenericContainer;
import mcjty.container.SlotDefinition;
import mcjty.container.SlotFactory;
import mcjty.container.SlotType;
import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.blocks.storage.RemoteStorageItemInventory;
import mcjty.rftools.blocks.storage.RemoteStorageTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class RemoteStorageItemContainer
extends GenericContainer {
    public static final String CONTAINER_INVENTORY = "container";
    public static final int MAXSIZE_STORAGE = 300;
    private EntityPlayer entityPlayer;
    private int tabletIndex;
    public static final ContainerFactory factory = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_INPUT, new ItemStack[0]), RemoteStorageItemContainer.CONTAINER_INVENTORY, 0, -500, -500, 30, 0, 10, 0);
            this.layoutPlayerInventorySlots(91, 157);
        }
    };

    public RemoteStorageItemContainer(EntityPlayer player) {
        super(factory);
        this.entityPlayer = player;
        if (this.isServer()) {
            int si;
            int maxStacks = 0;
            RemoteStorageTileEntity remoteStorageTileEntity = this.getRemoteStorage();
            if (remoteStorageTileEntity != null && (si = remoteStorageTileEntity.findRemoteIndex(this.getStorageID())) != -1) {
                maxStacks = remoteStorageTileEntity.getMaxStacks(si);
            }
            ItemStack stack = player.func_70694_bm();
            stack.func_77978_p().func_74768_a("maxSize", maxStacks);
        }
        this.addInventory(CONTAINER_INVENTORY, new RemoteStorageItemInventory(player));
        this.addInventory("player", (IInventory)player.field_71071_by);
        this.tabletIndex = player.field_71071_by.field_70461_c;
        this.generateSlots();
    }

    private RemoteStorageTileEntity getRemoteStorage() {
        return RemoteStorageIdRegistry.getRemoteStorage(this.entityPlayer.field_70170_p, this.getStorageID());
    }

    private int getStorageID() {
        return this.entityPlayer.func_70694_bm().func_77978_p().func_74762_e("id");
    }

    private boolean isServer() {
        return !this.entityPlayer.field_70170_p.field_72995_K;
    }

    public void generateSlots() {
        for (SlotFactory slotFactory : factory.getSlots()) {
            BaseSlot slot = slotFactory.getSlotType() == SlotType.SLOT_PLAYERHOTBAR ? (slotFactory.getIndex() == this.tabletIndex ? new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()){

                public boolean func_82869_a(EntityPlayer player) {
                    return false;
                }
            } : new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY())) : (slotFactory.getSlotType() == SlotType.SLOT_PLAYERINV ? new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()) : new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()){

                public boolean func_75214_a(ItemStack stack) {
                    if (RemoteStorageItemContainer.this.isServer()) {
                        RemoteStorageTileEntity storage = RemoteStorageItemContainer.this.getRemoteStorage();
                        int si = -1;
                        if (storage != null) {
                            si = storage.findRemoteIndex(RemoteStorageItemContainer.this.getStorageID());
                        }
                        if (si != -1) {
                            RemoteStorageItemContainer.this.entityPlayer.func_70694_bm().func_77978_p().func_74768_a("maxSize", storage.getMaxStacks(si));
                            return storage.func_94041_b(this.getSlotIndex(), stack);
                        }
                        RemoteStorageItemContainer.this.entityPlayer.func_70694_bm().func_77978_p().func_74768_a("maxSize", 0);
                        return false;
                    }
                    int maxSize = RemoteStorageItemContainer.this.entityPlayer.func_70694_bm().func_77978_p().func_74762_e("maxSize");
                    if (this.getSlotIndex() >= maxSize) {
                        return false;
                    }
                    return super.func_75214_a(stack);
                }
            });
            this.func_75146_a((Slot)slot);
        }
    }
}

