/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import mcjty.container.InventoryHelper;
import mcjty.entity.GenericTileEntity;
import mcjty.network.Argument;
import mcjty.rftools.ClientInfo;
import mcjty.rftools.blocks.storage.ModularStorageContainer;
import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.blocks.storage.RemoteStorageTileEntity;
import mcjty.rftools.items.storage.StorageFilterCache;
import mcjty.rftools.items.storage.StorageFilterItem;
import mcjty.rftools.items.storage.StorageModuleItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class ModularStorageTileEntity
extends GenericTileEntity
implements ISidedInventory {
    public static final String CMD_SETTINGS = "settings";
    public static final String CMD_COMPACT = "compact";
    public static final String CMD_CYCLE = "cycle";
    private int[] accessible = null;
    private int maxSize = 0;
    private StorageFilterCache filterCache = null;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ModularStorageContainer.factory, 303);
    private String sortMode = "";
    private String viewMode = "";
    private boolean groupMode = false;
    private String filter = "";
    private int numStacks = -1;
    private int remoteId = 0;
    private int prevLevel = -3;
    private int timer = 10;

    protected void checkStateServer() {
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = 10;
        if (this.isRemote()) {
            int level;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            int si = -1;
            if (storageTileEntity != null) {
                si = storageTileEntity.findRemoteIndex(this.remoteId);
            }
            if (si == -1) {
                if (this.prevLevel != -2) {
                    this.prevLevel = -2;
                    this.numStacks = -1;
                    this.setMaxSize(0);
                }
                return;
            }
            this.numStacks = storageTileEntity.getCount(si);
            int newMaxSize = storageTileEntity.getMaxStacks(si);
            if (newMaxSize != this.maxSize) {
                this.setMaxSize(newMaxSize);
            }
            if ((level = this.getRenderLevel()) != this.prevLevel) {
                this.prevLevel = level;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public int[] func_94128_d(int side) {
        if (this.accessible == null) {
            this.accessible = new int[this.maxSize];
            for (int i = 0; i < this.maxSize; ++i) {
                this.accessible[i] = 3 + i;
            }
        }
        return this.accessible;
    }

    public boolean isGroupMode() {
        return this.groupMode;
    }

    public void setGroupMode(boolean groupMode) {
        this.groupMode = groupMode;
        this.func_70296_d();
    }

    public String getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(String sortMode) {
        this.sortMode = sortMode;
        this.func_70296_d();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.func_70296_d();
    }

    public String getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(String viewMode) {
        this.viewMode = viewMode;
        this.func_70296_d();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return index >= 3 && this.func_94041_b(index, item);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return index >= 3 && this.func_94041_b(index, item);
    }

    public int func_70302_i_() {
        return 3 + this.maxSize;
    }

    private boolean containsItem(int index) {
        if (this.isStorageAvailableRemotely(index)) {
            index -= 3;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return false;
            }
            ItemStack[] slots = storageTileEntity.findStacksForId(this.remoteId);
            if (slots == null || index >= slots.length) {
                return false;
            }
            return slots[index] != null;
        }
        return this.inventoryHelper.containsItem(index);
    }

    private boolean isStorageAvailableRemotely(int index) {
        return this.isServer() && this.isRemote() && index >= 3;
    }

    private boolean isRemote() {
        return this.remoteId != 0;
    }

    public int getRemoteId() {
        return this.remoteId;
    }

    public ItemStack func_70301_a(int index) {
        if (index >= this.func_70302_i_()) {
            return null;
        }
        if (this.isStorageAvailableRemotely(index)) {
            index -= 3;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return null;
            }
            ItemStack[] slots = storageTileEntity.findStacksForId(this.remoteId);
            if (slots == null || index >= slots.length) {
                return null;
            }
            return slots[index];
        }
        return this.inventoryHelper.getStackInSlot(index);
    }

    private void handleNewAmount(boolean s1, int index) {
        if (index < 3) {
            return;
        }
        boolean s2 = this.containsItem(index);
        if (s1 == s2) {
            return;
        }
        int rlold = this.getRenderLevel();
        this.numStacks = s1 ? --this.numStacks : ++this.numStacks;
        StorageModuleItem.updateStackSize(this.func_70301_a(0), this.numStacks);
        int rlnew = this.getRenderLevel();
        if (rlold != rlnew) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int getRenderLevel() {
        if (this.numStacks == -1 || this.maxSize == 0) {
            return -1;
        }
        return (this.numStacks + 6) * 7 / this.maxSize;
    }

    public int getNumStacks() {
        return this.numStacks;
    }

    private ItemStack decrStackSizeHelper(int index, int amount) {
        if (this.isStorageAvailableRemotely(index)) {
            index -= 3;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return null;
            }
            int si = storageTileEntity.findRemoteIndex(this.remoteId);
            if (si == -1) {
                return null;
            }
            return storageTileEntity.decrStackSizeRemote(si, index, amount);
        }
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70298_a(int index, int amount) {
        boolean s1 = this.containsItem(index);
        ItemStack itemStack = this.decrStackSizeHelper(index, amount);
        this.handleNewAmount(s1, index);
        if (index == 0) {
            this.copyFromModule(this.inventoryHelper.getStackInSlot(0));
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    private void setInventorySlotContentsHelper(int limit, int index, ItemStack stack) {
        if (this.isStorageAvailableRemotely(index)) {
            index -= 3;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return;
            }
            int si = storageTileEntity.findRemoteIndex(this.remoteId);
            if (si == -1) {
                return;
            }
            storageTileEntity.updateRemoteSlot(si, limit, index, stack);
        } else {
            this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        }
    }

    public void syncToClient() {
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index != 0) {
            if (index == 1) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else if (index == 2) {
                this.filterCache = null;
            }
        }
        boolean s1 = this.containsItem(index);
        this.setInventorySlotContentsHelper(this.func_70297_j_(), index, stack);
        if (index == 0 && this.isServer()) {
            this.copyFromModule(stack);
        }
        this.handleNewAmount(s1, index);
    }

    public String func_145825_b() {
        return "Modular Storage Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index >= this.func_70302_i_()) {
            return false;
        }
        if (index < 3) {
            return true;
        }
        if (this.isStorageAvailableRemotely(index)) {
            index -= 3;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return false;
            }
            ItemStack[] stacks = storageTileEntity.findStacksForId(this.remoteId);
            if (stacks == null || index >= stacks.length) {
                return false;
            }
        }
        if (this.inventoryHelper.containsItem(2)) {
            this.getFilterCache();
            if (this.filterCache != null) {
                return this.filterCache.match(stack);
            }
        }
        return true;
    }

    private void getFilterCache() {
        if (this.filterCache == null) {
            this.filterCache = StorageFilterItem.getCache(this.inventoryHelper.getStackInSlot(2));
        }
    }

    public void copyToModule() {
        ItemStack stack = this.inventoryHelper.getStackInSlot(0);
        if (stack == null) {
            return;
        }
        if (stack.func_77960_j() == 6) {
            this.remoteId = 0;
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        int cnt = this.writeBufferToItemNBT(tagCompound);
        tagCompound.func_74768_a("count", cnt);
    }

    public void copyFromModule(ItemStack stack) {
        for (int i = 3; i < this.inventoryHelper.getCount(); ++i) {
            this.inventoryHelper.setInventorySlotContents(0, i, null);
        }
        if (stack == null) {
            this.setMaxSize(0);
            this.numStacks = -1;
            return;
        }
        this.remoteId = 0;
        if (stack.func_77960_j() == 6) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null || !tagCompound.func_74764_b("id")) {
                this.setMaxSize(0);
                this.numStacks = -1;
                return;
            }
            this.remoteId = tagCompound.func_74762_e("id");
            RemoteStorageTileEntity remoteStorageTileEntity = this.getRemoteStorage(this.remoteId);
            if (remoteStorageTileEntity == null) {
                this.setMaxSize(0);
                this.numStacks = -1;
                return;
            }
            ItemStack storageStack = remoteStorageTileEntity.findStorageWithId(this.remoteId);
            if (storageStack == null) {
                this.setMaxSize(0);
                this.numStacks = -1;
                return;
            }
            this.setMaxSize(StorageModuleItem.MAXSIZE[storageStack.func_77960_j()]);
        } else {
            this.setMaxSize(StorageModuleItem.MAXSIZE[stack.func_77960_j()]);
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null) {
                this.readBufferFromItemNBT(tagCompound);
            }
        }
        this.updateStackCount();
    }

    private RemoteStorageTileEntity getRemoteStorage(int id) {
        World world = this.getWorld();
        return RemoteStorageIdRegistry.getRemoteStorage(world, id);
    }

    private void updateStackCount() {
        this.numStacks = 0;
        if (this.isServer() && this.isRemote()) {
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return;
            }
            int si = storageTileEntity.findRemoteIndex(this.remoteId);
            if (si == -1) {
                return;
            }
            ItemStack[] stacks = storageTileEntity.getRemoteStacks(si);
            for (int i = 0; i < Math.min(this.maxSize, stacks.length); ++i) {
                if (stacks[i] == null) continue;
                ++this.numStacks;
            }
            storageTileEntity.updateCount(si, this.numStacks);
        } else {
            for (int i = 3; i < 3 + this.maxSize; ++i) {
                if (!this.inventoryHelper.containsItem(i)) continue;
                ++this.numStacks;
            }
        }
        StorageModuleItem.updateStackSize(this.func_70301_a(0), this.numStacks);
    }

    private boolean isServer() {
        if (this.field_145850_b != null) {
            return !this.field_145850_b.field_72995_K;
        }
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    private World getWorld() {
        Object world = this.field_145850_b;
        if (world == null) {
            world = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? ClientInfo.getWorld() : DimensionManager.getWorld((int)0);
        }
        return world;
    }

    private void setMaxSize(int ms) {
        this.maxSize = ms;
        this.inventoryHelper.setNewCount(3 + this.maxSize);
        this.accessible = null;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.numStacks = tagCompound.func_74762_e("numStacks");
        this.maxSize = tagCompound.func_74762_e("maxSize");
        this.remoteId = tagCompound.func_74762_e("remoteId");
        this.sortMode = tagCompound.func_74779_i("sortMode");
        this.viewMode = tagCompound.func_74779_i("viewMode");
        this.groupMode = tagCompound.func_74767_n("groupMode");
        this.filter = tagCompound.func_74779_i("filter");
        this.inventoryHelper.setNewCount(3 + this.maxSize);
        this.accessible = null;
        this.readBufferFromNBT(tagCompound);
        if (this.isServer()) {
            this.updateStackCount();
        }
    }

    private void readBufferFromItemNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i + 3, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        if (tagCompound.func_74764_b("SlotStorage")) {
            for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
                NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
                this.inventoryHelper.setStackInSlot(i + 3, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
            }
            this.inventoryHelper.setStackInSlot(0, ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("SlotStorage")));
            this.inventoryHelper.setStackInSlot(1, ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("SlotType")));
            this.inventoryHelper.setStackInSlot(2, ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("SlotFilter")));
        } else {
            int index = 0;
            for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
                NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
                this.inventoryHelper.setStackInSlot(index, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
                if (++index != 2) continue;
                ++index;
            }
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        this.writeSlot(tagCompound, 0, "SlotStorage");
        this.writeSlot(tagCompound, 1, "SlotType");
        this.writeSlot(tagCompound, 2, "SlotFilter");
        tagCompound.func_74768_a("numStacks", this.numStacks);
        tagCompound.func_74768_a("maxSize", this.maxSize);
        tagCompound.func_74768_a("remoteId", this.remoteId);
        tagCompound.func_74778_a("sortMode", this.sortMode);
        tagCompound.func_74778_a("viewMode", this.viewMode);
        tagCompound.func_74757_a("groupMode", this.groupMode);
        tagCompound.func_74778_a("filter", this.filter);
    }

    private void writeSlot(NBTTagCompound tagCompound, int index, String name) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        ItemStack stack = this.inventoryHelper.getStackInSlot(index);
        if (stack != null) {
            stack.func_77955_b(nbtTagCompound);
        }
        tagCompound.func_74782_a(name, (NBTBase)nbtTagCompound);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        boolean sendToClient = this.isServer() && this.isRemote();
        NBTTagList bufferTagList = new NBTTagList();
        if (sendToClient) {
            ItemStack[] slots;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity != null && (slots = storageTileEntity.findStacksForId(this.remoteId)) != null) {
                for (ItemStack stack : slots) {
                    NBTTagCompound nbtTagCompound = new NBTTagCompound();
                    if (stack != null) {
                        stack.func_77955_b(nbtTagCompound);
                    }
                    bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
                }
            }
        } else {
            for (int i = 3; i < this.inventoryHelper.getCount(); ++i) {
                ItemStack stack = this.inventoryHelper.getStackInSlot(i);
                NBTTagCompound nbtTagCompound = new NBTTagCompound();
                if (stack != null) {
                    stack.func_77955_b(nbtTagCompound);
                }
                bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
            }
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    private int writeBufferToItemNBT(NBTTagCompound tagCompound) {
        int cnt = 0;
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 3; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
                if (stack.field_77994_a > 0) {
                    ++cnt;
                }
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
        return cnt;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETTINGS.equals(command)) {
            this.setFilter(args.get("filter").getString());
            this.setViewMode(args.get("viewMode").getString());
            this.setSortMode(args.get("sortMode").getString());
            this.setGroupMode(args.get("groupMode").getBoolean());
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (CMD_COMPACT.equals(command)) {
            this.compact();
            return true;
        }
        if (CMD_CYCLE.equals(command)) {
            this.cycle();
            return true;
        }
        return false;
    }

    private void cycle() {
        if (this.isRemote()) {
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return;
            }
            this.remoteId = storageTileEntity.cycle(this.remoteId);
            this.func_70301_a(0).func_77978_p().func_74768_a("id", this.remoteId);
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void compact() {
        if (this.isRemote()) {
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return;
            }
            storageTileEntity.compact(this.remoteId);
        } else {
            InventoryHelper.compactStacks((InventoryHelper)this.inventoryHelper, (int)3, (int)this.maxSize);
        }
        this.updateStackCount();
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

