/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import mcjty.base.ModBase;
import mcjty.container.GenericGuiContainer;
import mcjty.entity.GenericTileEntity;
import mcjty.gui.Scrollable;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.events.TextEvent;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.Layout;
import mcjty.gui.layout.LayoutHint;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.AbstractWidget;
import mcjty.gui.widgets.BlockRender;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.ImageChoiceLabel;
import mcjty.gui.widgets.ImageLabel;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Slider;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.Widget;
import mcjty.gui.widgets.WidgetList;
import mcjty.network.Argument;
import mcjty.network.PacketUpdateNBTItem;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.storage.ModularStorageConfiguration;
import mcjty.rftools.blocks.storage.ModularStorageContainer;
import mcjty.rftools.blocks.storage.ModularStorageItemContainer;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storage.PacketCompact;
import mcjty.rftools.blocks.storage.PacketCycleStorage;
import mcjty.rftools.blocks.storage.RemoteStorageItemContainer;
import mcjty.rftools.blocks.storage.modules.DefaultTypeModule;
import mcjty.rftools.blocks.storage.modules.TypeModule;
import mcjty.rftools.blocks.storage.sorters.ItemSorter;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

public class GuiModularStorage
extends GenericGuiContainer<ModularStorageTileEntity> {
    public static final int STORAGE_WIDTH = 256;
    public static final int STORAGE_HEIGHT0 = ModularStorageConfiguration.height1;
    public static final int STORAGE_HEIGHT1 = ModularStorageConfiguration.height2;
    public static final int STORAGE_HEIGHT2 = ModularStorageConfiguration.height3;
    public static final String VIEW_LIST = "list";
    public static final String VIEW_COLUMNS = "columns";
    public static final String VIEW_ICONS = "icons";
    private TypeModule typeModule;
    private static final ResourceLocation iconLocationTop = new ResourceLocation("rftools", "textures/gui/modularstorageTop.png");
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/modularstorage.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private WidgetList itemList;
    private Slider slider;
    private TextField filter;
    private ImageChoiceLabel viewMode;
    private ImageChoiceLabel sortMode;
    private ImageChoiceLabel groupMode;
    private Label amountLabel;
    private Button cycleButton;
    private Button compactButton;

    public GuiModularStorage(ModularStorageTileEntity modularStorageTileEntity, ModularStorageContainer container) {
        this(modularStorageTileEntity, (Container)container);
    }

    public GuiModularStorage(RemoteStorageItemContainer container) {
        this(null, (Container)container);
    }

    public GuiModularStorage(ModularStorageItemContainer container) {
        this(null, (Container)container);
    }

    public GuiModularStorage(ModularStorageTileEntity modularStorageTileEntity, Container container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)modularStorageTileEntity, container, RFTools.GUI_MANUAL_MAIN, "storage");
        this.field_146999_f = 256;
        int width = Minecraft.func_71410_x().field_71443_c;
        int height = Minecraft.func_71410_x().field_71440_d;
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x(), width, height);
        width = scaledresolution.func_78326_a();
        height = scaledresolution.func_78328_b();
        this.field_147000_g = height > 510 ? STORAGE_HEIGHT2 : (height > 340 ? STORAGE_HEIGHT1 : STORAGE_HEIGHT0);
        for (Object o : container.field_75151_b) {
            Slot slot = (Slot)o;
            slot.field_75221_f += this.field_147000_g - STORAGE_HEIGHT0;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.itemList = ((WidgetList)((WidgetList)this.createStyledList().setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 3, 235, this.field_147000_g - 89))).setNoSelectionMode(true).setUserObject((Object)new Integer(-1))).setLeftMargin(0).setRowheight(-1);
        this.slider = ((Slider)((Slider)new Slider(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(241, 3, 11, this.field_147000_g - 89))).setDesiredWidth(11)).setVertical().setScrollable((Scrollable)this.itemList);
        this.filter = ((TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, this.field_147000_g - 79, 80, 12))).setTooltips(new String[]{"Name based filter for items"})).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiModularStorage.this.updateSettings();
            }
        });
        this.viewMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, this.field_147000_g - 66, 16, 16))).setTooltips(new String[]{"Control how items are shown", "in the view"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiModularStorage.this.updateSettings();
            }
        });
        this.viewMode.addChoice(VIEW_LIST, "Items are shown in a list view", guiElements, 144, 16);
        this.viewMode.addChoice(VIEW_COLUMNS, "Items are shown in columns", guiElements, 160, 16);
        this.viewMode.addChoice(VIEW_ICONS, "Items are shown with icons", guiElements, 176, 16);
        this.updateTypeModule();
        this.sortMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(28, this.field_147000_g - 66, 16, 16))).setTooltips(new String[]{"Control how items are sorted", "in the view"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiModularStorage.this.updateSettings();
            }
        });
        for (ItemSorter sorter : this.typeModule.getSorters()) {
            this.sortMode.addChoice(sorter.getName(), sorter.getTooltip(), guiElements, sorter.getU(), sorter.getV());
        }
        this.groupMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(48, this.field_147000_g - 66, 16, 16))).setTooltips(new String[]{"If enabled it will show groups", "based on sorting criterium"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiModularStorage.this.updateSettings();
            }
        });
        this.groupMode.addChoice("Off", "Don't show groups", guiElements, 208, 0);
        this.groupMode.addChoice("On", "Show groups", guiElements, 224, 0);
        this.amountLabel = new Label(this.field_146297_k, (Gui)this);
        this.amountLabel.setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.amountLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(22, this.field_147000_g - 48, 66, 12));
        this.amountLabel.setTooltips(new String[]{"Amount of stacks / maximum amount"});
        this.amountLabel.setText("? / ?");
        this.compactButton = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, this.field_147000_g - 48, 12, 12))).setText("z")).setTooltips(new String[]{"Compact equal stacks"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiModularStorage.this.compact();
            }
        });
        this.cycleButton = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("C")).setTooltips(new String[]{"Cycle to the next storage module"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(66, this.field_147000_g - 66, 16, 16))).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiModularStorage.this.cycleStorage();
            }
        });
        if (this.tileEntity != null) {
            this.filter.setText(ModularStorageConfiguration.clearSearchOnOpen ? "" : ((ModularStorageTileEntity)this.tileEntity).getFilter());
            this.setViewMode(((ModularStorageTileEntity)this.tileEntity).getViewMode());
            this.setSortMode(((ModularStorageTileEntity)this.tileEntity).getSortMode());
            this.groupMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).isGroupMode() ? 1 : 0);
        } else {
            NBTTagCompound tagCompound = Minecraft.func_71410_x().field_71439_g.func_70694_bm().func_77978_p();
            this.filter.setText(ModularStorageConfiguration.clearSearchOnOpen ? "" : tagCompound.func_74779_i("filter"));
            this.setViewMode(tagCompound.func_74779_i("viewMode"));
            this.setSortMode(tagCompound.func_74779_i("sortMode"));
            this.groupMode.setCurrentChoice(tagCompound.func_74767_n("groupMode") ? 1 : 0);
        }
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.itemList)).addChild((Widget)this.slider)).addChild((Widget)this.filter)).addChild((Widget)this.viewMode)).addChild((Widget)this.sortMode)).addChild((Widget)this.groupMode)).addChild((Widget)this.amountLabel)).addChild((Widget)this.compactButton)).addChild((Widget)this.cycleButton);
        toplevel.setBackgrounds(iconLocationTop, iconLocation);
        toplevel.setBackgroundLayout(false, this.field_147000_g - STORAGE_HEIGHT0 + 2);
        if (this.tileEntity == null) {
            ImageLabel hideLabel = new ImageLabel(this.field_146297_k, (Gui)this);
            hideLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, this.field_147000_g - 23, 62, 21));
            hideLabel.setImage(guiElements, 32, 32);
            toplevel.addChild((Widget)hideLabel);
        }
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        if (ModularStorageConfiguration.autofocusSearch) {
            this.window.setTextFocus((Widget)this.filter);
        }
    }

    private void setSortMode(String sortMode) {
        int idx = this.sortMode.findChoice(sortMode);
        if (idx == -1) {
            this.sortMode.setCurrentChoice(0);
        } else {
            this.sortMode.setCurrentChoice(idx);
        }
    }

    private void setViewMode(String viewMode) {
        int idx = this.viewMode.findChoice(viewMode);
        if (idx == -1) {
            this.viewMode.setCurrentChoice(VIEW_LIST);
        } else {
            this.viewMode.setCurrentChoice(idx);
        }
    }

    private void cycleStorage() {
        if (this.tileEntity != null) {
            this.sendServerCommand(RFToolsMessages.INSTANCE, "cycle", new Argument[0]);
        } else {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketCycleStorage());
        }
    }

    private void compact() {
        if (this.tileEntity != null) {
            this.sendServerCommand(RFToolsMessages.INSTANCE, "compact", new Argument[0]);
        } else {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketCompact());
        }
    }

    private void updateSettings() {
        if (this.tileEntity != null) {
            this.sendServerCommand(RFToolsMessages.INSTANCE, "settings", new Argument[]{new Argument("sortMode", this.sortMode.getCurrentChoice()), new Argument("viewMode", this.viewMode.getCurrentChoice()), new Argument("filter", this.filter.getText()), new Argument("groupMode", this.groupMode.getCurrentChoiceIndex() == 1)});
        } else {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTItem(new Argument[]{new Argument("sortMode", this.sortMode.getCurrentChoice()), new Argument("viewMode", this.viewMode.getCurrentChoice()), new Argument("filter", this.filter.getText()), new Argument("groupMode", this.groupMode.getCurrentChoiceIndex() == 1)}));
        }
    }

    private Slot findEmptySlot() {
        for (Object slotObject : this.field_147002_h.field_75151_b) {
            Slot slot = (Slot)slotObject;
            if (this.tileEntity != null && slot.getSlotIndex() < 3 || slot.func_75216_d() && slot.func_75211_c().field_77994_a != 0) continue;
            return slot;
        }
        return null;
    }

    public Slot func_146975_c(int x, int y) {
        Object userObject;
        Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget != null && (userObject = widget.getUserObject()) instanceof Integer) {
            Integer slotIndex = (Integer)userObject;
            if (slotIndex != -1) {
                return this.field_147002_h.func_75139_a(slotIndex.intValue());
            }
            return this.findEmptySlot();
        }
        return super.func_146975_c(x, y);
    }

    private void dumpClasses(String name, Object o) {
        Logging.log((String)(name + ":" + o.getClass().getCanonicalName()));
        Class<?>[] classes = o.getClass().getClasses();
        for (Class<?> a : classes) {
            Logging.log((String)("        " + a.getCanonicalName()));
        }
        Logging.log((String)("        Super:" + o.getClass().getGenericSuperclass()));
        for (Type type : o.getClass().getGenericInterfaces()) {
            Logging.log((String)("        type:" + type.getClass().getCanonicalName()));
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        Slot slot;
        if ((Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && (slot = this.func_146975_c(x, y)) != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            Item item = stack.func_77973_b();
            if (item instanceof ItemBlock) {
                Block block = ((ItemBlock)item).field_150939_a;
                this.dumpClasses("Block", block);
            } else {
                this.dumpClasses("Item", item);
            }
        }
        super.func_73864_a(x, y, button);
    }

    private void updateList() {
        int max;
        int i;
        int spacing;
        int labelWidth;
        int numcolumns;
        this.itemList.removeChildren();
        if (this.tileEntity != null && !this.field_147002_h.func_75139_a(0).func_75216_d()) {
            this.amountLabel.setText("(no storage)");
            this.compactButton.setEnabled(false);
            this.cycleButton.setEnabled(false);
            return;
        }
        this.cycleButton.setEnabled(this.isTabletWithRemote() || this.isRemote());
        String filterText = this.filter.getText().toLowerCase().trim();
        String view = this.viewMode.getCurrentChoice();
        if (VIEW_LIST.equals(view)) {
            numcolumns = 1;
            labelWidth = 210;
            spacing = 5;
        } else if (VIEW_COLUMNS.equals(view)) {
            numcolumns = 2;
            labelWidth = 86;
            spacing = 5;
        } else {
            numcolumns = 12;
            labelWidth = 0;
            spacing = 3;
        }
        ArrayList<Pair> items = new ArrayList<Pair>();
        if (this.tileEntity != null) {
            for (i = 3; i < ((ModularStorageTileEntity)this.tileEntity).func_70302_i_(); ++i) {
                ItemStack stack = ((ModularStorageTileEntity)this.tileEntity).func_70301_a(i);
                if (stack == null || stack.field_77994_a <= 0) continue;
                String displayName = stack.func_82833_r();
                if (!filterText.isEmpty() && !displayName.toLowerCase().contains(filterText)) continue;
                items.add(Pair.of((Object)stack, (Object)i));
            }
            max = ((ModularStorageTileEntity)this.tileEntity).func_70302_i_() - 3;
        } else {
            for (i = 0; i < 300; ++i) {
                Slot slot = this.field_147002_h.func_75139_a(i);
                ItemStack stack = slot.func_75211_c();
                if (stack == null || stack.field_77994_a <= 0) continue;
                String displayName = stack.func_82833_r();
                if (!filterText.isEmpty() && !displayName.toLowerCase().contains(filterText)) continue;
                items.add(Pair.of((Object)stack, (Object)i));
            }
            max = this.field_146297_k.field_71439_g.func_70694_bm().func_77978_p().func_74762_e("maxSize");
        }
        this.amountLabel.setText(items.size() + " / " + max);
        this.compactButton.setEnabled(max > 0);
        int sort = this.getCurrentSortMode();
        boolean dogroups = this.groupMode.getCurrentChoiceIndex() == 1;
        ItemSorter itemSorter = this.typeModule.getSorters().get(sort);
        Collections.sort(items, itemSorter.getComparator());
        Pair<Panel, Integer> currentPos = MutablePair.of(null, (Object)0);
        Pair prevItem = null;
        for (Pair item : items) {
            currentPos = this.addItemToList((ItemStack)item.getKey(), this.itemList, currentPos, numcolumns, labelWidth, spacing, (Integer)item.getValue(), dogroups && (prevItem == null || !itemSorter.isSameGroup(prevItem, (Pair<ItemStack, Integer>)item)), itemSorter.getGroupName((Pair<ItemStack, Integer>)item));
            prevItem = item;
        }
    }

    private boolean isRemote() {
        ItemStack stack = this.field_147002_h.func_75139_a(0).func_75211_c();
        if (stack == null) {
            return false;
        }
        return stack.func_77960_j() == 6;
    }

    private boolean isTabletWithRemote() {
        if (this.tileEntity != null) {
            return false;
        }
        int storageType = this.field_146297_k.field_71439_g.func_70694_bm().func_77978_p().func_74762_e("childDamage");
        return storageType == 6;
    }

    private int getCurrentSortMode() {
        this.updateTypeModule();
        String sortName = this.sortMode.getCurrentChoice();
        this.sortMode.clear();
        for (ItemSorter sorter : this.typeModule.getSorters()) {
            this.sortMode.addChoice(sorter.getName(), sorter.getTooltip(), guiElements, sorter.getU(), sorter.getV());
        }
        int sort = this.sortMode.findChoice(sortName);
        if (sort == -1) {
            sort = 0;
        }
        this.sortMode.setCurrentChoice(sort);
        return sort;
    }

    private void updateTypeModule() {
        ItemStack typeStack;
        this.typeModule = this.tileEntity != null ? ((typeStack = ((ModularStorageTileEntity)this.tileEntity).func_70301_a(1)) == null || typeStack.field_77994_a == 0 || !(typeStack.func_77973_b() instanceof TypeModule) ? new DefaultTypeModule() : (TypeModule)typeStack.func_77973_b()) : new DefaultTypeModule();
    }

    private Pair<Panel, Integer> addItemToList(ItemStack stack, WidgetList itemList, Pair<Panel, Integer> currentPos, int numcolumns, int labelWidth, int spacing, int slot, boolean newgroup, String groupName) {
        Panel panel = (Panel)currentPos.getKey();
        if (panel == null || (Integer)currentPos.getValue() >= numcolumns || newgroup && groupName != null) {
            if (newgroup && groupName != null) {
                itemList.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(groupName).setColor(ModularStorageConfiguration.groupForeground).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setFilledBackground(ModularStorageConfiguration.groupBackground).setDesiredHeight(10));
            }
            panel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout().setSpacing(spacing)).setDesiredHeight(12)).setUserObject((Object)new Integer(-1))).setDesiredHeight(16);
            currentPos = MutablePair.of((Object)panel, (Object)0);
            itemList.addChild((Widget)panel);
        }
        BlockRender blockRender = ((BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)stack).setUserObject((Object)new Integer(slot))).setOffsetX(-1).setOffsetY(-1);
        panel.addChild((Widget)blockRender);
        if (labelWidth > 0) {
            String displayName = labelWidth > 100 ? this.typeModule.getLongLabel(stack) : this.typeModule.getShortLabel(stack);
            AbstractWidget label = new Label(this.field_146297_k, (Gui)this).setText(displayName).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDesiredWidth(labelWidth).setUserObject((Object)new Integer(-1));
            panel.addChild((Widget)label);
        }
        currentPos.setValue((Object)((Integer)currentPos.getValue() + 1));
        return currentPos;
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (!this.window.keyTyped(typedChar, keyCode)) {
            if (typedChar >= '1' && typedChar <= '9') {
                return;
            }
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.updateList();
        this.drawWindow();
    }
}

