/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import java.awt.Rectangle;
import mcjty.base.ModBase;
import mcjty.container.GenericGuiContainer;
import mcjty.entity.GenericTileEntity;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.layout.Layout;
import mcjty.gui.layout.LayoutHint;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.AbstractContainerWidget;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.EnergyBar;
import mcjty.gui.widgets.ImageChoiceLabel;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Widget;
import mcjty.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorContainer;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiSpaceProjector
extends GenericGuiContainer<SpaceProjectorTileEntity> {
    public static final int PROJECTOR_WIDTH = 180;
    public static final int PROJECTOR_HEIGHT = 152;
    private EnergyBar energyBar;
    private ImageChoiceLabel redstoneMode;
    private Button projectButton;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/spaceprojector.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiSpaceProjector(SpaceProjectorTileEntity spaceProjectorTileEntity, SpaceProjectorContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)spaceProjectorTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, null);
        SpaceProjectorTileEntity.setCurrentRF((int)spaceProjectorTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((SpaceProjectorTileEntity)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 7, 8, 54))).setShowText(false);
        SpaceProjectorTileEntity cfr_ignored_0 = (SpaceProjectorTileEntity)this.tileEntity;
        this.energyBar.setValue(SpaceProjectorTileEntity.getCurrentRF());
        this.projectButton = ((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Update")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(100, 7, 70, 16))).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiSpaceProjector.this.updateProjection();
            }
        });
        this.initRedstoneMode();
        AbstractContainerWidget toplevel = ((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.energyBar)).addChild((Widget)this.redstoneMode)).addChild((Widget)this.projectButton);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        ((SpaceProjectorTileEntity)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
    }

    private void updateProjection() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "project", new Argument[0]);
    }

    private void initRedstoneMode() {
        this.redstoneMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiSpaceProjector.this.changeRedstoneMode();
            }
        }).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        this.redstoneMode.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(150, 46, 16, 16));
        this.redstoneMode.setCurrentChoice(((SpaceProjectorTileEntity)this.tileEntity).getRedstoneMode().ordinal());
    }

    private void changeRedstoneMode() {
        ((SpaceProjectorTileEntity)this.tileEntity).setRedstoneMode(RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()]);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "rsMode", new Argument[]{new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()].getDescription())});
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
        SpaceProjectorTileEntity cfr_ignored_0 = (SpaceProjectorTileEntity)this.tileEntity;
        this.energyBar.setValue(SpaceProjectorTileEntity.getCurrentRF());
        ((SpaceProjectorTileEntity)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
    }
}

