/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import mcjty.container.InventoryHelper;
import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.network.Argument;
import mcjty.rftools.blocks.RFToolsTools;
import mcjty.rftools.blocks.spaceprojector.BuilderContainer;
import mcjty.rftools.blocks.spaceprojector.SpaceChamberRepository;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorConfiguration;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorSetup;
import mcjty.rftools.blocks.teleporter.RfToolsTeleporter;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.varia.BlockTools;
import mcjty.varia.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")})
public class BuilderTileEntity
extends GenericEnergyReceiverTileEntity
implements ISidedInventory,
SimpleComponent,
IPeripheral {
    public static final String COMPONENT_NAME = "builder";
    public static final String CMD_SETMODE = "setMode";
    public static final String CMD_SETANCHOR = "setAnchor";
    public static final String CMD_SETROTATE = "setRotate";
    public static final String CMD_SETSILENT = "setSilent";
    public static final String CMD_SETSUPPORT = "setSupport";
    public static final String CMD_SETENTITIES = "setEntities";
    public static final String CMD_SETLOOP = "setLoop";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, BuilderContainer.factory, 1);
    public static final int MODE_COPY = 0;
    public static final int MODE_MOVE = 1;
    public static final int MODE_SWAP = 2;
    public static final int MODE_BACK = 3;
    public static final String[] MODES = new String[]{"Copy", "Move", "Swap", "Back"};
    public static final String ROTATE_0 = "0";
    public static final String ROTATE_90 = "90";
    public static final String ROTATE_180 = "180";
    public static final String ROTATE_270 = "270";
    public static final int ANCHOR_SW = 0;
    public static final int ANCHOR_SE = 1;
    public static final int ANCHOR_NW = 2;
    public static final int ANCHOR_NE = 3;
    private int mode = 0;
    private int rotate = 0;
    private int anchor = 0;
    private boolean silent = false;
    private boolean supportMode = false;
    private boolean entityMode = false;
    private boolean loopMode = false;
    private int powered = 0;
    private boolean boxValid = false;
    private Coordinate minBox = null;
    private Coordinate maxBox = null;
    private Coordinate scan = null;
    private int projDx;
    private int projDy;
    private int projDz;

    public BuilderTileEntity() {
        super(SpaceProjectorConfiguration.BUILDER_MAXENERGY, SpaceProjectorConfiguration.BUILDER_RECEIVEPERTICK);
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return COMPONENT_NAME;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"hasCard", "getMode", CMD_SETMODE, "getRotate", CMD_SETROTATE, "getAnchor", CMD_SETANCHOR, "getSupportMode", "setSupportMode", "getEntityMode", "setEntityMode", "getLoopMode", "setLoopMode"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.hasCard() != null};
            }
            case 1: {
                return new Object[]{this.getMode()};
            }
            case 2: {
                this.setMode(((Double)arguments[0]).intValue());
                return null;
            }
            case 3: {
                return new Object[]{this.getRotate()};
            }
            case 4: {
                this.setRotate(((Double)arguments[0]).intValue());
                return null;
            }
            case 5: {
                return new Object[]{this.getAnchor()};
            }
            case 6: {
                this.setAnchor(((Double)arguments[0]).intValue());
                return null;
            }
            case 7: {
                return new Object[]{this.hasSupportMode()};
            }
            case 8: {
                this.setSupportMode(((Double)arguments[0]).intValue() > 0);
                return null;
            }
            case 9: {
                return new Object[]{this.hasEntityMode()};
            }
            case 10: {
                this.setEntityMode(((Double)arguments[0]).intValue() > 0);
                return null;
            }
            case 11: {
                return new Object[]{this.hasLoopMode()};
            }
            case 12: {
                this.setLoopMode(((Double)arguments[0]).intValue() > 0);
                return null;
            }
        }
        return new Object[0];
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return false;
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] hasCard(Context context, Arguments args) throws Exception {
        return new Object[]{this.hasCard() != null};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getMode(Context context, Arguments args) throws Exception {
        return new Object[]{this.getMode()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setMode(Context context, Arguments args) throws Exception {
        int mode = args.checkInteger(0);
        this.setMode(mode);
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getRotate(Context context, Arguments args) throws Exception {
        return new Object[]{this.getRotate()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setRotate(Context context, Arguments args) throws Exception {
        Integer angle = args.checkInteger(0);
        this.setRotate(angle);
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getAnchor(Context context, Arguments args) throws Exception {
        return new Object[]{this.getAnchor()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setAnchor(Context context, Arguments args) throws Exception {
        Integer angle = args.checkInteger(0);
        this.setAnchor(angle);
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getSupportMode(Context context, Arguments args) throws Exception {
        return new Object[]{this.hasSupportMode()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setSupportMode(Context context, Arguments args) throws Exception {
        boolean support = args.checkBoolean(0);
        this.setSupportMode(support);
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getEntityMode(Context context, Arguments args) throws Exception {
        return new Object[]{this.hasEntityMode()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setEntityMode(Context context, Arguments args) throws Exception {
        boolean ent = args.checkBoolean(0);
        this.setEntityMode(ent);
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getLoopMode(Context context, Arguments args) throws Exception {
        return new Object[]{this.hasLoopMode()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setLoopMode(Context context, Arguments args) throws Exception {
        boolean ent = args.checkBoolean(0);
        this.setLoopMode(ent);
        return null;
    }

    private NBTTagCompound hasCard() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack == null || itemStack.field_77994_a == 0) {
            return null;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        return tagCompound;
    }

    private void makeSupportBlocks() {
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel != null) {
            int dimension = chamberChannel.getDimension();
            WorldServer world = DimensionManager.getWorld((int)dimension);
            if (world == null) {
                return;
            }
            for (int x = this.minBox.getX(); x <= this.maxBox.getX(); ++x) {
                for (int y = this.minBox.getY(); y <= this.maxBox.getY(); ++y) {
                    for (int z = this.minBox.getZ(); z <= this.maxBox.getZ(); ++z) {
                        Coordinate src = new Coordinate(x, y, z);
                        Coordinate dest = this.sourceToDest(src);
                        Block srcBlock = world.func_147439_a(src.getX(), src.getY(), src.getZ());
                        Block dstBlock = this.field_145850_b.func_147439_a(dest.getX(), dest.getY(), dest.getZ());
                        int error = 0;
                        if (this.mode != 0) {
                            TileEntity srcTileEntity = world.func_147438_o(src.getX(), src.getY(), src.getZ());
                            TileEntity dstTileEntity = this.field_145850_b.func_147438_o(dest.getX(), dest.getY(), dest.getZ());
                            int error1 = this.isMovable(srcBlock, srcTileEntity);
                            int error2 = this.isMovable(dstBlock, dstTileEntity);
                            error = Math.max(error1, error2);
                        }
                        if (BuilderTileEntity.isEmpty(srcBlock) && !BuilderTileEntity.isEmpty(dstBlock)) {
                            world.func_147465_d(src.getX(), src.getY(), src.getZ(), (Block)SpaceProjectorSetup.supportBlock, error, 3);
                            world.func_72921_c(src.getX(), src.getY(), src.getZ(), error, 3);
                        }
                        if (!BuilderTileEntity.isEmpty(dstBlock) || BuilderTileEntity.isEmpty(srcBlock)) continue;
                        this.field_145850_b.func_147465_d(dest.getX(), dest.getY(), dest.getZ(), (Block)SpaceProjectorSetup.supportBlock, error, 3);
                        this.field_145850_b.func_72921_c(dest.getX(), dest.getY(), dest.getZ(), error, 3);
                    }
                }
            }
        }
    }

    public void clearSupportBlocks() {
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel != null) {
            int dimension = chamberChannel.getDimension();
            WorldServer world = DimensionManager.getWorld((int)dimension);
            for (int x = this.minBox.getX(); x <= this.maxBox.getX(); ++x) {
                for (int y = this.minBox.getY(); y <= this.maxBox.getY(); ++y) {
                    for (int z = this.minBox.getZ(); z <= this.maxBox.getZ(); ++z) {
                        Coordinate dest;
                        Block dstBlock;
                        Block srcBlock;
                        Coordinate src = new Coordinate(x, y, z);
                        if (world != null && (srcBlock = world.func_147439_a(src.getX(), src.getY(), src.getZ())) == SpaceProjectorSetup.supportBlock) {
                            world.func_147468_f(src.getX(), src.getY(), src.getZ());
                        }
                        if ((dstBlock = this.field_145850_b.func_147439_a((dest = this.sourceToDest(src)).getX(), dest.getY(), dest.getZ())) != SpaceProjectorSetup.supportBlock) continue;
                        this.field_145850_b.func_147468_f(dest.getX(), dest.getY(), dest.getZ());
                    }
                }
            }
        }
    }

    public boolean hasLoopMode() {
        return this.loopMode;
    }

    public void setLoopMode(boolean loopMode) {
        this.loopMode = loopMode;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean hasEntityMode() {
        return this.entityMode;
    }

    public void setEntityMode(boolean entityMode) {
        this.entityMode = entityMode;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean hasSupportMode() {
        return this.supportMode;
    }

    public void setSupportMode(boolean supportMode) {
        this.supportMode = supportMode;
        if (supportMode) {
            this.makeSupportBlocks();
        } else {
            this.clearSupportBlocks();
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode != this.mode) {
            this.mode = mode;
            this.restartScan();
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int anchor) {
        if (this.supportMode) {
            this.clearSupportBlocks();
        }
        this.anchor = anchor;
        if (this.supportMode) {
            this.makeSupportBlocks();
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getRotate() {
        return this.rotate;
    }

    public void setRotate(int rotate) {
        if (this.supportMode) {
            this.clearSupportBlocks();
        }
        this.boxValid = false;
        this.rotate = rotate;
        if (this.supportMode) {
            this.makeSupportBlocks();
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setPowered(int powered) {
        if (this.powered != powered) {
            this.powered = powered;
            if (this.loopMode || powered > 0 && this.scan == null) {
                this.restartScan();
            }
            this.func_70296_d();
        }
    }

    private Coordinate rotate(Coordinate c) {
        switch (this.rotate) {
            case 0: {
                return c;
            }
            case 1: {
                return new Coordinate(-c.getZ(), c.getY(), c.getX());
            }
            case 2: {
                return new Coordinate(-c.getX(), c.getY(), -c.getZ());
            }
            case 3: {
                return new Coordinate(c.getZ(), c.getY(), -c.getX());
            }
        }
        return c;
    }

    private void createProjection(SpaceChamberRepository.SpaceChamberChannel chamberChannel) {
        Coordinate minC = this.rotate(chamberChannel.getMinCorner());
        Coordinate maxC = this.rotate(chamberChannel.getMaxCorner());
        Coordinate minCorner = new Coordinate(Math.min(minC.getX(), maxC.getX()), Math.min(minC.getY(), maxC.getY()), Math.min(minC.getZ(), maxC.getZ()));
        Coordinate maxCorner = new Coordinate(Math.max(minC.getX(), maxC.getX()), Math.max(minC.getY(), maxC.getY()), Math.max(minC.getZ(), maxC.getZ()));
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ForgeDirection direction = BlockTools.getOrientationHoriz((int)meta);
        int spanX = maxCorner.getX() - minCorner.getX();
        int spanY = maxCorner.getY() - minCorner.getY();
        int spanZ = maxCorner.getZ() - minCorner.getZ();
        switch (direction) {
            case SOUTH: {
                this.projDx = this.field_145851_c + ForgeDirection.NORTH.offsetX - minCorner.getX() - (this.anchor == 3 || this.anchor == 1 ? spanX : 0);
                this.projDz = this.field_145849_e + ForgeDirection.NORTH.offsetZ - minCorner.getZ() - spanZ;
                break;
            }
            case NORTH: {
                this.projDx = this.field_145851_c + ForgeDirection.SOUTH.offsetX - minCorner.getX() - spanX + (this.anchor == 3 || this.anchor == 1 ? spanX : 0);
                this.projDz = this.field_145849_e + ForgeDirection.SOUTH.offsetZ - minCorner.getZ();
                break;
            }
            case WEST: {
                this.projDx = this.field_145851_c + ForgeDirection.EAST.offsetX - minCorner.getX();
                this.projDz = this.field_145849_e + ForgeDirection.EAST.offsetZ - minCorner.getZ() - (this.anchor == 3 || this.anchor == 1 ? spanZ : 0);
                break;
            }
            case EAST: {
                this.projDx = this.field_145851_c + ForgeDirection.WEST.offsetX - minCorner.getX() - spanX;
                this.projDz = this.field_145849_e + ForgeDirection.WEST.offsetZ - minCorner.getZ() - spanZ + (this.anchor == 3 || this.anchor == 1 ? spanZ : 0);
                break;
            }
        }
        this.projDy = this.field_145848_d - minCorner.getY() - (this.anchor == 3 || this.anchor == 2 ? spanY : 0);
    }

    private void calculateBox(NBTTagCompound cardCompound) {
        int channel = cardCompound.func_74762_e("channel");
        SpaceChamberRepository repository = SpaceChamberRepository.getChannels(this.field_145850_b);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        Coordinate minCorner = chamberChannel.getMinCorner();
        Coordinate maxCorner = chamberChannel.getMaxCorner();
        if (minCorner == null || maxCorner == null) {
            return;
        }
        if (this.boxValid && minCorner.equals((Object)this.minBox) && maxCorner.equals((Object)this.maxBox)) {
            return;
        }
        this.boxValid = true;
        this.createProjection(chamberChannel);
        this.minBox = minCorner;
        this.maxBox = maxCorner;
        this.restartScan();
    }

    private void restartScan() {
        if (this.loopMode || this.powered > 0 && this.scan == null) {
            this.calculateBox();
            this.scan = this.minBox;
        } else {
            this.scan = null;
        }
    }

    protected void checkStateServer() {
        if (this.powered == 0 && this.loopMode) {
            return;
        }
        if (this.scan == null) {
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel == null) {
            this.scan = null;
            this.func_70296_d();
            return;
        }
        int dimension = chamberChannel.getDimension();
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world == null) {
            return;
        }
        float factor = this.getInfusedFactor();
        int i = 0;
        while ((float)i < 1.0f + factor * 20.0f) {
            if (this.scan != null) {
                this.handleBlock((World)world);
            }
            ++i;
        }
    }

    private SpaceChamberRepository.SpaceChamberChannel calculateBox() {
        NBTTagCompound tc = this.hasCard();
        if (tc == null) {
            return null;
        }
        int channel = tc.func_74762_e("channel");
        if (channel == -1) {
            return null;
        }
        SpaceChamberRepository repository = SpaceChamberRepository.getChannels(this.field_145850_b);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        if (chamberChannel == null) {
            return null;
        }
        this.calculateBox(tc);
        if (!this.boxValid) {
            return null;
        }
        return chamberChannel;
    }

    private void handleBlock(World world) {
        Coordinate dest = this.sourceToDest(this.scan);
        int x = this.scan.getX();
        int y = this.scan.getY();
        int z = this.scan.getZ();
        int destX = dest.getX();
        int destY = dest.getY();
        int destZ = dest.getZ();
        switch (this.mode) {
            case 0: {
                this.copyBlock(world, x, y, z, this.field_145850_b, destX, destY, destZ);
                break;
            }
            case 1: {
                if (this.entityMode) {
                    this.moveEntities(world, x, y, z, this.field_145850_b, destX, destY, destZ);
                }
                this.moveBlock(world, x, y, z, this.field_145850_b, destX, destY, destZ, this.rotate);
                break;
            }
            case 3: {
                if (this.entityMode) {
                    this.moveEntities(this.field_145850_b, destX, destY, destZ, world, x, y, z);
                }
                this.moveBlock(this.field_145850_b, destX, destY, destZ, world, x, y, z, this.oppositeRotate());
                break;
            }
            case 2: {
                if (this.entityMode) {
                    this.swapEntities(world, x, y, z, this.field_145850_b, destX, destY, destZ);
                }
                this.swapBlock(world, x, y, z, this.field_145850_b, destX, destY, destZ);
            }
        }
        this.nextLocation();
    }

    private boolean findAndConsumeBlock(IInventory inventory, Block block, int meta) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0 || !(stack.func_77973_b() instanceof ItemBlock)) continue;
            ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
            if (itemBlock.field_150939_a != block || meta != -1 && stack.func_77960_j() != meta) continue;
            inventory.func_70298_a(i, 1);
            return true;
        }
        return false;
    }

    private boolean consumeBlock(Block block, int meta) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (te instanceof IInventory && this.findAndConsumeBlock((IInventory)te, block, meta)) {
            return true;
        }
        te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        return te instanceof IInventory && this.findAndConsumeBlock((IInventory)te, block, meta);
    }

    public static SpaceProjectorSetup.BlockInformation getBlockInformation(Block block, TileEntity tileEntity) {
        if (BuilderTileEntity.isEmpty(block)) {
            return SpaceProjectorSetup.BlockInformation.FREE;
        }
        SpaceProjectorSetup.BlockInformation blockInformation = SpaceProjectorSetup.getBlockInformation(block);
        if (tileEntity != null) {
            switch (SpaceProjectorConfiguration.teMode) {
                case MOVE_FORBIDDEN: {
                    return SpaceProjectorSetup.BlockInformation.INVALID;
                }
                case MOVE_WHITELIST: {
                    if (blockInformation != null && blockInformation.getBlockLevel() != 2) break;
                    return SpaceProjectorSetup.BlockInformation.INVALID;
                }
                case MOVE_BLACKLIST: {
                    if (blockInformation == null || blockInformation.getBlockLevel() != 2) break;
                    return SpaceProjectorSetup.BlockInformation.INVALID;
                }
            }
        }
        if (blockInformation != null) {
            return blockInformation;
        }
        return SpaceProjectorSetup.BlockInformation.OK;
    }

    private int isMovable(Block block, TileEntity tileEntity) {
        return BuilderTileEntity.getBlockInformation(block, tileEntity).getBlockLevel();
    }

    public static boolean isEmpty(Block block) {
        if (block == null) {
            return true;
        }
        if (block.func_149688_o() == Material.field_151579_a) {
            return true;
        }
        return block == SpaceProjectorSetup.supportBlock;
    }

    private void clearBlock(World world, int x, int y, int z) {
        if (this.supportMode) {
            world.func_147465_d(x, y, z, (Block)SpaceProjectorSetup.supportBlock, 0, 3);
        } else {
            world.func_147468_f(x, y, z);
        }
    }

    private int oppositeRotate() {
        switch (this.rotate) {
            case 1: {
                return 3;
            }
            case 3: {
                return 1;
            }
        }
        return this.rotate;
    }

    private int rotateMeta(int meta, SpaceProjectorSetup.BlockInformation information, int rotMode) {
        switch (information.getRotateInfo()) {
            case 1: {
                switch (rotMode) {
                    case 0: {
                        return meta;
                    }
                    case 1: {
                        ForgeDirection dir = ForgeDirection.values()[meta & 7];
                        return meta & 8 | dir.getRotation(ForgeDirection.UP).ordinal();
                    }
                    case 2: {
                        ForgeDirection dir = ForgeDirection.values()[meta & 7];
                        return meta & 8 | dir.getOpposite().ordinal();
                    }
                    case 3: {
                        ForgeDirection dir = ForgeDirection.values()[meta & 7];
                        return meta & 8 | dir.getOpposite().getRotation(ForgeDirection.UP).ordinal();
                    }
                }
                break;
            }
            case 0: {
                return meta;
            }
        }
        return meta;
    }

    private void copyBlock(World world, int x, int y, int z, World destWorld, int destX, int destY, int destZ) {
        int rf = this.getEnergyStored(ForgeDirection.DOWN);
        int rfNeeded = (int)((double)SpaceProjectorConfiguration.builderRfPerOperation * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        if (rfNeeded > rf) {
            return;
        }
        Block destBlock = destWorld.func_147439_a(destX, destY, destZ);
        if (BuilderTileEntity.isEmpty(destBlock)) {
            Block origBlock = world.func_147439_a(x, y, z);
            int origMeta = world.func_72805_g(x, y, z);
            if (origBlock == null || origBlock.func_149688_o() == Material.field_151579_a) {
                return;
            }
            if (!this.consumeBlock(origBlock, origMeta)) {
                return;
            }
            SpaceProjectorSetup.BlockInformation information = BuilderTileEntity.getBlockInformation(origBlock, null);
            origMeta = this.rotateMeta(origMeta, information, this.rotate);
            destWorld.func_147465_d(destX, destY, destZ, origBlock, origMeta, 3);
            destWorld.func_72921_c(destX, destY, destZ, origMeta, 3);
            if (!this.silent) {
                RFToolsTools.playSound(destWorld, origBlock.field_149762_H.func_150495_a(), destX, destY, destZ, 1.0, 1.0);
            }
            this.consumeEnergy(rfNeeded);
        }
    }

    private double getDimensionCostFactor(World world, World destWorld) {
        return destWorld.field_73011_w.field_76574_g == world.field_73011_w.field_76574_g ? 1.0 : SpaceProjectorConfiguration.dimensionCostFactor;
    }

    private boolean consumeEntityEnergy(int rfNeeded, int rfNeededPlayer, Entity entity) {
        int rf;
        int rfn = entity instanceof EntityPlayer ? rfNeededPlayer : rfNeeded;
        if (rfn > (rf = this.getEnergyStored(ForgeDirection.DOWN))) {
            return true;
        }
        this.consumeEnergy(rfn);
        return false;
    }

    private void moveEntities(World world, int x, int y, int z, World destWorld, int destX, int destY, int destZ) {
        int rfNeeded = (int)((double)SpaceProjectorConfiguration.builderRfPerEntity * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        int rfNeededPlayer = (int)((double)SpaceProjectorConfiguration.builderRfPerPlayer * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        List entities = world.func_72839_b(null, AxisAlignedBB.func_72330_a((double)((double)x - 0.1), (double)((double)y - 0.1), (double)((double)z - 0.1), (double)((double)x + 1.1), (double)((double)y + 1.1), (double)((double)z + 1.1)));
        for (Object o : entities) {
            Entity entity = (Entity)o;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            double newX = (double)destX + (entity.field_70165_t - (double)x);
            double newY = (double)destY + (entity.field_70163_u - (double)y);
            double newZ = (double)destZ + (entity.field_70161_v - (double)z);
            this.teleportEntity(world, destWorld, entity, newX, newY, newZ);
        }
    }

    private void swapEntities(World world, int x, int y, int z, World destWorld, int destX, int destY, int destZ) {
        double newZ;
        double newY;
        double newX;
        Entity entity;
        int rfNeeded = (int)((double)SpaceProjectorConfiguration.builderRfPerEntity * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        int rfNeededPlayer = (int)((double)SpaceProjectorConfiguration.builderRfPerPlayer * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        List entitiesSrc = world.func_72839_b(null, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        List entitiesDst = destWorld.func_72839_b(null, AxisAlignedBB.func_72330_a((double)destX, (double)destY, (double)destZ, (double)(destX + 1), (double)(destY + 1), (double)(destZ + 1)));
        for (Object o : entitiesSrc) {
            entity = (Entity)o;
            if (!this.isEntityInBlock(x, y, z, entity)) continue;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            newX = (double)destX + (entity.field_70165_t - (double)x);
            newY = (double)destY + (entity.field_70163_u - (double)y);
            newZ = (double)destZ + (entity.field_70161_v - (double)z);
            this.teleportEntity(world, destWorld, entity, newX, newY, newZ);
        }
        for (Object o : entitiesDst) {
            entity = (Entity)o;
            if (!this.isEntityInBlock(destX, destY, destZ, entity)) continue;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            newX = (double)x + (entity.field_70165_t - (double)destX);
            newY = (double)y + (entity.field_70163_u - (double)destY);
            newZ = (double)z + (entity.field_70161_v - (double)destZ);
            this.teleportEntity(destWorld, world, entity, newX, newY, newZ);
        }
    }

    private void teleportEntity(World world, World destWorld, Entity entity, double newX, double newY, double newZ) {
        if (entity instanceof EntityPlayer) {
            if (world.field_73011_w.field_76574_g != destWorld.field_73011_w.field_76574_g) {
                TeleportationTools.teleportToDimension((EntityPlayer)entity, destWorld.field_73011_w.field_76574_g, newX, newY, newZ);
            }
            ((EntityPlayer)entity).func_70634_a(newX, newY, newZ);
        } else {
            if (world.field_73011_w.field_76574_g != destWorld.field_73011_w.field_76574_g) {
                MinecraftServer.func_71276_C().func_71203_ab().transferEntityToWorld(entity, destWorld.field_73011_w.field_76574_g, (WorldServer)world, (WorldServer)destWorld, (Teleporter)new RfToolsTeleporter((WorldServer)destWorld, newX, newY, newZ));
            }
            entity.func_70107_b(newX, newY, newZ);
        }
    }

    private boolean isEntityInBlock(int x, int y, int z, Entity entity) {
        return entity.field_70165_t >= (double)x && entity.field_70165_t < (double)(x + 1) && entity.field_70163_u >= (double)y && entity.field_70163_u < (double)(y + 1) && entity.field_70161_v >= (double)z && entity.field_70161_v < (double)(z + 1);
    }

    private void moveBlock(World world, int x, int y, int z, World destWorld, int destX, int destY, int destZ, int rotMode) {
        Block destBlock = destWorld.func_147439_a(destX, destY, destZ);
        if (BuilderTileEntity.isEmpty(destBlock)) {
            Block origBlock = world.func_147439_a(x, y, z);
            if (BuilderTileEntity.isEmpty(origBlock)) {
                return;
            }
            TileEntity origTileEntity = world.func_147438_o(x, y, z);
            SpaceProjectorSetup.BlockInformation information = BuilderTileEntity.getBlockInformation(origBlock, origTileEntity);
            if (information.getBlockLevel() == 2) {
                return;
            }
            int rf = this.getEnergyStored(ForgeDirection.DOWN);
            int rfNeeded = (int)((double)SpaceProjectorConfiguration.builderRfPerOperation * this.getDimensionCostFactor(world, destWorld) * information.getCostFactor() * (double)(4.0f - this.getInfusedFactor()) / 4.0);
            if (rfNeeded > rf) {
                return;
            }
            this.consumeEnergy(rfNeeded);
            int origMeta = world.func_72805_g(x, y, z);
            origMeta = this.rotateMeta(origMeta, information, rotMode);
            world.func_147475_p(x, y, z);
            this.clearBlock(world, x, y, z);
            destWorld.func_147465_d(destX, destY, destZ, origBlock, origMeta, 3);
            destWorld.func_72921_c(destX, destY, destZ, origMeta, 3);
            if (origTileEntity != null) {
                origTileEntity.func_145829_t();
                destWorld.func_147455_a(destX, destY, destZ, origTileEntity);
                origTileEntity.func_70296_d();
                destWorld.func_147471_g(destX, destY, destZ);
            }
            if (!this.silent) {
                RFToolsTools.playSound(world, origBlock.field_149762_H.func_150495_a(), x, y, z, 1.0, 1.0);
                RFToolsTools.playSound(destWorld, origBlock.field_149762_H.func_150495_a(), destX, destY, destZ, 1.0, 1.0);
            }
        }
    }

    private void swapBlock(World world, int x, int y, int z, World destWorld, int destX, int destY, int destZ) {
        Block srcBlock = world.func_147439_a(x, y, z);
        TileEntity srcTileEntity = world.func_147438_o(x, y, z);
        Block dstBlock = destWorld.func_147439_a(destX, destY, destZ);
        TileEntity dstTileEntity = destWorld.func_147438_o(destX, destY, destZ);
        if (BuilderTileEntity.isEmpty(srcBlock) && BuilderTileEntity.isEmpty(dstBlock)) {
            return;
        }
        SpaceProjectorSetup.BlockInformation srcInformation = BuilderTileEntity.getBlockInformation(srcBlock, srcTileEntity);
        if (srcInformation.getBlockLevel() == 2) {
            return;
        }
        SpaceProjectorSetup.BlockInformation dstInformation = BuilderTileEntity.getBlockInformation(dstBlock, dstTileEntity);
        if (dstInformation.getBlockLevel() == 2) {
            return;
        }
        int rf = this.getEnergyStored(ForgeDirection.DOWN);
        int rfNeeded = (int)((double)SpaceProjectorConfiguration.builderRfPerOperation * this.getDimensionCostFactor(world, destWorld) * srcInformation.getCostFactor() * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        if ((rfNeeded += (int)((double)SpaceProjectorConfiguration.builderRfPerOperation * this.getDimensionCostFactor(world, destWorld) * dstInformation.getCostFactor() * (double)(4.0f - this.getInfusedFactor()) / 4.0)) > rf) {
            return;
        }
        this.consumeEnergy(rfNeeded);
        int srcMeta = world.func_72805_g(x, y, z);
        srcMeta = this.rotateMeta(srcMeta, srcInformation, this.oppositeRotate());
        int dstMeta = destWorld.func_72805_g(destX, destY, destZ);
        dstMeta = this.rotateMeta(dstMeta, dstInformation, this.rotate);
        world.func_147475_p(x, y, z);
        world.func_147468_f(x, y, z);
        destWorld.func_147475_p(destX, destY, destZ);
        destWorld.func_147468_f(destX, destY, destZ);
        destWorld.func_147465_d(destX, destY, destZ, srcBlock, srcMeta, 3);
        destWorld.func_72921_c(destX, destY, destZ, srcMeta, 3);
        if (srcTileEntity != null) {
            srcTileEntity.func_145829_t();
            destWorld.func_147455_a(destX, destY, destZ, srcTileEntity);
            srcTileEntity.func_70296_d();
            destWorld.func_147471_g(destX, destY, destZ);
        }
        world.func_147465_d(x, y, z, dstBlock, dstMeta, 3);
        world.func_72921_c(x, y, z, dstMeta, 3);
        if (dstTileEntity != null) {
            dstTileEntity.func_145829_t();
            world.func_147455_a(x, y, z, dstTileEntity);
            dstTileEntity.func_70296_d();
            world.func_147471_g(x, y, z);
        }
        if (!this.silent) {
            if (!BuilderTileEntity.isEmpty(srcBlock)) {
                RFToolsTools.playSound(world, srcBlock.field_149762_H.func_150495_a(), x, y, z, 1.0, 1.0);
            }
            if (!BuilderTileEntity.isEmpty(dstBlock)) {
                RFToolsTools.playSound(destWorld, dstBlock.field_149762_H.func_150495_a(), destX, destY, destZ, 1.0, 1.0);
            }
        }
    }

    private Coordinate sourceToDest(Coordinate source) {
        Coordinate c = this.rotate(source);
        return new Coordinate(c.getX() + this.projDx, c.getY() + this.projDy, c.getZ() + this.projDz);
    }

    private void nextLocation() {
        if (this.scan != null) {
            int x = this.scan.getX();
            int y = this.scan.getY();
            int z = this.scan.getZ();
            if (x >= this.maxBox.getX()) {
                if (z >= this.maxBox.getZ()) {
                    if (y >= this.maxBox.getY()) {
                        if (this.mode != 2) {
                            this.restartScan();
                        } else {
                            this.scan = null;
                        }
                    } else {
                        this.scan = new Coordinate(this.minBox.getX(), y + 1, this.minBox.getZ());
                    }
                } else {
                    this.scan = new Coordinate(this.minBox.getX(), y, z + 1);
                }
            } else {
                this.scan = new Coordinate(x + 1, y, z);
            }
        }
    }

    public int[] func_94128_d(int side) {
        return BuilderContainer.factory.getAccessibleSlots();
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return BuilderContainer.factory.isInputSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return BuilderContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Builder";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powered = tagCompound.func_74771_c("powered");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        this.mode = tagCompound.func_74762_e("mode");
        this.anchor = tagCompound.func_74762_e("anchor");
        this.rotate = tagCompound.func_74762_e("rotate");
        this.silent = tagCompound.func_74767_n("silent");
        this.supportMode = tagCompound.func_74767_n("support");
        this.entityMode = tagCompound.func_74767_n("entityMode");
        this.loopMode = tagCompound.func_74767_n("loopMode");
        this.scan = Coordinate.readFromNBT((NBTTagCompound)tagCompound, (String)"scan");
        this.minBox = Coordinate.readFromNBT((NBTTagCompound)tagCompound, (String)"minBox");
        this.maxBox = Coordinate.readFromNBT((NBTTagCompound)tagCompound, (String)"maxBox");
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74774_a("powered", (byte)this.powered);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74768_a("mode", this.mode);
        tagCompound.func_74768_a("anchor", this.anchor);
        tagCompound.func_74768_a("rotate", this.rotate);
        tagCompound.func_74757_a("silent", this.silent);
        tagCompound.func_74757_a("support", this.supportMode);
        tagCompound.func_74757_a("entityMode", this.entityMode);
        tagCompound.func_74757_a("loopMode", this.loopMode);
        Coordinate.writeToNBT((NBTTagCompound)tagCompound, (String)"scan", (Coordinate)this.scan);
        Coordinate.writeToNBT((NBTTagCompound)tagCompound, (String)"minBox", (Coordinate)this.minBox);
        Coordinate.writeToNBT((NBTTagCompound)tagCompound, (String)"maxBox", (Coordinate)this.maxBox);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            this.setMode(args.get("mode").getInteger());
            return true;
        }
        if (CMD_SETANCHOR.equals(command)) {
            this.setAnchor(args.get("anchor").getInteger());
            return true;
        }
        if (CMD_SETROTATE.equals(command)) {
            this.setRotate(args.get("rotate").getInteger());
            return true;
        }
        if (CMD_SETSILENT.equals(command)) {
            this.setSilent(args.get("silent").getBoolean());
            return true;
        }
        if (CMD_SETSUPPORT.equals(command)) {
            this.setSupportMode(args.get("support").getBoolean());
            return true;
        }
        if (CMD_SETENTITIES.equals(command)) {
            this.setEntityMode(args.get("entities").getBoolean());
            return true;
        }
        if (CMD_SETLOOP.equals(command)) {
            this.setLoopMode(args.get("loop").getBoolean());
            return true;
        }
        return false;
    }
}

