/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.entity.SyncedObject;
import mcjty.entity.SyncedValueList;
import mcjty.network.Argument;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.shield.AbstractShieldBlock;
import mcjty.rftools.blocks.shield.DamageTypeMode;
import mcjty.rftools.blocks.shield.GuiShield;
import mcjty.rftools.blocks.shield.ShieldBlockTileEntity;
import mcjty.rftools.blocks.shield.ShieldConfiguration;
import mcjty.rftools.blocks.shield.ShieldRenderingMode;
import mcjty.rftools.blocks.shield.ShieldSetup;
import mcjty.rftools.blocks.shield.filters.AbstractShieldFilter;
import mcjty.rftools.blocks.shield.filters.PlayerFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import mcjty.varia.BlockTools;
import mcjty.varia.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")})
public class ShieldTEBase
extends GenericEnergyReceiverTileEntity
implements IInventory,
SimpleComponent,
IPeripheral {
    public static final String CMD_SHIELDVISMODE = "shieldVisMode";
    public static final String CMD_APPLYCAMO = "applyCamo";
    public static final String CMD_DAMAGEMODE = "damageMode";
    public static final String CMD_RSMODE = "rsMode";
    public static final String CMD_ADDFILTER = "addFilter";
    public static final String CMD_DELFILTER = "delFilter";
    public static final String CMD_UPFILTER = "upFilter";
    public static final String CMD_DOWNFILTER = "downFilter";
    public static final String CMD_GETFILTERS = "getFilters";
    public static final String CMD_SETCOLOR = "setColor";
    public static final String CLIENTCMD_GETFILTERS = "getFilters";
    public static final String COMPONENT_NAME = "shield_projector";
    private RedstoneMode redstoneMode = RedstoneMode.REDSTONE_IGNORED;
    private DamageTypeMode damageMode = DamageTypeMode.DAMAGETYPE_GENERIC;
    private boolean shieldComposed = false;
    private int templateMeta = 0;
    private boolean shieldActive = false;
    private int powerTimeout = 0;
    private int shieldColor;
    private int camoRenderPass = 0;
    private int supportedBlocks;
    private float damageFactor = 1.0f;
    private float costFactor = 1.0f;
    private final List<ShieldFilter> filters = new ArrayList<ShieldFilter>();
    private ShieldRenderingMode shieldRenderingMode = ShieldRenderingMode.MODE_SHIELD;
    private SyncedValueList<Coordinate> shieldBlocks = new SyncedValueList<Coordinate>(){

        public Coordinate readElementFromNBT(NBTTagCompound tagCompound) {
            return Coordinate.readFromNBT((NBTTagCompound)tagCompound, (String)"c");
        }

        public NBTTagCompound writeElementToNBT(Coordinate element) {
            return Coordinate.writeToNBT((Coordinate)element);
        }
    };
    private ItemStack[] stacks = new ItemStack[1];

    public ShieldTEBase(int maxEnergy, int maxReceive) {
        super(maxEnergy, maxReceive);
        this.registerSyncedObject((SyncedObject)this.shieldBlocks);
    }

    public void setSupportedBlocks(int supportedBlocks) {
        this.supportedBlocks = supportedBlocks;
    }

    public void setDamageFactor(float factor) {
        this.damageFactor = factor;
    }

    public void setCostFactor(float factor) {
        this.costFactor = factor;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return COMPONENT_NAME;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getDamageMode", "setDamageMode", "getRedstoneMode", "setRedstoneMode", "getShieldRenderingMode", "setShieldRenderingMode", "isShieldActive", "isShieldComposed", "composeShield", "composeShieldDsc", "decomposeShield"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.getDamageMode().getDescription()};
            }
            case 1: {
                return this.setDamageMode((String)arguments[0]);
            }
            case 2: {
                return new Object[]{this.getRedstoneMode().getDescription()};
            }
            case 3: {
                return this.setRedstoneMode((String)arguments[0]);
            }
            case 4: {
                return new Object[]{this.getShieldRenderingMode().getDescription()};
            }
            case 5: {
                return this.setShieldRenderingMode((String)arguments[0]);
            }
            case 6: {
                return new Object[]{this.isShieldActive()};
            }
            case 7: {
                return new Object[]{this.isShieldComposed()};
            }
            case 8: {
                return this.composeShieldComp(false);
            }
            case 9: {
                return this.composeShieldComp(true);
            }
            case 10: {
                return this.decomposeShieldComp();
            }
        }
        return new Object[0];
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return false;
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getDamageMode(Context context, Arguments args) throws Exception {
        return new Object[]{this.getDamageMode().getDescription()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setDamageMode(Context context, Arguments args) throws Exception {
        String mode = args.checkString(0);
        return this.setDamageMode(mode);
    }

    private Object[] setDamageMode(String mode) {
        DamageTypeMode damageMode = DamageTypeMode.getMode(mode);
        if (damageMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setDamageMode(damageMode);
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getRedstoneMode(Context context, Arguments args) throws Exception {
        return new Object[]{this.getRedstoneMode().getDescription()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setRedstoneMode(Context context, Arguments args) throws Exception {
        String mode = args.checkString(0);
        return this.setRedstoneMode(mode);
    }

    private Object[] setRedstoneMode(String mode) {
        RedstoneMode redstoneMode = RedstoneMode.getMode(mode);
        if (redstoneMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setRedstoneMode(redstoneMode);
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getShieldRenderingMode(Context context, Arguments args) throws Exception {
        return new Object[]{this.getShieldRenderingMode().getDescription()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setShieldRenderingMode(Context context, Arguments args) throws Exception {
        String mode = args.checkString(0);
        return this.setShieldRenderingMode(mode);
    }

    private Object[] setShieldRenderingMode(String mode) {
        ShieldRenderingMode renderingMode = ShieldRenderingMode.getMode(mode);
        if (renderingMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setShieldRenderingMode(renderingMode);
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isShieldActive(Context context, Arguments args) throws Exception {
        return new Object[]{this.isShieldActive()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isShieldComposed(Context context, Arguments args) throws Exception {
        return new Object[]{this.isShieldComposed()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] composeShield(Context context, Arguments args) throws Exception {
        return this.composeShieldComp(false);
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] composeShieldDsc(Context context, Arguments args) throws Exception {
        return this.composeShieldComp(true);
    }

    private Object[] composeShieldComp(boolean ctrl) {
        boolean done = false;
        if (!this.isShieldComposed()) {
            this.composeShield(ctrl);
            done = true;
        }
        return new Object[]{done};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] decomposeShield(Context context, Arguments args) throws Exception {
        return this.decomposeShieldComp();
    }

    private Object[] decomposeShieldComp() {
        boolean done = false;
        if (this.isShieldComposed()) {
            this.decomposeShield();
            done = true;
        }
        return new Object[]{done};
    }

    public List<ShieldFilter> getFilters() {
        return this.filters;
    }

    public int getShieldColor() {
        return this.shieldColor;
    }

    public void setShieldColor(int shieldColor) {
        this.shieldColor = shieldColor;
        this.updateShield();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void delFilter(int selected) {
        this.filters.remove(selected);
        this.updateShield();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void upFilter(int selected) {
        ShieldFilter filter1 = this.filters.get(selected - 1);
        ShieldFilter filter2 = this.filters.get(selected);
        this.filters.set(selected - 1, filter2);
        this.filters.set(selected, filter1);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void downFilter(int selected) {
        ShieldFilter filter1 = this.filters.get(selected);
        ShieldFilter filter2 = this.filters.get(selected + 1);
        this.filters.set(selected, filter2);
        this.filters.set(selected + 1, filter1);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void addFilter(int action, String type, String player, int selected) {
        ShieldFilter filter = AbstractShieldFilter.createFilter(type);
        filter.setAction(action);
        if (filter instanceof PlayerFilter) {
            ((PlayerFilter)filter).setName(player);
        }
        if (selected == -1) {
            this.filters.add(filter);
        } else {
            this.filters.add(selected, filter);
        }
        this.updateShield();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public DamageTypeMode getDamageMode() {
        return this.damageMode;
    }

    public void setDamageMode(DamageTypeMode damageMode) {
        this.damageMode = damageMode;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public ShieldRenderingMode getShieldRenderingMode() {
        return this.shieldRenderingMode;
    }

    public void setShieldRenderingMode(ShieldRenderingMode shieldRenderingMode) {
        this.shieldRenderingMode = shieldRenderingMode;
        if (this.shieldComposed) {
            this.updateShield();
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private int[] calculateCamoId() {
        ItemStack stack = this.stacks[0];
        int camoId = -1;
        int meta = 0;
        int te = 0;
        if (ShieldRenderingMode.MODE_SOLID.equals((Object)this.shieldRenderingMode) && stack != null && stack.func_77973_b() != null) {
            if (!(stack.func_77973_b() instanceof ItemBlock)) {
                return new int[]{camoId, meta, te};
            }
            Block block = ((ItemBlock)stack.func_77973_b()).field_150939_a;
            camoId = Block.func_149682_b((Block)block);
            meta = stack.func_77960_j();
            if (block.hasTileEntity(meta)) {
                te = 1;
            }
        }
        return new int[]{camoId, meta, te};
    }

    private Block calculateShieldBlock() {
        if (!this.shieldActive || this.powerTimeout > 0) {
            return Blocks.field_150350_a;
        }
        if (ShieldRenderingMode.MODE_INVISIBLE.equals((Object)this.shieldRenderingMode)) {
            return ShieldSetup.invisibleShieldBlock;
        }
        return ShieldSetup.solidShieldBlock;
    }

    private int calculateDamageBits() {
        int bits = 0;
        for (ShieldFilter filter : this.filters) {
            if ((filter.getAction() & 2) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                bits |= 1;
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                bits |= 2;
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                bits |= 4;
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                bits |= 8;
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            bits |= 0xF;
        }
        return bits;
    }

    private int calculateShieldCollisionData() {
        int cd = 0;
        for (ShieldFilter filter : this.filters) {
            if ((filter.getAction() & 1) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                cd |= 1;
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                cd |= 2;
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                cd |= 4;
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                cd |= 8;
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            cd |= 0xF;
        }
        return cd;
    }

    private int calculateRfPerTick() {
        if (!this.shieldActive) {
            return 0;
        }
        int rf = ShieldConfiguration.rfBase;
        if (ShieldRenderingMode.MODE_SHIELD.equals((Object)this.shieldRenderingMode)) {
            rf += ShieldConfiguration.rfShield;
        } else if (ShieldRenderingMode.MODE_SOLID.equals((Object)this.shieldRenderingMode)) {
            rf += ShieldConfiguration.rfCamo;
        }
        return rf;
    }

    public boolean isShieldComposed() {
        return this.shieldComposed;
    }

    public boolean isShieldActive() {
        return this.shieldActive;
    }

    public void applyDamageToEntity(Entity entity) {
        DamageSource source;
        int rf;
        if (DamageTypeMode.DAMAGETYPE_GENERIC.equals((Object)this.damageMode)) {
            rf = ShieldConfiguration.rfDamage;
            source = DamageSource.field_76377_j;
        } else {
            rf = ShieldConfiguration.rfDamagePlayer;
            FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)DimensionManager.getWorld((int)0));
            source = DamageSource.func_76365_a((EntityPlayer)fakePlayer);
        }
        rf = (int)((float)rf * this.costFactor * (4.0f - this.getInfusedFactor()) / 4.0f);
        if (this.getEnergyStored(ForgeDirection.DOWN) < rf) {
            return;
        }
        this.consumeEnergy(rf);
        float damage = ShieldConfiguration.damage;
        damage *= this.damageFactor;
        entity.func_70097_a(source, damage *= 1.0f + this.getInfusedFactor() / 2.0f);
    }

    protected void checkStateServer() {
        super.checkStateServer();
        boolean checkPower = false;
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            this.func_70296_d();
            if (this.powerTimeout > 0) {
                return;
            }
            checkPower = true;
        }
        boolean needsUpdate = false;
        int rf = this.calculateRfPerTick();
        if ((rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f)) > 0) {
            if (this.getEnergyStored(ForgeDirection.DOWN) < rf) {
                this.powerTimeout = 100;
                needsUpdate = true;
            } else {
                if (checkPower) {
                    needsUpdate = true;
                }
                this.consumeEnergy(rf);
            }
        }
        boolean newShieldActive = this.shieldActive;
        if (this.redstoneMode == RedstoneMode.REDSTONE_IGNORED) {
            newShieldActive = true;
        } else {
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            boolean rs = BlockTools.getRedstoneSignal((int)meta);
            if (this.redstoneMode == RedstoneMode.REDSTONE_OFFREQUIRED) {
                newShieldActive = !rs;
            } else if (this.redstoneMode == RedstoneMode.REDSTONE_ONREQUIRED) {
                newShieldActive = rs;
            }
        }
        if (newShieldActive != this.shieldActive) {
            needsUpdate = true;
            this.shieldActive = newShieldActive;
        }
        if (needsUpdate) {
            this.updateShield();
            this.func_70296_d();
        }
    }

    public void composeDecomposeShield(boolean ctrl) {
        if (this.shieldComposed) {
            this.decomposeShield();
        } else {
            this.composeShield(ctrl);
        }
    }

    public void composeShield(boolean ctrl) {
        this.templateMeta = this.findTemplateMeta();
        HashSet<Coordinate> coordinateSet = new HashSet<Coordinate>();
        this.findTemplateBlocks(coordinateSet, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.templateMeta, ctrl);
        this.shieldBlocks.clear();
        for (Coordinate c : coordinateSet) {
            this.shieldBlocks.add((Object)c);
        }
        this.shieldComposed = true;
        this.updateShield();
    }

    private int findTemplateMeta() {
        int meta = -1;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int xx = this.field_145851_c + dir.offsetX;
            int yy = this.field_145848_d + dir.offsetY;
            int zz = this.field_145849_e + dir.offsetZ;
            if (yy < 0 || yy >= this.field_145850_b.func_72800_K() || !((Object)((Object)ShieldSetup.shieldTemplateBlock)).equals(this.field_145850_b.func_147439_a(xx, yy, zz))) continue;
            meta = this.field_145850_b.func_72805_g(xx, yy, zz);
            break;
        }
        return meta;
    }

    private void updateShield() {
        Coordinate thisCoordinate = new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int[] camoId = this.calculateCamoId();
        int cddata = this.calculateShieldCollisionData();
        Block block = this.calculateShieldBlock();
        int damageBits = this.calculateDamageBits();
        for (Coordinate c : this.shieldBlocks) {
            if (Blocks.field_150350_a.equals(block)) {
                this.field_145850_b.func_147468_f(c.getX(), c.getY(), c.getZ());
                continue;
            }
            this.field_145850_b.func_147465_d(c.getX(), c.getY(), c.getZ(), block, camoId[1], 2);
            TileEntity te = this.field_145850_b.func_147438_o(c.getX(), c.getY(), c.getZ());
            if (!(te instanceof ShieldBlockTileEntity)) continue;
            ShieldBlockTileEntity shieldBlockTileEntity = (ShieldBlockTileEntity)te;
            shieldBlockTileEntity.setCamoBlock(camoId[0], camoId[2]);
            shieldBlockTileEntity.setShieldBlock(thisCoordinate);
            shieldBlockTileEntity.setDamageBits(damageBits);
            shieldBlockTileEntity.setCollisionData(cddata);
            shieldBlockTileEntity.setShieldColor(this.shieldColor);
        }
        this.func_70296_d();
        this.notifyBlockUpdate();
    }

    public void decomposeShield() {
        for (Coordinate c : this.shieldBlocks) {
            Block block = this.field_145850_b.func_147439_a(c.getX(), c.getY(), c.getZ());
            if (this.field_145850_b.func_147437_c(c.getX(), c.getY(), c.getZ()) || block instanceof AbstractShieldBlock) {
                this.field_145850_b.func_147465_d(c.getX(), c.getY(), c.getZ(), (Block)ShieldSetup.shieldTemplateBlock, this.templateMeta, 2);
                continue;
            }
            BlockTools.spawnItemStack((World)this.field_145850_b, (int)c.getX(), (int)c.getY(), (int)c.getZ(), (ItemStack)new ItemStack((Block)ShieldSetup.shieldTemplateBlock, 1, this.templateMeta));
        }
        this.shieldComposed = false;
        this.shieldActive = false;
        this.shieldBlocks.clear();
        this.func_70296_d();
        this.notifyBlockUpdate();
    }

    private void findTemplateBlocks(Set<Coordinate> coordinateSet, int x, int y, int z, int meta, boolean ctrl) {
        if (coordinateSet.size() >= this.supportedBlocks) {
            return;
        }
        if (ctrl) {
            for (int xx = x - 1; xx <= x + 1; ++xx) {
                for (int yy = y - 1; yy <= y + 1; ++yy) {
                    for (int zz = z - 1; zz <= z + 1; ++zz) {
                        int m;
                        Coordinate c;
                        if (xx == x && yy == y && zz == z || yy < 0 || yy >= this.field_145850_b.func_72800_K() || coordinateSet.contains(c = new Coordinate(xx, yy, zz)) || !((Object)((Object)ShieldSetup.shieldTemplateBlock)).equals(this.field_145850_b.func_147439_a(xx, yy, zz)) || (m = this.field_145850_b.func_72805_g(xx, yy, zz)) != meta) continue;
                        coordinateSet.add(c);
                        this.findTemplateBlocks(coordinateSet, xx, yy, zz, meta, ctrl);
                    }
                }
            }
        } else {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int m;
                Coordinate c;
                int xx = x + dir.offsetX;
                int yy = y + dir.offsetY;
                int zz = z + dir.offsetZ;
                if (yy < 0 || yy >= this.field_145850_b.func_72800_K() || coordinateSet.contains(c = new Coordinate(xx, yy, zz)) || !((Object)((Object)ShieldSetup.shieldTemplateBlock)).equals(this.field_145850_b.func_147439_a(xx, yy, zz)) || (m = this.field_145850_b.func_72805_g(xx, yy, zz)) != meta) continue;
                coordinateSet.add(c);
                this.findTemplateBlocks(coordinateSet, xx, yy, zz, meta, ctrl);
            }
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.shieldComposed = tagCompound.func_74767_n("composed");
        this.shieldActive = tagCompound.func_74767_n("active");
        this.powerTimeout = tagCompound.func_74762_e("powerTimeout");
        this.templateMeta = tagCompound.func_74762_e("templateMeta");
        this.shieldBlocks.readFromNBT(tagCompound, "coordinates");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        int m = tagCompound.func_74762_e("visMode");
        this.shieldRenderingMode = ShieldRenderingMode.values()[m];
        m = tagCompound.func_74771_c(CMD_RSMODE);
        this.redstoneMode = RedstoneMode.values()[m];
        m = tagCompound.func_74771_c(CMD_DAMAGEMODE);
        this.damageMode = DamageTypeMode.values()[m];
        this.camoRenderPass = tagCompound.func_74762_e("camoRenderPass");
        this.shieldColor = tagCompound.func_74762_e("shieldColor");
        if (this.shieldColor == 0) {
            this.shieldColor = 9895880;
        }
        this.readFiltersFromNBT(tagCompound);
    }

    private void readFiltersFromNBT(NBTTagCompound tagCompound) {
        this.filters.clear();
        NBTTagList filterList = tagCompound.func_150295_c("filters", 10);
        if (filterList != null) {
            for (int i = 0; i < filterList.func_74745_c(); ++i) {
                NBTTagCompound compound = filterList.func_150305_b(i);
                this.filters.add(AbstractShieldFilter.createFilter(compound));
            }
        }
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.stacks[i + 0] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("composed", this.shieldComposed);
        tagCompound.func_74757_a("active", this.shieldActive);
        tagCompound.func_74768_a("powerTimeout", this.powerTimeout);
        tagCompound.func_74768_a("templateMeta", this.templateMeta);
        this.shieldBlocks.writeToNBT(tagCompound, "coordinates");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74768_a("visMode", this.shieldRenderingMode.ordinal());
        tagCompound.func_74774_a(CMD_RSMODE, (byte)this.redstoneMode.ordinal());
        tagCompound.func_74774_a(CMD_DAMAGEMODE, (byte)this.damageMode.ordinal());
        tagCompound.func_74768_a("camoRenderPass", this.camoRenderPass);
        tagCompound.func_74768_a("shieldColor", this.shieldColor);
        this.writeFiltersToNBT(tagCompound);
    }

    private void writeFiltersToNBT(NBTTagCompound tagCompound) {
        NBTTagList filterList = new NBTTagList();
        for (ShieldFilter filter : this.filters) {
            NBTTagCompound compound = new NBTTagCompound();
            filter.writeToNBT(compound);
            filterList.func_74742_a((NBTBase)compound);
        }
        tagCompound.func_74782_a("filters", (NBTBase)filterList);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (ItemStack stack : this.stacks) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SHIELDVISMODE.equals(command)) {
            String m = args.get("mode").getString();
            this.setShieldRenderingMode(ShieldRenderingMode.getMode(m));
            return true;
        }
        if (CMD_APPLYCAMO.equals(command)) {
            this.camoRenderPass = args.get("pass").getInteger();
            this.updateShield();
            return true;
        }
        if (CMD_ADDFILTER.equals(command)) {
            int action = args.get("action").getInteger();
            String type = args.get("type").getString();
            String player = args.get("player").getString();
            int selected = args.get("selected").getInteger();
            this.addFilter(action, type, player, selected);
            return true;
        }
        if (CMD_DELFILTER.equals(command)) {
            int selected = args.get("selected").getInteger();
            this.delFilter(selected);
            return true;
        }
        if (CMD_UPFILTER.equals(command)) {
            int selected = args.get("selected").getInteger();
            this.upFilter(selected);
            return true;
        }
        if (CMD_DOWNFILTER.equals(command)) {
            int selected = args.get("selected").getInteger();
            this.downFilter(selected);
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRedstoneMode(RedstoneMode.getMode(m));
            return true;
        }
        if (CMD_DAMAGEMODE.equals(command)) {
            String m = args.get("mode").getString();
            this.setDamageMode(DamageTypeMode.getMode(m));
            return true;
        }
        if (CMD_SETCOLOR.equals(command)) {
            int color = args.get("color").getInteger();
            this.setShieldColor(color);
            return true;
        }
        return false;
    }

    public List executeWithResultList(String command, Map<String, Argument> args) {
        List rc = super.executeWithResultList(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getFilters".equals(command)) {
            return this.getFilters();
        }
        return null;
    }

    public boolean execute(String command, List list) {
        boolean rc = super.execute(command, list);
        if (rc) {
            return true;
        }
        if ("getFilters".equals(command)) {
            GuiShield.storeFiltersForClient(list);
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int index) {
        return this.stacks[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (this.stacks[index] != null) {
            if (this.stacks[index].field_77994_a <= amount) {
                ItemStack old = this.stacks[index];
                this.stacks[index] = null;
                this.func_70296_d();
                return old;
            }
            ItemStack its = this.stacks[index].func_77979_a(amount);
            if (this.stacks[index].field_77994_a == 0) {
                this.stacks[index] = null;
            }
            this.func_70296_d();
            return its;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "Shield Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }
}

