/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import java.text.DecimalFormat;
import mcjty.gui.RenderHelper;
import mcjty.rftools.blocks.screens.modulesclient.FormatStyle;
import net.minecraft.client.gui.FontRenderer;

public class ClientScreenModuleHelper {
    private static DecimalFormat dfCommas = new DecimalFormat("###,###");

    public static void renderLevel(FontRenderer fontRenderer, int xoffset, int currenty, Object[] screenData, String label, boolean hidebar, boolean hidetext, boolean showpct, boolean showdiff, int poscolor, int negcolor, int gradient1, int gradient2, FormatStyle formatStyle) {
        long contents;
        if (screenData == null) {
            return;
        }
        long maxContents = 0L;
        try {
            maxContents = (Long)screenData[1];
        }
        catch (Exception e) {
            return;
        }
        if (maxContents > 0L && !hidebar) {
            int width;
            contents = (Long)screenData[0];
            long value = contents * (long)(width = 80 - xoffset + 7 + 40) / maxContents;
            if (value < 0L) {
                value = 0L;
            } else if (value > (long)width) {
                value = width;
            }
            RenderHelper.drawHorizontalGradientRect((int)xoffset, (int)currenty, (int)((int)((long)xoffset + value)), (int)(currenty + 8), (int)gradient1, (int)gradient2);
        }
        if (!hidetext) {
            if (showdiff) {
                long diff = (Long)screenData[2];
                if (diff < 0L) {
                    fontRenderer.func_78276_b(diff + " " + label + "/t", xoffset, currenty, negcolor);
                } else {
                    fontRenderer.func_78276_b("+" + diff + " " + label + "/t", xoffset, currenty, poscolor);
                }
            } else if (maxContents > 0L) {
                contents = (Long)screenData[0];
                if (showpct) {
                    long value = contents * 100L / maxContents;
                    if (value < 0L) {
                        value = 0L;
                    } else if (value > 100L) {
                        value = 100L;
                    }
                    fontRenderer.func_78276_b(value + "%", xoffset, currenty, poscolor);
                } else {
                    fontRenderer.func_78276_b(ClientScreenModuleHelper.format(String.valueOf(contents), formatStyle) + label, xoffset, currenty, poscolor);
                }
            }
        }
    }

    public static String format(String in, FormatStyle style) {
        switch (style) {
            case MODE_FULL: {
                return in;
            }
            case MODE_COMPACT: {
                long contents = Long.parseLong(in);
                int unit = 1000;
                if (contents < (long)unit) {
                    return in;
                }
                int exp = (int)(Math.log(contents) / Math.log(unit));
                char pre = "KMGTP".charAt(exp - 1);
                return String.format("%.1f %s", (double)contents / Math.pow(unit, exp), Character.valueOf(pre));
            }
            case MODE_COMMAS: {
                return dfCommas.format(Long.parseLong(in));
            }
        }
        return in;
    }
}

