/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.monitor;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mcjty.rftools.blocks.monitor.LiquidMonitorBlockTileEntity;
import mcjty.rftools.blocks.monitor.RFMonitorBlockTileEntity;
import mcjty.rftools.blocks.monitor.RFMonitorMode;
import mcjty.varia.Coordinate;
import mcjty.varia.Logging;
import net.minecraft.tileentity.TileEntity;

public class PacketContentsMonitor
implements IMessage,
IMessageHandler<PacketContentsMonitor, IMessage> {
    private int x;
    private int y;
    private int z;
    private Coordinate monitor = new Coordinate(-1, -1, -1);
    private int alarmLevel = -1;
    private RFMonitorMode alarmMode = RFMonitorMode.MODE_OFF;

    public PacketContentsMonitor() {
    }

    public PacketContentsMonitor(int x, int y, int z, Coordinate monitor) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
        this.monitor = monitor;
    }

    public PacketContentsMonitor(int x, int y, int z, RFMonitorMode alarmMode, int alarmLevel) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
        this.alarmLevel = alarmLevel;
        this.alarmMode = alarmMode;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.monitor = new Coordinate(buf.readInt(), buf.readInt(), buf.readInt());
        this.alarmLevel = buf.readByte();
        this.alarmMode = RFMonitorMode.getModeFromIndex(buf.readByte());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.monitor.getX());
        buf.writeInt(this.monitor.getY());
        buf.writeInt(this.monitor.getZ());
        buf.writeByte(this.alarmLevel);
        buf.writeByte(this.alarmMode.getIndex());
    }

    public IMessage onMessage(PacketContentsMonitor message, MessageContext ctx) {
        TileEntity te = ctx.getServerHandler().field_147369_b.field_70170_p.func_147438_o(message.x, message.y, message.z);
        if (te instanceof RFMonitorBlockTileEntity) {
            RFMonitorBlockTileEntity monitorBlockTileEntity = (RFMonitorBlockTileEntity)te;
            if (message.monitor.getY() != -1) {
                monitorBlockTileEntity.setMonitor(message.monitor);
            }
            if (message.alarmLevel != -1) {
                monitorBlockTileEntity.setAlarm(message.alarmMode, message.alarmLevel);
            }
        } else if (te instanceof LiquidMonitorBlockTileEntity) {
            LiquidMonitorBlockTileEntity liquidMonitorBlockTileEntity = (LiquidMonitorBlockTileEntity)te;
            if (message.monitor.getY() != -1) {
                liquidMonitorBlockTileEntity.setMonitor(message.monitor);
            }
            if (message.alarmLevel != -1) {
                liquidMonitorBlockTileEntity.setAlarm(message.alarmMode, message.alarmLevel);
            }
        } else {
            Logging.log((String)"TileEntity is not a RFMonitorBlockTileEntity!");
        }
        return null;
    }
}

