/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic;

import java.util.Map;
import mcjty.entity.GenericTileEntity;
import mcjty.entity.SyncedObject;
import mcjty.entity.SyncedValue;
import mcjty.network.Argument;
import mcjty.rftools.blocks.logic.SequencerMode;
import mcjty.varia.BlockTools;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class SequencerTileEntity
extends GenericTileEntity {
    public static final String CMD_MODE = "mode";
    public static final String CMD_SETBIT = "setBit";
    public static final String CMD_SETBITS = "setBits";
    public static final String CMD_SETDELAY = "setDelay";
    private SequencerMode mode = SequencerMode.MODE_ONCE1;
    private long cycleBits = 0L;
    private int currentStep = -1;
    private boolean prevIn = false;
    private int delay = 1;
    private int timer = 0;
    private SyncedValue<Boolean> redstoneOut = new SyncedValue((Object)false);

    public SequencerTileEntity() {
        this.registerSyncedObject((SyncedObject)this.redstoneOut);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.timer = delay;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public SequencerMode getMode() {
        return this.mode;
    }

    public void setMode(SequencerMode mode) {
        this.mode = mode;
        switch (mode) {
            case MODE_ONCE1: 
            case MODE_ONCE2: 
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                this.currentStep = -1;
                break;
            }
            case MODE_LOOP1: 
            case MODE_LOOP2: 
            case MODE_STEP: {
                this.currentStep = 0;
            }
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean getCycleBit(int bit) {
        return (this.cycleBits >> bit & 1L) == 1L;
    }

    public void setCycleBit(int bit, boolean flag) {
        this.cycleBits = flag ? (this.cycleBits |= 1L << bit) : (this.cycleBits &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setCycleBits(int start, int stop, boolean flag) {
        for (int bit = start; bit <= stop; ++bit) {
            if (flag) {
                this.cycleBits |= 1L << bit;
                continue;
            }
            this.cycleBits &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected void checkStateServer() {
        boolean newout;
        super.checkStateServer();
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean newvalue = BlockTools.getRedstoneSignalIn((int)meta);
        boolean pulse = newvalue && !this.prevIn;
        this.prevIn = newvalue;
        if (pulse) {
            this.handlePulse();
        }
        this.func_70296_d();
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = this.delay;
        boolean bl = newout = this.currentStep != -1 && this.getCycleBit(this.currentStep);
        if (newout != (Boolean)this.redstoneOut.getValue()) {
            this.redstoneOut.setValue((Object)newout);
            this.notifyBlockUpdate();
        }
        this.handleCycle(newvalue);
    }

    private void handleCycle(boolean redstone) {
        switch (this.mode) {
            case MODE_ONCE1: 
            case MODE_ONCE2: {
                if (this.currentStep == -1) break;
                this.nextStepAndStop();
                break;
            }
            case MODE_LOOP1: {
                this.nextStep();
                break;
            }
            case MODE_LOOP2: {
                this.nextStep();
                break;
            }
            case MODE_LOOP3: {
                if (!redstone) break;
                this.nextStep();
                break;
            }
            case MODE_LOOP4: {
                if (redstone) {
                    this.nextStep();
                    break;
                }
                this.currentStep = -1;
                break;
            }
        }
    }

    private void handlePulse() {
        switch (this.mode) {
            case MODE_ONCE1: {
                if (this.currentStep != -1) break;
                this.currentStep = 0;
                break;
            }
            case MODE_ONCE2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP1: {
                break;
            }
            case MODE_LOOP2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                break;
            }
            case MODE_STEP: {
                this.nextStep();
            }
        }
    }

    private void nextStep() {
        ++this.currentStep;
        if (this.currentStep >= 64) {
            this.currentStep = 0;
        }
    }

    private void nextStepAndStop() {
        ++this.currentStep;
        if (this.currentStep >= 64) {
            this.currentStep = -1;
        }
    }

    protected int updateMetaData(int meta) {
        meta = super.updateMetaData(meta);
        Boolean value = (Boolean)this.redstoneOut.getValue();
        return BlockTools.setRedstoneSignalOut((int)meta, (boolean)(value == null ? false : value));
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.redstoneOut.setValue((Object)tagCompound.func_74767_n("rs"));
        this.currentStep = tagCompound.func_74762_e("step");
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.timer = tagCompound.func_74762_e("timer");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.cycleBits = tagCompound.func_74763_f("bits");
        int m = tagCompound.func_74762_e(CMD_MODE);
        this.mode = SequencerMode.values()[m];
        this.delay = tagCompound.func_74762_e("delay");
        if (this.delay == 0) {
            this.delay = 1;
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        Boolean value = (Boolean)this.redstoneOut.getValue();
        tagCompound.func_74757_a("rs", value == null ? false : value);
        tagCompound.func_74768_a("step", this.currentStep);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        tagCompound.func_74768_a("timer", this.timer);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74772_a("bits", this.cycleBits);
        tagCompound.func_74768_a(CMD_MODE, this.mode.ordinal());
        tagCompound.func_74768_a("delay", this.delay);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_MODE.equals(command)) {
            String m = args.get(CMD_MODE).getString();
            this.setMode(SequencerMode.getMode(m));
            return true;
        }
        if (CMD_SETBIT.equals(command)) {
            this.setCycleBit(args.get("bit").getInteger(), args.get("choice").getBoolean());
            return true;
        }
        if (CMD_SETBITS.equals(command)) {
            this.setCycleBits(args.get("start").getInteger(), args.get("stop").getInteger(), args.get("choice").getBoolean());
            return true;
        }
        if (CMD_SETDELAY.equals(command)) {
            this.setDelay(args.get("delay").getInteger());
            return true;
        }
        return false;
    }
}

